/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.PersonOtherParametersMainPanelAuthorityLetterVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonOtherParametersMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.person.uidata.PersonUIData;
import com.gridnine.xtrip.common.model.profile.AuthorityLetter;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.system.BinaryData;
import java.time.LocalDate;
import java.util.Date;

final class PersonOtherSettingsTileHelper {
    private PersonOtherSettingsTileHelper() {
    }

    static void toVM(Person model, PersonUIData supplement, PersonOtherParametersMainPanelVM full) {
        full.getIrrelevant().setIrrelevant(model.isDisabled());
        VMHelper.transfer(model.getAuthorityLetters(), full.getAuthorityLetters(), letter -> new PersonOtherParametersMainPanelAuthorityLetterVM(), (itemModel, itemVM) -> {
            itemVM.setName(itemModel.getName());
            itemVM.setNumber(itemModel.getNumber());
            itemVM.setDate(DateUtils.asLocalDate((Date)itemModel.getDate()));
            itemVM.setStartDate(DateUtils.asLocalDate((Date)itemModel.getStartDate()));
            itemVM.setEndDate(DateUtils.asLocalDate((Date)itemModel.getEndDate()));
            itemVM.getPositions().clear();
            itemVM.getPositions().addAll(itemModel.getPositions());
            itemVM.getFinanceDocumentTypes().clear();
            itemVM.getFinanceDocumentTypes().addAll(itemModel.getFinanceDocumentTypes());
        });
        VMHelper.metadataToVM(supplement.getMetadataUiData(), model.getMetadata(), full.getPersonMetadata().getValueHolders());
        if (model.getSignatureImage() != null) {
            BinaryData bd = new BinaryData();
            bd.setData(model.getSignatureImage());
            full.setSignatureImage(bd);
        }
        full.setComment(model.getNotes());
    }

    static void fromVM(PersonOtherParametersMainPanelVM full, PersonUIData supplement, Person model) {
        model.setDisabled(full.getIrrelevant().isIrrelevant());
        VMHelper.transfer(full.getAuthorityLetters(), model.getAuthorityLetters(), vm -> new AuthorityLetter(), (itemVM, itemModel) -> {
            itemModel.setName(itemVM.getName());
            itemModel.setNumber(itemVM.getNumber());
            itemModel.setDate(DateUtils.asDate((LocalDate)itemVM.getDate()));
            itemModel.setStartDate(DateUtils.asDate((LocalDate)itemVM.getStartDate()));
            itemModel.setEndDate(DateUtils.asDate((LocalDate)itemVM.getEndDate()));
            itemModel.getPositions().clear();
            itemModel.getPositions().addAll(itemVM.getPositions());
            itemModel.getFinanceDocumentTypes().clear();
            itemModel.getFinanceDocumentTypes().addAll(itemVM.getFinanceDocumentTypes());
        });
        VMHelper.metadataFromVM(supplement.getMetadataUiData(), model.getMetadata(), full.getPersonMetadata().getValueHolders(), PersonMetadata::new);
        model.setSignatureImage(full.getSignatureImage() == null ? null : full.getSignatureImage().getData());
        model.setNotes(full.getComment());
    }
}

