/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person;

import com.gridnine.xtrip.client.fx.model.profile.PersonCostCodeVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonUdidsVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.person.uidata.PersonUIData;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class PersonUdidsTileHelper {
    private PersonUdidsTileHelper() {
    }

    static void toVM(Person model, PersonUIData supplement, PersonUdidsVM full) {
        ArrayList<PersonCostCode> allCostCodes = new ArrayList<PersonCostCode>(model.getCostCodes());
        PersonUdidsTileHelper.updateMaskUdids(supplement, allCostCodes);
        supplement.getCostCodesToFill().stream().filter(costCodeToFill -> model.getCostCodes().stream().noneMatch(costCode -> MiscUtil.equals((Object)costCode.getOrganization(), (Object)costCodeToFill.getOrganization()) && MiscUtil.equals((Object)costCode.getCostCodeProperties(), (Object)costCodeToFill.getCostCodeProperties()))).forEach(allCostCodes::add);
        VMHelper.transfer(allCostCodes, full.getContent(), costCode -> new PersonCostCodeVM(), (costCode, vm) -> {
            vm.setOrganization(costCode.getOrganization());
            vm.getValue().set((Object)costCode.getValue());
            vm.setLocalValue(costCode.getLocalValue());
            vm.setEnglishValue(costCode.getEnglishValue());
            vm.setProperty(costCode.getCostCodeProperties());
            vm.setAutoAdded(supplement.getCostCodesToFill().contains(costCode));
        });
    }

    private static void updateMaskUdids(PersonUIData supplement, List<PersonCostCode> allCostCodes) {
        allCostCodes.stream().filter(personCostCode -> personCostCode.getCostCodeProperties() != null).forEach(personCostCode -> personCostCode.getCostCodeProperties().setMask((String)supplement.getMaskUdidsOrganizationMap().get(personCostCode.getCostCodeProperties().getCategory())));
    }

    static void fromVM(PersonUdidsVM full, Person model) {
        List costCodeVMs = full.getContent().stream().filter(costCode -> !costCode.isAutoAdded() || TextUtil.nonBlank((String)((String)costCode.getValue().get()))).collect(Collectors.toList());
        Map<String, CostCodeProperties> costCodePropMap = model.getCostCodes().stream().map(CostCode::getCostCodeProperties).filter(Objects::nonNull).collect(Collectors.toMap(BaseIdentity::getUid, el -> el, (prop1, prop2) -> prop2));
        VMHelper.transfer(costCodeVMs, model.getCostCodes(), vm -> new PersonCostCode(), (vm, costCode) -> {
            costCode.setOrganization(vm.getOrganization());
            costCode.setValue((String)vm.getValue().get());
            costCode.setLocalValue(vm.getLocalValue());
            costCode.setEnglishValue(vm.getEnglishValue());
            CostCodeProperties property = null;
            if (vm.getProperty() != null) {
                property = costCodePropMap.getOrDefault(vm.getProperty().getUid(), vm.getProperty());
                property.setType(vm.getProperty().getType());
                property.setCategory(vm.getProperty().getCategory());
                property.setDisplayType(vm.getProperty().getDisplayType());
                property.setName(vm.getProperty().getName());
            }
            costCode.setCostCodeProperties(property);
        });
    }
}

