/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.profile.PersonAgentAccessOptionsMainPanelController;
import com.gridnine.xtrip.client.fx.model.profile.PersonAgentAccessOptionsMainPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonSalesPointReferenceVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpace;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.gdsnames.GdsSettingsHelper;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;

public class PersonAgentAccessOptionsMainPanelControllerInterceptor
extends ControllerInterceptor<PersonAgentAccessOptionsMainPanelVM, PersonAgentAccessOptionsMainPanelController> {
    protected Class<PersonAgentAccessOptionsMainPanelController> getControllerClass() {
        return PersonAgentAccessOptionsMainPanelController.class;
    }

    protected void onCreate(PersonAgentAccessOptionsMainPanelController controller) {
        GdsSettingsHelper.configureComboBoxWidgetColumn((ComboBoxWidgetColumn)((TableWidget)controller.getView().getGdsReferencesCard().getContent()).getColumn("system"));
        ((EntityBoxWidgetColumn)((TableWidget)controller.getView().getGdsReferencesCard().getContent()).getColumn("agency")).setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ((EntityBoxWidgetColumn)((TableWidget)controller.getView().getGdsReferencesCard().getContent()).getColumn("salesPoint")).setListParametersSupplier(ControllerInterceptorsHelper::getSalesPoints);
        TableWidget salesPointsTableWidget = (TableWidget)controller.getView().getSalesPointsCard().getContent();
        ((EntityBoxWidgetColumn)salesPointsTableWidget.getColumn("salesPoint")).setListParametersSupplier(() -> this.getAvailableSalesPoints(controller));
        salesPointsTableWidget.setOnRowsAction(action -> {
            if (action.getEventType().equals(TableRowEvent.ROW_ADD)) {
                Integer rowInd = action.getRowIndex();
                EntityBoxWidget<SalesPoint> salesPointWidget = this.getSalesPointWidget((TableWidget<PersonSalesPointReferenceVM>)salesPointsTableWidget, rowInd);
                EntityBoxWidget<Organization> agencyWidget = this.getSalesPointAgencyWidget((TableWidget<PersonSalesPointReferenceVM>)salesPointsTableWidget, rowInd);
                salesPointWidget.valueProperty().addListener((obj, oldValue, newValue) -> this.setSalesPointDataFields(agencyWidget, (EntityReference<SalesPoint>)newValue));
            }
        });
    }

    private EntityBoxWidget<SalesPoint> getSalesPointWidget(TableWidget<PersonSalesPointReferenceVM> salesPointsTableWidget, int rowInd) {
        return (EntityBoxWidget)salesPointsTableWidget.getColumn("salesPoint").getWidget(rowInd);
    }

    private EntityBoxWidget<Organization> getSalesPointAgencyWidget(TableWidget<PersonSalesPointReferenceVM> salesPointsTableWidget, int rowInd) {
        return (EntityBoxWidget)salesPointsTableWidget.getColumn("agency").getWidget(rowInd);
    }

    private BooleanValueWidget getSalesPointDefaultWidget(TableWidget<PersonSalesPointReferenceVM> salesPointsTableWidget, int rowInd) {
        return (BooleanValueWidget)salesPointsTableWidget.getColumn("defaultForOrg").getWidget(rowInd);
    }

    private void setSalesPointDataFields(EntityBoxWidget<Organization> agencyWidget, EntityReference<SalesPoint> salesPointRef) {
        if (salesPointRef == null) {
            agencyWidget.valueProperty().setValue(null);
        } else {
            Notifications.get().submitTask(() -> {
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer salesPointCtr = entityService.load(ServiceInvocationContext.get(), salesPointRef);
                EntityReference agency = salesPointCtr == null ? null : ((SalesPoint)salesPointCtr.getEntity()).getAgency();
                FxUtil.waitForFxThread(() -> agencyWidget.valueProperty().setValue((Object)agency));
            }, ObservableMutex.lookup(agencyWidget));
        }
    }

    private IndexListParameters<SalesPoint, SalesPointIndex> getAvailableSalesPoints(PersonAgentAccessOptionsMainPanelController controller) {
        List<EntityReference<Organization>> employmentOrgs = this.getEmploymentOrgs(controller);
        TableWidget salesPointsTableWidget = (TableWidget)controller.getView().getSalesPointsCard().getContent();
        ArrayList<String> existsSalesPointUids = new ArrayList<String>();
        for (int rowInd = 0; rowInd < salesPointsTableWidget.getRowsCount(); ++rowInd) {
            EntityBoxWidget<SalesPoint> salesPointWidget = this.getSalesPointWidget((TableWidget<PersonSalesPointReferenceVM>)salesPointsTableWidget, rowInd);
            if (salesPointWidget.getValue() == null) continue;
            existsSalesPointUids.add(salesPointWidget.getValue().getUid());
        }
        IndexListParameters<SalesPoint, SalesPointIndex> result = ControllerInterceptorsHelper.getSalesPoints();
        if (!employmentOrgs.isEmpty()) {
            result.getSearchCriterions().add(SearchCriterion.in((String)SalesPointIndex.Property.agency.name(), (Object[])employmentOrgs.toArray()));
        } else {
            result.getSearchCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)"0"));
        }
        if (!existsSalesPointUids.isEmpty()) {
            result.getSearchCriterions().add(SearchCriterion.not((SearchCriterion)SearchCriterion.in((String)"containerUid", (Object[])existsSalesPointUids.toArray())));
        }
        return result;
    }

    private List<EntityReference<Organization>> getEmploymentOrgs(PersonAgentAccessOptionsMainPanelController controller) {
        RootEntityPane rootPane = RootEntityPane.lookup((Node)controller.getView());
        if (rootPane == null) {
            return Collections.emptyList();
        }
        PersonSpace personSpace = (PersonSpace)rootPane.getEditor();
        ArrayList<EntityReference<Organization>> employmentOrgs = new ArrayList<EntityReference<Organization>>();
        TableWidget personEmploymentTableWidget = (TableWidget)((PersonMainPanel)personSpace.getMainTile().getFullNode()).getEmploymentsCard().getContent();
        for (int rowInd = 0; rowInd < personEmploymentTableWidget.getRowsCount(); ++rowInd) {
            EntityBoxWidget employmentOrgWidget = (EntityBoxWidget)personEmploymentTableWidget.getColumn("organization").getWidget(rowInd);
            if (employmentOrgWidget.getValue() == null) continue;
            employmentOrgs.add((EntityReference<Organization>)employmentOrgWidget.getValue());
        }
        return employmentOrgs;
    }

    protected void validateData(PersonAgentAccessOptionsMainPanelController controller, List<Message> messages) {
        TableWidget salesPointsTableWidget = (TableWidget)controller.getView().getSalesPointsCard().getContent();
        boolean existsEmptySalesPoint = false;
        ArrayList<EntityReference> agenciesWithDefault = new ArrayList<EntityReference>();
        for (int rowInd = 0; rowInd < salesPointsTableWidget.getRowsCount(); ++rowInd) {
            EntityBoxWidget<SalesPoint> salesPointWidget = this.getSalesPointWidget((TableWidget<PersonSalesPointReferenceVM>)salesPointsTableWidget, rowInd);
            EntityBoxWidget<Organization> agencyWidget = this.getSalesPointAgencyWidget((TableWidget<PersonSalesPointReferenceVM>)salesPointsTableWidget, rowInd);
            BooleanValueWidget isDefaultWidget = this.getSalesPointDefaultWidget((TableWidget<PersonSalesPointReferenceVM>)salesPointsTableWidget, rowInd);
            EntityReference salesPointRef = salesPointWidget.getValue();
            EntityReference agencyRef = agencyWidget.getValue();
            if (salesPointRef == null) {
                existsEmptySalesPoint = true;
                continue;
            }
            if (agencyRef == null) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.person_agentAccess_salesPoints_emptySalesPointAgency, (Object[])new Object[]{salesPointRef}));
                continue;
            }
            if (!isDefaultWidget.getValue()) continue;
            if (agenciesWithDefault.contains(agencyRef)) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.person_agentAccess_salesPoints_manyDefaultAgencySalesPoints, (Object[])new Object[]{agencyRef}));
                continue;
            }
            agenciesWithDefault.add(agencyRef);
        }
        if (existsEmptySalesPoint) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.person_agentAccess_salesPoints_emptySalesPoint, (Object[])new Object[0]));
        }
    }
}

