/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.DictBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.profile.PersonContactsPanelController;
import com.gridnine.xtrip.client.fx.model.profile.PersonContactsPanelVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;

public class PersonContactsPanelControllerInterceptor
extends ControllerInterceptor<PersonContactsPanelVM, PersonContactsPanelController> {
    private static final List<AddressType> ADDRESS_TYPES = Arrays.asList(AddressType.BUSINESS, AddressType.HOME);

    protected Class<PersonContactsPanelController> getControllerClass() {
        return PersonContactsPanelController.class;
    }

    protected void onCreate(PersonContactsPanelController controller) {
        TableWidget view = (TableWidget)controller.getAddresses().getView();
        DictBoxWidgetColumn cityColumn = (DictBoxWidgetColumn)view.getColumn("city");
        DictBoxWidgetColumn countryColumn = (DictBoxWidgetColumn)view.getColumn("country");
        ComboBoxWidgetColumn typeColumn = (ComboBoxWidgetColumn)view.getColumn("type");
        EntityBoxWidgetColumn organizationColumn = (EntityBoxWidgetColumn)view.getColumn("organization");
        typeColumn.setItemsSupplier(() -> ADDRESS_TYPES);
        organizationColumn.setItemsSupplier(() -> {
            ArrayList<EntityReference> result = new ArrayList<EntityReference>();
            EntityContainer ctr = RootEntityPane.lookup((Node)controller.getView()).getData().getContainer();
            if (ctr != null) {
                for (PersonEmployment empl : ((Person)ctr.getEntity()).getEmployments()) {
                    result.add(empl.getOrganization());
                }
            }
            return result;
        }, false);
        view.setOnRowsAction(event -> {
            if (TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                int idx = event.getRowIndex();
                DictBoxWidget cityWidget = (DictBoxWidget)cityColumn.getWidget(idx);
                DictBoxWidget countryWidget = (DictBoxWidget)countryColumn.getWidget(idx);
                cityWidget.valueProperty().addListener((obj, oldValue, newValue) -> {
                    if (countryWidget.valueProperty().get() == null) {
                        Notifications.get().submitTask(() -> {
                            try {
                                FxUtil.waitForFxThread(() -> countryWidget.setDisable(true));
                                ServiceInvocationContext sic = ServiceInvocationContext.get();
                                DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
                                GeoLocation city = (GeoLocation)dictService.load(sic, newValue);
                                if (city != null) {
                                    FxUtil.waitForFxThread(() -> {
                                        countryWidget.valueProperty().set((Object)city.getCountry());
                                        countryWidget.setDisable(false);
                                    });
                                }
                            }
                            catch (Exception e) {
                                ErrorHandler.handle((Throwable)e);
                            }
                        }, ObservableMutex.lookup((Node)controller.getView()));
                    }
                });
                cityWidget.setListParametersSupplier(() -> {
                    DictListParameters dictListParameters = new DictListParameters();
                    TableColumnSettings codes = new TableColumnSettings();
                    codes.setId(BaseDictionary.Property.codeVariants.name());
                    codes.setDisplayName(Messages.Codes);
                    codes.setRenderer((Renderer)StandardRenderers.CODE_VARIANTS);
                    TableColumnSettings names = new TableColumnSettings();
                    names.setId(BaseDictionary.Property.translations.name());
                    names.setDisplayName(Messages.Names);
                    names.setRenderer((Renderer)StandardRenderers.TRANSLATIONS);
                    TableColumnSettings country = new TableColumnSettings();
                    country.setId(GeoLocation.Property.country.name());
                    country.setDisplayName(Messages.Country);
                    country.setRenderer((Renderer)StandardRenderers.GENERIC);
                    dictListParameters.getColumns().add(codes);
                    dictListParameters.getColumns().add(names);
                    dictListParameters.getColumns().add(country);
                    dictListParameters.getFilters().add(codes);
                    dictListParameters.getFilters().add(names);
                    dictListParameters.getFilters().add(country);
                    dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(GeoLocation.Property.type.name(), new Object[]{LocationType.CITY}));
                    if (countryWidget.valueProperty().get() != null) {
                        dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(GeoLocation.Property.country.name(), new Object[]{countryWidget.valueProperty().get()}));
                    }
                    return dictListParameters;
                });
            }
        });
    }
}

