/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.profile.PersonGeneralParametersPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanelController;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.notifications.EventNotificationTool;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.system.model.RegionalType;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javafx.util.StringConverter;

public class PersonGeneralParametersControllerInterceptor
extends ControllerInterceptor<PersonMainPanelVM, PersonMainPanelController> {
    private static final String EMPLOYEE_CATEGORY_COLUMN_NAME = "employeeCategory";
    private static final String ORGANIZATION_REFERENCE_COLUMN_NAME = "organization";
    private static final StringConverter<EmployeeCategory> EMPLOYEE_CONVERTER = new StringConverter<EmployeeCategory>(){

        public String toString(EmployeeCategory object) {
            if (object != null && object.getName() != null) {
                return object.getName().toString();
            }
            return null;
        }

        public EmployeeCategory fromString(String string) {
            return null;
        }
    };

    protected Class<PersonMainPanelController> getControllerClass() {
        return PersonMainPanelController.class;
    }

    protected void onCreate(PersonMainPanelController controller) {
        EntityBoxWidgetColumn column = (EntityBoxWidgetColumn)((TableWidget)controller.getView().getEmploymentsCard().getContent()).getColumn(ORGANIZATION_REFERENCE_COLUMN_NAME);
        column.setListParametersSupplier(() -> {
            StringBuilder builder = new StringBuilder();
            for (PersonType type : ((PersonGeneralParametersPanel)controller.getView().getGeneralCard().getContent()).getTypesNode().getValues()) {
                builder.append(type.name());
            }
            switch (builder.toString()) {
                case "PASSENGER": {
                    return ControllerInterceptorsHelper.getClients();
                }
                case "AGENT": {
                    return ControllerInterceptorsHelper.getAgencies();
                }
            }
            return ControllerInterceptorsHelper.getClientsAndAgencies();
        });
        Set personRegionalPropertiesTypes = Collections.singleton(RegionalType.RU);
        if (Prefetched.getData().getRegionalSettings() != null && !Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes().isEmpty()) {
            personRegionalPropertiesTypes = Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes();
        }
        ((PersonGeneralParametersPanel)controller.getView().getGeneralCard().getContent()).getTypesNode().setItemsSupplier(Suppliers.createEnumSupplier(PersonType.class));
        ((PersonGeneralParametersPanel)controller.getView().getGeneralCard().getContent()).getTitleNode().setSortItems(false);
        ((PersonGeneralParametersPanel)controller.getView().getGeneralCard().getContent()).getRegistrationIdCell().setHidden(!personRegionalPropertiesTypes.contains(RegionalType.RU));
        ((PersonGeneralParametersPanel)controller.getView().getGeneralCard().getContent()).getRegistrationIdKzCell().setHidden(!personRegionalPropertiesTypes.contains(RegionalType.KZ));
        PersonGeneralParametersControllerInterceptor.setupEmployeeCategoryColumn(controller);
        final PersonMainPanel panel = controller.getView();
        EventNotificationTool.install(((PersonGeneralParametersPanel)panel.getGeneralCard().getContent()).getBirthdayNode(), new EventNotificationTool.Configurator(){

            @Override
            public String getTitle() {
                return Messages.Notification_birthday_title;
            }

            @Override
            public String getText() {
                LocalDate birthDay;
                Gender gender;
                StringBuilder builder = new StringBuilder();
                String name = this.getName();
                if (!TextUtil.isBlank((String)name)) {
                    builder.append(Messages.Notification_general_name).append(": ").append(name).append('\n');
                }
                if ((gender = (Gender)((PersonGeneralParametersPanel)panel.getGeneralCard().getContent()).getGenderNode().getValue()) != null) {
                    builder.append(Messages.Notification_general_gender).append(": ").append(gender).append('\n');
                }
                if ((birthDay = ((PersonGeneralParametersPanel)panel.getGeneralCard().getContent()).getBirthdayNode().getValue()) != null) {
                    builder.append(Messages.Notification_general_birthday).append(": ").append((String)StandardRenderers.DATE.apply((Object)birthDay)).append('\n');
                }
                return builder.toString();
            }

            @Override
            public EntityReference<?> getNestedEntityReference() {
                Object uid = panel.getProperties().get((Object)"model-uid");
                return uid == null ? null : new EntityReference(uid.toString(), Person.class, this.getName());
            }

            private String getName() {
                return TextUtil.buildFullName((PersonalName)new PersonalName(){

                    public void setMiddleName(String value) {
                    }

                    public void setLastName(String value) {
                    }

                    public void setFirstName(String value) {
                    }

                    public String getMiddleName() {
                        return L10nStringHelper.getValue((L10nString)((PersonGeneralParametersPanel)panel.getGeneralCard().getContent()).getMiddleNameNode().getValue(), (Locale)LocaleHelper.getCurrentLocale());
                    }

                    public String getLastName() {
                        return L10nStringHelper.getValue((L10nString)((PersonGeneralParametersPanel)panel.getGeneralCard().getContent()).getLastNameNode().getValue(), (Locale)LocaleHelper.getCurrentLocale());
                    }

                    public String getFirstName() {
                        return L10nStringHelper.getValue((L10nString)((PersonGeneralParametersPanel)panel.getGeneralCard().getContent()).getFirstNameNode().getValue(), (Locale)LocaleHelper.getCurrentLocale());
                    }
                });
            }
        });
    }

    private static void setupEmployeeCategoryColumn(PersonMainPanelController controller) {
        EntityBoxWidgetColumn organizationColumn = (EntityBoxWidgetColumn)((TableWidget)controller.getView().getEmploymentsCard().getContent()).getColumn(ORGANIZATION_REFERENCE_COLUMN_NAME);
        ComboBoxWidgetColumn employeeCategoryColumn = (ComboBoxWidgetColumn)((TableWidget)controller.getView().getEmploymentsCard().getContent()).getColumn(EMPLOYEE_CATEGORY_COLUMN_NAME);
        employeeCategoryColumn.setConverter(EMPLOYEE_CONVERTER);
        ((TableWidget)controller.getView().getEmploymentsCard().getContent()).addEventHandler(TableRowEvent.ROW_ADD, event -> {
            EntityBoxWidget organizationWidget = (EntityBoxWidget)organizationColumn.getWidget(event.getRowIndex().intValue());
            ComboBoxWidget categoryWidget = (ComboBoxWidget)employeeCategoryColumn.getWidget(event.getRowIndex().intValue());
            categoryWidget.setLive(true);
            categoryWidget.setAsync(true);
            categoryWidget.setItemsSupplier(() -> {
                if (organizationWidget.getValue() == null) {
                    return Collections.emptyList();
                }
                try {
                    return ((Organization)((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), organizationWidget.getValue()).getEntity()).getEmployeeCategories();
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                    return Collections.emptyList();
                }
            });
        });
    }
}

