/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.SuperColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.service.IndexListService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointOtherParametersPanel;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPccPanel;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPccPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPccsFiltersPanel;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPccsTableItemVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointValidatorPanel;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointValidatorPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointValidatorsFiltersPanel;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointValidatorsTableItemVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PlaceOfSalesIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class SalesPointControllerInterceptor
extends ControllerInterceptor<SalesPointSpaceVM, SalesPointSpaceController> {
    protected Class<SalesPointSpaceController> getControllerClass() {
        return SalesPointSpaceController.class;
    }

    protected void onCreate(SalesPointSpaceController controller) {
        SalesPointControllerInterceptor.setStringConverters(controller);
        controller.getOverview().getView().getAgentsNode().setOnAction(event -> SalesPointControllerInterceptor.openAgentsList(controller));
        BigTableWidget pccsTable = (BigTableWidget)controller.getView().getPccsTile().getFullNode();
        pccsTable.setFiltering(() -> SalesPointControllerInterceptor.createPccsFiltersPanel(controller), SalesPointControllerInterceptor::getPccsFilteringPredicate, true);
        ((SuperColumn)pccsTable.getColumn("fullData")).setPopupCloseHandler((rowIndex, panel) -> this.handlePccPanelClose((BigTableWidget<SalesPointPccsTableItemVM>)pccsTable, (int)rowIndex, (SalesPointPccPanel)panel));
        BigTableWidget validatorsTable = (BigTableWidget)controller.getView().getValidatorsTile().getFullNode();
        validatorsTable.setFiltering(() -> SalesPointControllerInterceptor.createValidatorFilterPanel(controller), SalesPointControllerInterceptor::getValidatorsFilteringPredicate, true);
        ((SuperColumn)validatorsTable.getColumn("fullData")).setPopupCloseHandler((rowIndex, panel) -> this.handleValidatorPanelClose((BigTableWidget<SalesPointValidatorsTableItemVM>)validatorsTable, (int)rowIndex, (SalesPointValidatorPanel)panel));
    }

    private void handlePccPanelClose(BigTableWidget<SalesPointPccsTableItemVM> pccsTable, int rowIndex, SalesPointPccPanel panel) {
        if (pccsTable.getViewState().isImmutable()) {
            return;
        }
        pccsTable.setCellValue(rowIndex, "bookingSystem", panel.getBookingSystemNode().getValue() == null ? null : ((GdsName)panel.getBookingSystemNode().getValue()).toString());
        pccsTable.setCellValue(rowIndex, "id", (Object)panel.getIdNode().getValue());
        pccsTable.setCellValue(rowIndex, "startDate", StandardRenderers.DATE.apply((Object)panel.getStartDateNode().getValue()));
        pccsTable.setCellValue(rowIndex, "endDate", StandardRenderers.DATE.apply((Object)panel.getEndDateNode().getValue()));
    }

    private void handleValidatorPanelClose(BigTableWidget<SalesPointValidatorsTableItemVM> validatorsTable, int rowIndex, SalesPointValidatorPanel panel) {
        if (validatorsTable.getViewState().isImmutable()) {
            return;
        }
        validatorsTable.setCellValue(rowIndex, "number", (Object)panel.getNumberNode().getValue());
        validatorsTable.setCellValue(rowIndex, "blankOwner", panel.getBlankOwnerNode().getValue() == null ? null : panel.getBlankOwnerNode().getValue().getCaption());
        validatorsTable.setCellValue(rowIndex, "supplier", panel.getSupplierNode().getValue() == null ? null : panel.getSupplierNode().getValue().getCaption());
        validatorsTable.setCellValue(rowIndex, "agency", panel.getAgencyNode().getValue() == null ? null : panel.getAgencyNode().getValue().getCaption());
        validatorsTable.setCellValue(rowIndex, "pcc", panel.getPccRefNode().getValue() == null ? null : ((EntityReference)panel.getPccRefNode().getValue()).getCaption());
        validatorsTable.setCellValue(rowIndex, "startDate", StandardRenderers.DATE.apply((Object)panel.getStartDateNode().getValue()));
        validatorsTable.setCellValue(rowIndex, "endDate", StandardRenderers.DATE.apply((Object)panel.getEndDateNode().getValue()));
    }

    protected void afterReadData(SalesPointSpaceController controller, SalesPointSpaceVM model) {
        ((BigTableWidget)controller.getView().getPccsTile().getFullNode()).applyFiltering();
        ((BigTableWidget)controller.getView().getValidatorsTile().getFullNode()).applyFiltering();
    }

    private static SalesPointPccsFiltersPanel createPccsFiltersPanel(SalesPointSpaceController controller) {
        SalesPointPccsFiltersPanel filtersPanel = new SalesPointPccsFiltersPanel(false);
        filtersPanel.getBookingSystemNode().setItemsSupplier(() -> {
            List existingPanels = controller.getData() == null ? Collections.emptyList() : controller.getData().getPccsFull();
            Set existingGdsNames = existingPanels.stream().map(vm -> vm.getFullData().getBookingSystem()).collect(Collectors.toSet());
            return new ArrayList(existingGdsNames);
        });
        filtersPanel.getBookingSystemNode().setLive(true);
        return filtersPanel;
    }

    private static Predicate<SalesPointPccsTableItemVM> getPccsFilteringPredicate(SalesPointPccsFiltersPanel filtersPanel) {
        return vm -> {
            String searchText;
            SalesPointPccPanelVM data = vm.getFullData();
            boolean result = true;
            GdsName gdsName = (GdsName)filtersPanel.getBookingSystemNode().getValue();
            if (gdsName != null) {
                boolean bl = result = gdsName == data.getBookingSystem();
            }
            if ((searchText = filtersPanel.getCodeNode().getValue()) != null && !searchText.isEmpty()) {
                result &= data.getId() != null && data.getId().toLowerCase().contains(searchText.toLowerCase());
            }
            return result &= ControllerInterceptorsHelper.matches(filtersPanel.getOpenedDateNode().getValue(), filtersPanel.getClosedDateNode().getValue(), data.getStartDate(), data.getEndDate());
        };
    }

    private static Predicate<SalesPointValidatorsTableItemVM> getValidatorsFilteringPredicate(SalesPointValidatorsFiltersPanel filtersPanel) {
        return vm -> {
            EntityReference agency;
            EntityReference supplier;
            EntityReference blankOwner;
            SalesPointValidatorPanelVM data = vm.getFullData();
            boolean result = true;
            String searchText = filtersPanel.getNumberNode().getValue();
            if (searchText != null && !searchText.isEmpty()) {
                result &= data.getNumber() != null && data.getNumber().toLowerCase().contains(searchText.toLowerCase());
            }
            if ((blankOwner = filtersPanel.getBlankOwnerNode().getValue()) != null) {
                result &= MiscUtil.equals((Object)blankOwner, (Object)data.getBlankOwner());
            }
            if ((supplier = filtersPanel.getSupplierNode().getValue()) != null) {
                result &= MiscUtil.equals((Object)supplier, (Object)data.getSupplier());
            }
            if ((agency = filtersPanel.getAgencyNode().getValue()) != null) {
                result &= MiscUtil.equals((Object)agency, (Object)data.getAgency());
            }
            EntityReference filterPccRef = (EntityReference)filtersPanel.getPccRefNode().getValue();
            EntityReference viewPccRef = data.getPccRef();
            if (filterPccRef != null) {
                result &= viewPccRef != null && MiscUtil.equals((Object)filterPccRef, (Object)viewPccRef);
            }
            return result &= ControllerInterceptorsHelper.matches(filtersPanel.getStartDateNode().getValue(), filtersPanel.getEndDateNode().getValue(), data.getStartDate(), data.getEndDate());
        };
    }

    private static void openAgentsList(SalesPointSpaceController controller) {
        DataTransferPackage dtp = RootEntityPane.lookup((Node)controller.getView()).getData();
        if (dtp == null || dtp.getContainer() == null) {
            Notifications.get().showFlashNotification(Messages.Save_object, null);
            return;
        }
        EntityReference ref = dtp.getContainer().toReference();
        IndexListParameters parameters = new IndexListParameters();
        parameters.setIndexType(PlaceOfSalesIndex.class);
        parameters.getSortings().put(PlaceOfSalesIndex.Property.code.name(), SortOrder.ASC);
        parameters.getSearchCriterions().add(SearchCriterion.eq((String)PlaceOfSalesIndex.Property.salesPoint.name(), (Object)ref));
        parameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PlaceOfSalesIndex.Property.opened.name(), null), SearchCriterion.le((String)PlaceOfSalesIndex.Property.opened.name(), (Object)new Date())}));
        parameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PlaceOfSalesIndex.Property.closed.name(), null), SearchCriterion.ge((String)PlaceOfSalesIndex.Property.closed.name(), (Object)new Date())}));
        TableColumnSettings filter = new TableColumnSettings();
        filter.setId(PlaceOfSalesIndex.Property.name.name());
        parameters.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(PlaceOfSalesIndex.Property.code.name());
        parameters.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(PlaceOfSalesIndex.Property.login.name());
        parameters.getFilters().add(filter);
        TableColumnSettings nameColumn = new TableColumnSettings();
        nameColumn.setId(PlaceOfSalesIndex.Property.name.name());
        parameters.getColumns().add(nameColumn);
        TableColumnSettings codeColumn = new TableColumnSettings();
        codeColumn.setId(PlaceOfSalesIndex.Property.code.name());
        parameters.getColumns().add(codeColumn);
        TableColumnSettings loginColumn = new TableColumnSettings();
        loginColumn.setId(PlaceOfSalesIndex.Property.login.name());
        parameters.getColumns().add(loginColumn);
        TableColumnSettings employmentsColumn = new TableColumnSettings();
        employmentsColumn.setId(PlaceOfSalesIndex.Property.employments.name());
        parameters.getColumns().add(employmentsColumn);
        TableColumnSettings referencesColumn = new TableColumnSettings();
        referencesColumn.setId(PlaceOfSalesIndex.Property.gdsReferences.name());
        parameters.getColumns().add(referencesColumn);
        IndexListService.get().open("salespoint-agents:" + ref.getUid(), controller.getOverview().getView().getAgentsNode().getText() + ' ' + ref, parameters);
    }

    private static SalesPointValidatorsFiltersPanel createValidatorFilterPanel(SalesPointSpaceController controller) {
        SalesPointValidatorsFiltersPanel filterPanel = new SalesPointValidatorsFiltersPanel(false);
        filterPanel.getPccRefNode().setItemsSupplier(() -> {
            ArrayList<EntityReference> result = new ArrayList<EntityReference>();
            EntityContainer container = RootEntityPane.lookup((Node)controller.getView()).getData().getContainer();
            if (container != null) {
                for (Pcc pcc : ((SalesPoint)container.getEntity()).getPccs()) {
                    result.add(new EntityReference(pcc.getUid(), Pcc.class, pcc.getCode()));
                }
            }
            return result;
        });
        return filterPanel;
    }

    private static void setStringConverters(SalesPointSpaceController main) {
        ((SalesPointOtherParametersPanel)main.getView().getOtherParametersTile().getFullNode()).getIrrelevantNode().setConverter(Converters.boolConverter((String)Messages.Dont_show_in_list, (String)Messages.Show_in_list));
        ((SalesPointOtherParametersPanel)main.getView().getOtherParametersTile().getFullNode()).getHeadOfficeNode().setConverter(Converters.boolConverter((String)Messages.Head, (String)Messages.Ordinary));
    }
}

