/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.custom.restrictions.RestrictionsData;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.settings.CleanupObjectsSettingsControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.settings.model.CleanupObjectsSettingsContainer;
import com.gridnine.xtrip.client.fx.standard.settings.model.CleanupObjectsSettingsContainerController;
import com.gridnine.xtrip.client.fx.standard.settings.model.CleanupObjectsSettingsContainerVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.CleanupObjectsSettings;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

public class CleanupObjectsSettingsHandler
extends BaseRootEntityHandler<CleanupObjectsSettings, Void, CleanupObjectsSettingsContainerVM, CleanupObjectsSettingsContainer> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<CleanupObjectsSettings, Void>, CleanupObjectsSettingsContainerVM>> toVM, List<BiConsumer<CleanupObjectsSettingsContainerVM, DataTransferPackage<CleanupObjectsSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new CleanupObjectsSettingsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            CleanupObjectsSettings model = (CleanupObjectsSettings)dtp.getContainer().getEntity();
            vm.getGeneralPanel().setTitle(model.getName());
            vm.getGeneralPanel().setCode(model.getCode());
            vm.getGeneralPanel().setObjectClassName(model.getObjectClassName());
            if (model.getObjectClassName() != null) {
                vm.getCriterions().setRestrictionId(model.getObjectClassName());
                try {
                    vm.getCriterions().getRestrictions().clear();
                    vm.getCriterions().getRestrictions().addAll(RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)model.getCriterions(), (Class)XSHelper.getClass((String)model.getObjectClassName()), Collections.emptyList()));
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }
            vm.getGeneralPanel().setIgnoreInterceptors(model.isIgnoreInterceptors());
        });
        fromVM.add((vm, dtp) -> {
            CleanupObjectsSettings model = (CleanupObjectsSettings)dtp.getContainer().getEntity();
            model.setName(vm.getGeneralPanel().getTitle());
            model.setCode(vm.getGeneralPanel().getCode());
            model.setObjectClassName(vm.getGeneralPanel().getObjectClassName());
            RestrictionsData rd = vm.getCriterions();
            if (rd == null) {
                model.getCriterions().clear();
            } else {
                try {
                    Class<?> indexClass = Class.forName(rd.getRestrictionId());
                    model.getCriterions().clear();
                    model.getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)rd.getRestrictions(), indexClass, Collections.emptyList()));
                }
                catch (ClassNotFoundException e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }
            model.setIgnoreInterceptors(vm.getGeneralPanel().isIgnoreInterceptors());
        });
    }

    @Override
    protected ViewController<CleanupObjectsSettingsContainer, CleanupObjectsSettingsContainerVM> createSpaceController(boolean readonly) {
        return new CleanupObjectsSettingsContainerController(readonly);
    }

    @Override
    protected CleanupObjectsSettingsContainerVM createVM() {
        return new CleanupObjectsSettingsContainerVM();
    }

    public Class<CleanupObjectsSettings> getEntityClass() {
        return CleanupObjectsSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }
}

