/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.BlankTypeVM;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderSpace;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferItemsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderVendorItemsPanelVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors.StockOrderControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.stockOrder.uidata.StockOrderUIData;
import com.gridnine.xtrip.common.model.stockcontrol.OrderItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderStatus;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class StockOrderHandler
extends BaseRootEntityHandler<StockOrder, StockOrderUIData, StockOrderSpaceVM, StockOrderSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return StockOrderIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<StockOrder, StockOrderUIData>, StockOrderSpaceVM>> toVM, List<BiConsumer<StockOrderSpaceVM, DataTransferPackage<StockOrder, StockOrderUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new StockOrderControllerInterceptor());
        toVM.add((dtp, vm) -> {
            StockOrder model = (StockOrder)dtp.getContainer().getEntity();
            StockOrderUIData supplement = (StockOrderUIData)dtp.getSupplement();
            if (model.getType() == null) {
                return;
            }
            switch (model.getType()) {
                case VENDOR: {
                    vm.getVendorMainFull().setHasTransferOrders(supplement != null && supplement.isHasTransferOrders());
                    vm.getVendorMainFull().getGeneral().setNumber(model.getNumber());
                    vm.getVendorMainFull().getGeneral().setStatus(model.getStatus());
                    vm.getVendorMainFull().getGeneral().setSupplier(model.getSupplier());
                    vm.getVendorMainFull().getGeneral().setReceiver(model.getReceiver());
                    vm.getVendorMainFull().getGeneral().setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
                    vm.getVendorMainFull().getGeneral().setRegistrationDate(DateUtils.asLocalDate((Date)model.getRegistrationDate()));
                    VMHelper.transfer(model.getItems(), vm.getVendorMainFull().getItems(), item -> new StockOrderVendorItemsPanelVM(), (item, itemVM) -> {
                        itemVM.setOwner(item.getOwner());
                        if (item.getBlankType() != null) {
                            BlankTypeVM typeVM = new BlankTypeVM();
                            typeVM.setBlankTypeReference(item.getBlankType());
                            itemVM.setBlankType(typeVM);
                        } else {
                            itemVM.setBlankType(null);
                        }
                        itemVM.setTariffType(item.getTariffType());
                        itemVM.setFirstBlankNumber(item.getFirstBlankNumber());
                        itemVM.setLastBlankNumber(item.getLastBlankNumber());
                        itemVM.setBlanksCount(item.getBlanksCount());
                        itemVM.setDestination(item.getDestination());
                    });
                    vm.getVendorMainFull().setNotes(model.getNotes());
                    break;
                }
                case TRANSFER: {
                    vm.getTransferMainFull().getGeneral().setNumber(model.getNumber());
                    vm.getTransferMainFull().getGeneral().setStatus(model.getStatus());
                    vm.getTransferMainFull().getGeneral().setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
                    vm.getTransferMainFull().getGeneral().setTransferDate(DateUtils.asLocalDate((Date)model.getRegistrationDate()));
                    vm.getTransferMainFull().getGeneral().setSender(model.getSender());
                    vm.getTransferMainFull().getGeneral().setSenderResponsible(model.getSenderResponsible());
                    vm.getTransferMainFull().getGeneral().setReceiver(model.getReceiver());
                    vm.getTransferMainFull().getGeneral().setRecieverResponsible(model.getRecieverResponsible());
                    VMHelper.transfer(model.getItems(), vm.getTransferMainFull().getItems(), item -> new StockOrderTransferItemsPanelVM(), (item, itemVM) -> {
                        itemVM.setOwner(item.getOwner());
                        itemVM.setSupplier(item.getDestination());
                        if (item.getBlankType() != null) {
                            BlankTypeVM typeVM = new BlankTypeVM();
                            typeVM.setBlankTypeReference(item.getBlankType());
                            itemVM.setBlankType(typeVM);
                        } else {
                            itemVM.setBlankType(null);
                        }
                        itemVM.setTariffType(item.getTariffType());
                        itemVM.setFirstBlankNumber(item.getFirstBlankNumber());
                        itemVM.setBottomBoundNumber(item.getBottomBoundNumber());
                        itemVM.setLastBlankNumber(item.getLastBlankNumber());
                        itemVM.setTopBoundNumber(item.getTopBoundNumber());
                        itemVM.setBlanksCount(FormattedNumberUtil.diff((String)item.getTopBoundNumber(), (String)item.getBottomBoundNumber()) + 1L);
                        itemVM.setSelectedNumber(item.getBlanksCount());
                    });
                    vm.getTransferMainFull().setNotes(model.getNotes());
                    break;
                }
            }
        });
        fromVM.add((vm, dtp) -> {
            StockOrder model = (StockOrder)dtp.getContainer().getEntity();
            if (model.getType() == null) {
                return;
            }
            switch (model.getType()) {
                case VENDOR: {
                    model.setNumber(vm.getVendorMainFull().getGeneral().getNumber());
                    model.setStatus(vm.getVendorMainFull().getGeneral().getStatus() == null ? StockOrderStatus.NEW : vm.getVendorMainFull().getGeneral().getStatus());
                    model.setSupplier(vm.getVendorMainFull().getGeneral().getSupplier());
                    model.setReceiver(vm.getVendorMainFull().getGeneral().getReceiver());
                    model.setStockHolder(vm.getVendorMainFull().getGeneral().getReceiver());
                    model.setCreated(DateUtils.asDate((LocalDate)vm.getVendorMainFull().getGeneral().getCreated()));
                    model.setRegistrationDate(DateUtils.asDate((LocalDate)vm.getVendorMainFull().getGeneral().getRegistrationDate()));
                    VMHelper.transfer(vm.getVendorMainFull().getItems(), model.getItems(), itemVM -> new OrderItem(), (itemVM, item) -> {
                        item.setOwner(itemVM.getOwner());
                        item.setBlankType(itemVM.getBlankType() == null ? null : itemVM.getBlankType().getBlankTypeReference());
                        item.setTariffType(itemVM.getTariffType());
                        item.setFirstBlankNumber(itemVM.getFirstBlankNumber());
                        item.setLastBlankNumber(itemVM.getLastBlankNumber());
                        item.setBlanksCount(itemVM.getBlanksCount());
                        item.setDestination(itemVM.getDestination());
                    });
                    model.setNotes(vm.getVendorMainFull().getNotes());
                    break;
                }
                case TRANSFER: {
                    model.setNumber(vm.getTransferMainFull().getGeneral().getNumber());
                    model.setStatus(vm.getTransferMainFull().getGeneral().getStatus() == null ? StockOrderStatus.NEW : vm.getTransferMainFull().getGeneral().getStatus());
                    model.setCreated(DateUtils.asDate((LocalDate)vm.getTransferMainFull().getGeneral().getCreated()));
                    model.setRegistrationDate(DateUtils.asDate((LocalDate)vm.getTransferMainFull().getGeneral().getTransferDate()));
                    model.setSender(vm.getTransferMainFull().getGeneral().getSender());
                    model.setSenderResponsible(vm.getTransferMainFull().getGeneral().getSenderResponsible());
                    model.setReceiver(vm.getTransferMainFull().getGeneral().getReceiver());
                    model.setRecieverResponsible(vm.getTransferMainFull().getGeneral().getRecieverResponsible());
                    VMHelper.transfer(vm.getTransferMainFull().getItems(), model.getItems(), itemVm -> new OrderItem(), (itemVM, item) -> {
                        item.setOwner(itemVM.getOwner());
                        item.setDestination(itemVM.getSupplier());
                        item.setBlankType(itemVM.getBlankType() == null ? null : itemVM.getBlankType().getBlankTypeReference());
                        item.setTariffType(itemVM.getTariffType());
                        item.setFirstBlankNumber(itemVM.getFirstBlankNumber());
                        item.setBottomBoundNumber(itemVM.getBottomBoundNumber());
                        item.setLastBlankNumber(itemVM.getLastBlankNumber());
                        item.setTopBoundNumber(itemVM.getTopBoundNumber());
                        item.setBlanksCount(itemVM.getSelectedNumber());
                    });
                    model.setNotes(vm.getTransferMainFull().getNotes());
                    break;
                }
            }
        });
    }

    public Class<StockOrder> getEntityClass() {
        return StockOrder.class;
    }

    public Class<StockOrderUIData> getSupplementClass() {
        return StockOrderUIData.class;
    }

    @Override
    protected ViewController<StockOrderSpace, StockOrderSpaceVM> createSpaceController(boolean readonly) {
        return new StockOrderSpaceController(readonly);
    }

    @Override
    protected StockOrderSpaceVM createVM() {
        return new StockOrderSpaceVM();
    }
}

