/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.QueryDataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.model.profile.BlankTypeVM;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferItemsDialogWindow;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferItemsFiltersPanel;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferItemsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferItemsVM;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferMainPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors.StocksHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;

public class StockOrderTransferItemsProvider
implements MultiProvider<StockOrderTransferItemsPanelVM> {
    private final EntityBoxWidget<BaseProfile> sender;
    private final EntityBoxWidget<BaseProfile> receiver;
    private final TableWidget<StockOrderTransferItemsPanelVM> mainTable;
    private final StockOrderTransferItemsDialogWindow dialogPanel;
    private final StockOrderTransferMainPanel parentNode;

    StockOrderTransferItemsProvider(EntityBoxWidget<BaseProfile> stockOrderSender, EntityBoxWidget<BaseProfile> stockOrderReceiver, TableWidget<StockOrderTransferItemsPanelVM> table, StockOrderTransferMainPanel node) {
        this.sender = stockOrderSender;
        this.receiver = stockOrderReceiver;
        this.mainTable = table;
        this.parentNode = node;
        QueryDataViewHandler<StockOrderTransferItemsVM> handler = this.createDataViewHandler();
        handler.setQuery(this.createQuery());
        this.setFiltering(handler);
        this.dialogPanel = new StockOrderTransferItemsDialogWindow(false);
        ((DataViewWidget)this.dialogPanel.getContent()).setHandler(handler);
        ((DataViewWidget)this.dialogPanel.getContent()).getTableView().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    public void createAny(Consumer<Collection<StockOrderTransferItemsPanelVM>> consumer) {
        if (this.sender.valueProperty().get() != null && this.receiver.valueProperty().get() != null) {
            ((DataViewWidget)this.dialogPanel.getContent()).reloadData();
            new Dialog().setTitle(Messages.Transfer_config).setExpandToParent(true).setBody((Node)this.dialogPanel).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
                ObservableList selectedItems = ((DataViewWidget)this.dialogPanel.getContent()).getTableView().getSelectionModel().getSelectedItems();
                if (selectedItems.size() > 0) {
                    ArrayList vmList = new ArrayList();
                    selectedItems.forEach(item -> vmList.add(StockOrderTransferItemsProvider.createItemPanelVM(item)));
                    consumer.accept(vmList);
                } else {
                    Dialog.info(this.mainTable, (String)Messages.No_stock_of_forms_selected);
                }
            }).show((Node)this.parentNode);
        } else {
            Dialog.info(this.mainTable, (String)Messages.Missing_sender_and_receiver);
        }
    }

    private SearchQuery createQuery() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.NEW));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.reserved.name(), (Object)Boolean.FALSE));
        query.getCriteria().getOrders().put(StockBlankIndex.Property.number.name(), SortOrder.ASC);
        query.getCriteria().getOrders().put(StockBlankIndex.Property.owner.name(), SortOrder.ASC);
        query.getCriteria().getOrders().put(StockBlankIndex.Property.type.name(), SortOrder.ASC);
        return query;
    }

    private QueryDataViewHandler<StockOrderTransferItemsVM> createDataViewHandler() {
        return new QueryDataViewHandler<StockOrderTransferItemsVM>(){

            protected List<StockOrderTransferItemsVM> executeQuery(SearchQuery query) throws Exception {
                ArrayList<StockOrderTransferItemsVM> result = new ArrayList<StockOrderTransferItemsVM>();
                SearchQuery queryBlanks = StockOrderTransferItemsProvider.this.createQuery();
                queryBlanks.getCriteria().getCriterions().addAll(this.getFilteringCriterions());
                if (StockOrderTransferItemsProvider.this.sender.valueProperty().get() != null) {
                    queryBlanks.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.currentLocation.name(), (Object)((EntityReference)StockOrderTransferItemsProvider.this.sender.valueProperty().get()).getUid()));
                }
                if (StockOrderTransferItemsProvider.this.receiver.valueProperty().get() != null) {
                    queryBlanks.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)StockBlankIndex.Property.destination.name(), null), SearchCriterion.eq((String)StockBlankIndex.Property.destination.name(), (Object)((EntityReference)StockOrderTransferItemsProvider.this.receiver.valueProperty().get()).getUid())}));
                }
                for (int i = 0; i < StockOrderTransferItemsProvider.this.mainTable.getRowsCount(); ++i) {
                    queryBlanks.getCriteria().getCriterions().add(SearchCriterion.not((SearchCriterion)SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.between((String)StockBlankIndex.Property.number.name(), (Object)((TextFieldWidget)((TextWidgetColumn)StockOrderTransferItemsProvider.this.mainTable.getColumn("firstBlankNumber")).getWidget(i)).getValue(), (Object)((TextFieldWidget)((TextWidgetColumn)StockOrderTransferItemsProvider.this.mainTable.getColumn("lastBlankNumber")).getWidget(i)).getValue()), SearchCriterion.eq((String)StockBlankIndex.Property.owner.name(), (Object)((EntityBoxWidget)((EntityBoxWidgetColumn)StockOrderTransferItemsProvider.this.mainTable.getColumn("owner")).getWidget(i)).valueProperty().get()), SearchCriterion.eq((String)StockBlankIndex.Property.type.name(), (Object)((BlankTypeVM)((ComboBoxWidget)((ComboBoxWidgetColumn)StockOrderTransferItemsProvider.this.mainTable.getColumn("blankType")).getWidget(i)).valueProperty().get()).getBlankTypeReference())})));
                }
                ArrayList blanks = new ArrayList();
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                do {
                    blanks.addAll(entityService.search(sic, StockBlankIndex.class, queryBlanks));
                    queryBlanks.setOffset(queryBlanks.getOffset() + 100);
                } while (blanks.size() == queryBlanks.getOffset());
                queryBlanks.setOffset(0);
                if (blanks.size() > 0) {
                    StockBlankIndex startBlank;
                    StockBlankIndex prevBlank = startBlank = (StockBlankIndex)blanks.get(0);
                    int count = 0;
                    for (StockBlankIndex blank : blanks) {
                        ++count;
                        if (!this.isSameBatch(prevBlank, blank)) {
                            StockOrderTransferItemsVM vm = new StockOrderTransferItemsVM();
                            vm.setOwner(startBlank.getOwner().getCaption());
                            vm.setOwnerReference(startBlank.getOwner());
                            vm.setSupplier(startBlank.getSupplier().getCaption());
                            vm.setSupplierReference(startBlank.getSupplier());
                            vm.setBlankType(startBlank.getType().getCode());
                            vm.setBlankTypeReference(startBlank.getType());
                            if (startBlank.getTariffType() != null) {
                                vm.setTariffType(startBlank.getTariffType().toString());
                                vm.setTariffTypeReference(startBlank.getTariffType());
                            }
                            vm.setFirstBlankNumber(startBlank.getNumber());
                            vm.setLastBlankNumber(prevBlank.getNumber());
                            vm.setBlanksCount(Integer.toString(count - 1));
                            result.add(vm);
                            count = 1;
                            startBlank = blank;
                        }
                        prevBlank = blank;
                    }
                    if (count > 0) {
                        StockOrderTransferItemsVM vm = new StockOrderTransferItemsVM();
                        vm.setOwner(startBlank.getOwner().getCaption());
                        vm.setOwnerReference(startBlank.getOwner());
                        vm.setSupplier(startBlank.getSupplier().getCaption());
                        vm.setSupplierReference(startBlank.getSupplier());
                        vm.setBlankType(startBlank.getType().getCode());
                        vm.setBlankTypeReference(startBlank.getType());
                        if (startBlank.getTariffType() != null) {
                            vm.setTariffType(startBlank.getTariffType().toString());
                            vm.setTariffTypeReference(startBlank.getTariffType());
                        }
                        vm.setFirstBlankNumber(startBlank.getNumber());
                        vm.setLastBlankNumber(prevBlank.getNumber());
                        vm.setBlanksCount(Integer.toString(count));
                        result.add(vm);
                    }
                }
                return result;
            }

            private boolean isSameBatch(StockBlankIndex blank1, StockBlankIndex blank2) {
                if (MiscUtil.equals((Object)blank1, (Object)blank2)) {
                    return true;
                }
                if (!MiscUtil.equals((Object)blank1.getOwner(), (Object)blank2.getOwner())) {
                    return false;
                }
                if (!MiscUtil.equals((Object)blank1.getType(), (Object)blank2.getType())) {
                    return false;
                }
                return FormattedNumberUtil.isInRange((String)blank2.getNumber(), (String)blank1.getNumber(), (long)1L);
            }
        };
    }

    private void setFiltering(QueryDataViewHandler<StockOrderTransferItemsVM> handler) {
        handler.setFiltering(() -> {
            StockOrderTransferItemsFiltersPanel result = new StockOrderTransferItemsFiltersPanel(false);
            result.getOwnerNode().setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
            result.getSupplierNode().setListParametersSupplier(ControllerInterceptorsHelper::getSuppliers);
            result.getBlankTypeNode().setLive(true);
            result.getBlankTypeNode().setAsync(true);
            result.getBlankTypeNode().setItemsSupplier(StocksHelper.createBlankTypesSupplier((EntityBoxWidget<Organization>)result.getOwnerNode()));
            result.getBlankTypeNode().setConverter(StocksHelper.BLANK_TYPE_CONVERTER);
            return result;
        }, filterPanel -> {
            ArrayList<SearchCriterion> result = new ArrayList<SearchCriterion>();
            if (filterPanel.getOwnerNode().valueProperty().get() != null) {
                result.add(SearchCriterion.eq((String)StockBlankIndex.Property.owner.name(), (Object)((EntityReference)filterPanel.getOwnerNode().valueProperty().get()).getUid()));
            }
            if (filterPanel.getSupplierNode().valueProperty().get() != null) {
                result.add(SearchCriterion.eq((String)StockBlankIndex.Property.supplier.name(), (Object)((EntityReference)filterPanel.getSupplierNode().valueProperty().get()).getUid()));
            }
            if (filterPanel.getBlankTypeNode().valueProperty().get() != null && ((BlankTypeVM)filterPanel.getBlankTypeNode().valueProperty().get()).getBlankTypeReference() != null) {
                result.add(SearchCriterion.eq((String)StockBlankIndex.Property.type.name(), (Object)((BlankTypeVM)filterPanel.getBlankTypeNode().valueProperty().get()).getBlankTypeReference()));
            }
            return result;
        });
    }

    private static StockOrderTransferItemsPanelVM createItemPanelVM(StockOrderTransferItemsVM itemVM) {
        StockOrderTransferItemsPanelVM itemPanelVM = new StockOrderTransferItemsPanelVM();
        itemPanelVM.setOwner(itemVM.getOwnerReference());
        itemPanelVM.setSupplier(itemVM.getSupplierReference());
        BlankTypeVM typeVM = new BlankTypeVM();
        typeVM.setBlankTypeReference(itemVM.getBlankTypeReference());
        itemPanelVM.setBlankType(typeVM);
        itemPanelVM.setTariffType(itemVM.getTariffTypeReference());
        itemPanelVM.setFirstBlankNumber(itemVM.getFirstBlankNumber());
        itemPanelVM.setBottomBoundNumber(itemVM.getFirstBlankNumber());
        itemPanelVM.setLastBlankNumber(itemVM.getLastBlankNumber());
        itemPanelVM.setTopBoundNumber(itemVM.getLastBlankNumber());
        itemPanelVM.setBlanksCount((long)Integer.parseInt(itemVM.getBlanksCount()));
        itemPanelVM.setSelectedNumber((long)Integer.parseInt(itemVM.getBlanksCount()));
        return itemPanelVM;
    }

    public StockOrderTransferItemsPanelVM createOne() {
        return null;
    }
}

