/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferMainPanel;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderStatus;
import com.gridnine.xtrip.common.model.system.Message;
import java.io.Serializable;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;

enum StockOrderTransferTileActions implements TileAction<Node, StockOrderTransferMainPanel>
{
    TRANSFER{

        public String getName(Tile<Node, StockOrderTransferMainPanel> tile) {
            return Messages.Transfer_to;
        }

        public String getDescription(Tile<Node, StockOrderTransferMainPanel> tile) {
            return Messages.Transfer_the_forms;
        }

        public double getWeight() {
            return 0.0;
        }

        public boolean isEnabled(Tile<Node, StockOrderTransferMainPanel> tile) {
            return !((TableWidget)((StockOrderTransferMainPanel)tile.getFullNode()).getItemsCard().getContent()).getViewState().isImmutable() && ((StockOrderTransferGeneralPanel)((StockOrderTransferMainPanel)tile.getFullNode()).getGeneralCard().getContent()).getStatusNode().getValue() == StockOrderStatus.NEW && ((StockOrderTransferGeneralPanel)((StockOrderTransferMainPanel)tile.getFullNode()).getGeneralCard().getContent()).getCreatedNode().getValue() != null;
        }

        public void execute(Control source, final Tile<Node, StockOrderTransferMainPanel> tile, boolean alt) {
            final EntityContainer container = RootEntityPane.lookup((Node)tile.getFullNode()).getData().getContainer();
            if (container == null) {
                return;
            }
            Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                protected String getTitle() {
                    return Messages.Transfer_the_forms;
                }

                protected void onCompleted(Object result, List<Message> log) {
                    if (((Boolean)result).booleanValue()) {
                        try {
                            FxUtil.waitForFxThread(() -> ((StockOrderTransferGeneralPanel)((StockOrderTransferMainPanel)tile.getFullNode()).getGeneralCard().getContent()).getStatusNode().setValue((Object)StockOrderStatus.REGISTERED));
                        }
                        catch (Exception e) {
                            ErrorHandler.handle((Throwable)e);
                        }
                    }
                }

                protected Serializable getTaskParameters() {
                    return container.toReference();
                }

                protected String getTaskClassName() {
                    return "com.gridnine.xtrip.server.fx.async.entityactions.RegisterStockOrderAsyncTask";
                }
            });
        }
    }
    ,
    CANCEL_TRANSFER{

        public String getName(Tile<Node, StockOrderTransferMainPanel> tile) {
            return Messages.Cancel_transfer;
        }

        public String getDescription(Tile<Node, StockOrderTransferMainPanel> tile) {
            return Messages.Cancel_transfer_of_forms;
        }

        public double getWeight() {
            return 1.0;
        }

        public boolean isEnabled(Tile<Node, StockOrderTransferMainPanel> tile) {
            return !((TableWidget)((StockOrderTransferMainPanel)tile.getFullNode()).getItemsCard().getContent()).getViewState().isImmutable() && ((StockOrderTransferGeneralPanel)((StockOrderTransferMainPanel)tile.getFullNode()).getGeneralCard().getContent()).getStatusNode().getValue() == StockOrderStatus.REGISTERED;
        }

        public void execute(Control source, final Tile<Node, StockOrderTransferMainPanel> tile, boolean alt) {
            final EntityContainer container = RootEntityPane.lookup((Node)tile.getFullNode()).getData().getContainer();
            if (container == null) {
                return;
            }
            Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                protected String getTitle() {
                    return Messages.Cancel_the_transfer_of_forms;
                }

                protected void onCompleted(final Object result, List<Message> log) {
                    if (((Boolean)result).booleanValue()) {
                        try {
                            FxUtil.waitForFxThread(() -> {
                                ((StockOrderTransferGeneralPanel)((StockOrderTransferMainPanel)tile.getFullNode()).getGeneralCard().getContent()).getStatusNode().setValue((Object)StockOrderStatus.NEW);
                                Notifications.get().showFlashNotification(Messages.Canceling_the_transfer_of_the_forms_is_interrupted, null);
                            });
                        }
                        catch (Exception e) {
                            ErrorHandler.handle((Throwable)e);
                        }
                    } else {
                        new Dialog().setTitle("Some blanks have status not new.\n Would you like to continue?").addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                            protected String getTitle() {
                                return Messages.Cancel_the_transfer_of_forms;
                            }

                            protected void onCompleted(Object result1, List<Message> log1) {
                                if (((Boolean)result).booleanValue()) {
                                    try {
                                        FxUtil.waitForFxThread(() -> {
                                            ((StockOrderTransferGeneralPanel)((StockOrderTransferMainPanel)tile.getFullNode()).getGeneralCard().getContent()).getStatusNode().setValue((Object)StockOrderStatus.NEW);
                                            Notifications.get().showFlashNotification(Messages.Canceling_the_transfer_of_the_forms_is_interrupted, null);
                                        });
                                    }
                                    catch (Exception e) {
                                        ErrorHandler.handle((Throwable)e);
                                    }
                                }
                            }

                            protected Serializable getTaskParameters() {
                                return container.toReference();
                            }

                            protected String getTaskClassName() {
                                return "com.gridnine.xtrip.server.fx.async.entityactions.UnregisterStockOrderAsyncTask";
                            }
                        })).showGlobal();
                    }
                }

                protected Serializable getTaskParameters() {
                    return container.toReference();
                }

                protected String getTaskClassName() {
                    return "com.gridnine.xtrip.server.fx.async.entityactions.CheckAndUnregisterStockOrderAsyncTask";
                }
            });
        }
    };

}

