/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.system;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.model.system.TemplateDocumentPanelVM;
import com.gridnine.xtrip.client.fx.model.system.TemplateDocumentSpace;
import com.gridnine.xtrip.client.fx.model.system.TemplateDocumentSpaceController;
import com.gridnine.xtrip.client.fx.model.system.TemplateDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.system.TemplateDocumentControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.system.TemplateDocumentHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.TemplateDescriptorRegistryItem;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperReport;

public class TemplateDocumentHandler
extends BaseRootEntityHandler<TemplateDocument, Void, TemplateDocumentSpaceVM, TemplateDocumentSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return TemplateDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<TemplateDocument, Void>, TemplateDocumentSpaceVM>> toVM, List<BiConsumer<TemplateDocumentSpaceVM, DataTransferPackage<TemplateDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new TemplateDocumentControllerInterceptor());
        toVM.add((dtp, vm) -> {
            TemplateDocument model = (TemplateDocument)dtp.getContainer().getEntity();
            TemplateDocumentPanelVM templatePanelVM = vm.getMainFull().getMainSpecifications();
            templatePanelVM.setTitle(model.getTitle());
            if (model.getTemplateId() != null) {
                TemplateDescriptorRegistryItem templateDescriptorRegistryItem = (TemplateDescriptorRegistryItem)ClientRegistry.get().allOf(TemplateDescriptorRegistryItem.TYPE).get(model.getTemplateId());
                if (templateDescriptorRegistryItem != null) {
                    templatePanelVM.setType(templateDescriptorRegistryItem.getTemplateDescriptor());
                } else {
                    templatePanelVM.setType(null);
                }
            } else {
                templatePanelVM.setType(null);
            }
            templatePanelVM.setFinancialDocument((FinanceDocumentType)CollectionUtil.findEnumConstant(FinanceDocumentType.class, (String)((String)SystemHelper.getMetadata((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_FINANCE_DOCUMENT_TYPE))));
            Boolean hasColumnVatRate = SystemHelper.getMetadataAsBoolean((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_HAS_COLUMN_VAT_RATE);
            templatePanelVM.setHasColumnVatRate(hasColumnVatRate != null && hasColumnVatRate != false);
            Boolean noPenaltyVat = SystemHelper.getMetadataAsBoolean((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_NO_PENALTY_VAT);
            templatePanelVM.setNoPenaltyVat(noPenaltyVat != null && noPenaltyVat != false);
            Boolean hideColumnsVat = SystemHelper.getMetadataAsBoolean((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_HIDE_COLUMNS_VAT);
            templatePanelVM.setHideColumnsVat(hideColumnsVat != null && hideColumnsVat != false);
            Boolean hasCostCode = SystemHelper.getMetadataAsBoolean((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_HAS_COST_CODE);
            templatePanelVM.setHasCostCode(hasCostCode != null && hasCostCode != false);
            templatePanelVM.setLocale(SystemHelper.findMetadataAsString((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_LOCALE));
            templatePanelVM.setContent(model.getContent());
            vm.getMainFull().getOtherParameters().setDisabled(model.isDisabled());
            RichData data = new RichData();
            try {
                JasperReport jrReport = JasperUtil.getReport((byte[])model.getContent());
                byte[] content = JasperUtil.fillReport((JasperReport)jrReport, new HashMap(), (JRDataSource)new JREmptyDataSource(), null);
                data.setContent(content);
                data.setContentType(ContentType.JASPERPRINT);
            }
            catch (Exception ignored) {
                data.setContent(model.getContent());
                data.setContentType(ContentType.BINARY);
            }
            vm.getMainFull().setContents(data);
        });
        fromVM.add((vm, dtp) -> {
            TemplateDocument model = (TemplateDocument)dtp.getContainer().getEntity();
            TemplateDocumentPanelVM templateVM = vm.getMainFull().getMainSpecifications();
            model.setTitle(templateVM.getTitle());
            model.setTemplateId(templateVM.getType() == null ? null : templateVM.getType().getId());
            SystemHelper.setMetadataValue((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_FINANCE_DOCUMENT_TYPE, templateVM.getFinancialDocument() == null ? null : templateVM.getFinancialDocument().name());
            SystemHelper.setMetadataValue((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_LOCALE, (Object)templateVM.getLocale());
            SystemHelper.setMetadataValue((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_HAS_COLUMN_VAT_RATE, (Object)templateVM.isHasColumnVatRate());
            SystemHelper.setMetadataValue((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_NO_PENALTY_VAT, (Object)templateVM.isNoPenaltyVat());
            SystemHelper.setMetadataValue((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_HIDE_COLUMNS_VAT, (Object)templateVM.isHideColumnsVat());
            SystemHelper.setMetadataValue((Collection)model.getMetadata(), (MetadataKey)MetadataKey.KEY_HAS_COST_CODE, (Object)templateVM.isHasCostCode());
            model.setDisabled(vm.getMainFull().getOtherParameters().isDisabled());
            model.setContent(templateVM.getContent());
        });
        ClientRegistry.get().allOf(TemplateDocumentHandlerConfigurator.TYPE).values().forEach(cfg -> cfg.configureController(toVM, fromVM));
    }

    public Class<TemplateDocument> getEntityClass() {
        return TemplateDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected ViewController<TemplateDocumentSpace, TemplateDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new TemplateDocumentSpaceController(readonly);
    }

    @Override
    protected TemplateDocumentSpaceVM createVM() {
        return new TemplateDocumentSpaceVM();
    }
}

