/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.tripartitecontract;

import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullClientVM;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullGeneral;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullGeneralSuppliersVM;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractProviderVM;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractSpaceController;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.HotelsBrandType;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractSubtype;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class TripartiteContractGeneralTileHelper {
    static void toVM(TripartiteContract model, TripartiteContractFullPanelVM full, TripartiteContractSpaceController controller) {
        full.getGeneral().setName(model.getName());
        full.getGeneral().setAgency(model.getAgency());
        model.getCustomers().forEach(client -> {
            TripartiteContractFullClientVM clientVM = new TripartiteContractFullClientVM();
            clientVM.setClient(client.getCustomer());
            clientVM.setContractNumber(client.getNumber());
            clientVM.setIssueDate(DateUtils.asLocalDate((Date)client.getIssueDate()));
            clientVM.setStartDate(DateUtils.asLocalDate((Date)client.getStartDate()));
            clientVM.setEndDate(DateUtils.asLocalDate((Date)client.getEndDate()));
            full.getClients().add(clientVM);
        });
        if (model.getType() != null) {
            switch (model.getType()) {
                case AVIA: {
                    if (model.getAviaVendorData().getAirlines().size() > 0) {
                        full.getGeneral().setContractSubtype(TripartiteContractSubtype.AVIA_AIRLINES);
                        model.getAviaVendorData().getAirlines().forEach(airline -> {
                            TripartiteContractFullGeneralSuppliersVM airlineVM = new TripartiteContractFullGeneralSuppliersVM();
                            airlineVM.setDictValue(airline);
                            full.getGeneral().getSuppliers().add(airlineVM);
                        });
                        break;
                    }
                    if (model.getAviaVendorData().getAlliances().size() > 0) {
                        full.getGeneral().setContractSubtype(TripartiteContractSubtype.AVIA_ALLIANCES);
                        model.getAviaVendorData().getAlliances().forEach(alliance -> {
                            TripartiteContractFullGeneralSuppliersVM allianceVM = new TripartiteContractFullGeneralSuppliersVM();
                            allianceVM.setDictValue(alliance);
                            full.getGeneral().getSuppliers().add(allianceVM);
                        });
                        break;
                    }
                    full.getGeneral().setContractSubtype(TripartiteContractSubtype.AVIA_AIRLINES);
                    break;
                }
                case CAR: {
                    if (model.getCarVendorData().getSuppliers().size() > 0) {
                        full.getGeneral().setContractSubtype(TripartiteContractSubtype.CARS_BRAND);
                        model.getCarVendorData().getSuppliers().forEach(carSupplier -> {
                            TripartiteContractFullGeneralSuppliersVM carSupplierVM = new TripartiteContractFullGeneralSuppliersVM();
                            carSupplierVM.setDictValue(carSupplier);
                            full.getGeneral().getSuppliers().add(carSupplierVM);
                        });
                        break;
                    }
                    full.getGeneral().setContractSubtype(TripartiteContractSubtype.CARS_GLOBAL);
                    break;
                }
                case HOTEL: {
                    TripartiteContractFullGeneralSuppliersVM vm;
                    for (DictionaryReference brand : model.getHotelVendorData().getBrands()) {
                        vm = new TripartiteContractFullGeneralSuppliersVM();
                        vm.setDictValue(brand);
                        full.getGeneral().getSuppliers().add(vm);
                    }
                    if (model.getHotelVendorData().getBrands().size() > 0) {
                        Notifications.get().submitTask(() -> {
                            ServiceInvocationContext sic = ServiceInvocationContext.get();
                            DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
                            HotelsBrand dict = (HotelsBrand)dictService.load(sic, (DictionaryReference)model.getHotelVendorData().getBrands().get(0));
                            TripartiteContractSubtype subtype = dict.getType().equals((Object)HotelsBrandType.CHAIN_OF_BRANDS) ? TripartiteContractSubtype.HOTEL_CHAIN : TripartiteContractSubtype.HOTEL_BRAND;
                            FxUtil.waitForFxThread(() -> {
                                controller.getData().getMainFull().getGeneral().setContractSubtype(subtype);
                                ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getContractSubtypeNode().valueProperty().set((Object)subtype);
                                controller.getMainFull().getGeneral().getSuppliers().readData((Object)full.getGeneral().getSuppliers());
                            });
                        }, (ObservableMutex)controller.getView().getProperties().get((Object)ObservableMutex.class.getName()));
                        break;
                    }
                    if (!model.getHotelVendorData().getProviders().isEmpty()) {
                        for (HotelProvider provider : model.getHotelVendorData().getProviders()) {
                            vm = new TripartiteContractProviderVM();
                            vm.setProvider(provider);
                            full.getGeneral().getProvider().add(vm);
                        }
                        full.getGeneral().setContractSubtype(TripartiteContractSubtype.HOTEL_PROVIDERS);
                        break;
                    }
                    full.getGeneral().setContractSubtype(TripartiteContractSubtype.HOTEL_GLOBAL);
                    break;
                }
            }
        }
    }

    static void fromVM(TripartiteContractFullPanelVM full, TripartiteContract model) {
        model.setName(full.getGeneral().getName());
        model.setAgency(full.getGeneral().getAgency());
        model.getCustomers().clear();
        full.getClients().forEach(clientVM -> {
            TripartiteContractCustomerInfo client = new TripartiteContractCustomerInfo();
            client.setCustomer(clientVM.getClient());
            client.setNumber(clientVM.getContractNumber());
            client.setIssueDate(DateUtils.asDate((LocalDate)clientVM.getIssueDate()));
            client.setStartDate(DateUtils.asDate((LocalDate)clientVM.getStartDate()));
            client.setEndDate(DateUtils.asDate((LocalDate)clientVM.getEndDate()));
            model.getCustomers().add(client);
        });
        model.getAviaVendorData().getAirlines().clear();
        model.getAviaVendorData().getAlliances().clear();
        model.getCarVendorData().getSuppliers().clear();
        model.getHotelVendorData().getBrands().clear();
        model.getHotelVendorData().getProviders().clear();
        if (full.getGeneral().getContractSubtype() != null) {
            switch (full.getGeneral().getContractSubtype()) {
                case AVIA_AIRLINES: {
                    full.getGeneral().getSuppliers().forEach(airlineVM -> model.getAviaVendorData().getAirlines().add(airlineVM.getDictValue()));
                    break;
                }
                case AVIA_ALLIANCES: {
                    full.getGeneral().getSuppliers().forEach(allianceVM -> model.getAviaVendorData().getAlliances().add(allianceVM.getDictValue()));
                    break;
                }
                case CARS_BRAND: {
                    if (full.getGeneral().getSuppliers().isEmpty()) {
                        Notifications.get().showFlashNotification(Messages.No_selected_suppliers, "");
                        break;
                    }
                    full.getGeneral().getSuppliers().forEach(carBrandVM -> model.getCarVendorData().getSuppliers().add(carBrandVM.getDictValue()));
                    break;
                }
                case HOTEL_BRAND: {
                    if (full.getGeneral().getSuppliers().isEmpty()) {
                        Notifications.get().showFlashNotification(Messages.No_selected_suppliers, "");
                        break;
                    }
                    full.getGeneral().getSuppliers().forEach(brandVM -> model.getHotelVendorData().getBrands().add(brandVM.getDictValue()));
                    break;
                }
                case HOTEL_CHAIN: {
                    if (full.getGeneral().getSuppliers().isEmpty()) {
                        Notifications.get().showFlashNotification(Messages.No_selected_suppliers, "");
                        break;
                    }
                    full.getGeneral().getSuppliers().forEach(brandVM -> model.getHotelVendorData().getBrands().add(brandVM.getDictValue()));
                    break;
                }
                case HOTEL_PROVIDERS: {
                    if (full.getGeneral().getProvider().isEmpty()) {
                        Notifications.get().showFlashNotification(Messages.No_selected_suppliers, "");
                        break;
                    }
                    full.getGeneral().getProvider().forEach(providerVM -> model.getHotelVendorData().getProviders().add(providerVM.getProvider()));
                    break;
                }
            }
        }
    }

    static List<TripartiteContractSubtype> getAviaSubtypes() {
        ArrayList<TripartiteContractSubtype> list = new ArrayList<TripartiteContractSubtype>();
        list.add(TripartiteContractSubtype.AVIA_AIRLINES);
        list.add(TripartiteContractSubtype.AVIA_ALLIANCES);
        return list;
    }

    static List<TripartiteContractSubtype> getCarSubtypes() {
        ArrayList<TripartiteContractSubtype> list = new ArrayList<TripartiteContractSubtype>();
        list.add(TripartiteContractSubtype.CARS_BRAND);
        list.add(TripartiteContractSubtype.CARS_GLOBAL);
        return list;
    }

    static List<TripartiteContractSubtype> getHotelSubtypes() {
        ArrayList<TripartiteContractSubtype> list = new ArrayList<TripartiteContractSubtype>();
        list.add(TripartiteContractSubtype.HOTEL_BRAND);
        list.add(TripartiteContractSubtype.HOTEL_CHAIN);
        list.add(TripartiteContractSubtype.HOTEL_GLOBAL);
        list.add(TripartiteContractSubtype.HOTEL_PROVIDERS);
        return list;
    }

    private TripartiteContractGeneralTileHelper() {
    }
}

