/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.universalproduct;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.UniversalProductDescriptionContainer;
import com.gridnine.xtrip.client.fx.model.profile.UniversalProductDescriptionContainerController;
import com.gridnine.xtrip.client.fx.model.profile.UniversalProductDescriptionContainerVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javafx.beans.value.ObservableValue;

public class UniversalProductControllerInterceptor
extends ControllerInterceptor<UniversalProductDescriptionContainerVM, UniversalProductDescriptionContainerController> {
    protected Class<UniversalProductDescriptionContainerController> getControllerClass() {
        return UniversalProductDescriptionContainerController.class;
    }

    protected void onCreate(UniversalProductDescriptionContainerController controller) {
        UniversalProductDescriptionContainer panel = controller.getView();
        List<FinanceDocumentType> financeDocumentTypes = Arrays.asList(FinanceDocumentType.STANDARD_BILL, FinanceDocumentType.INVOICE, FinanceDocumentType.INVOICE_CONSOLIDATED, FinanceDocumentType.INVOICE_PREPAYMENT, FinanceDocumentType.CORRECTION_DOCUMENT, FinanceDocumentType.INVOICE_FACTURA, FinanceDocumentType.ACCEPTANCE_CERTIFICATE, FinanceDocumentType.UNIVERSAL_DOCUMENT);
        ComboBoxWidgetColumn finDocTypeColumn = (ComboBoxWidgetColumn)panel.getFinDocBillingItemsParametersNode().getColumn("finDocType");
        finDocTypeColumn.setItemsSupplier(Suppliers.createEnumSupplier(FinanceDocumentType.class, financeDocumentTypes::contains));
        BooleanValueWidgetColumn includeInFinDocColumn = (BooleanValueWidgetColumn)panel.getFinDocBillingItemsParametersNode().getColumn("includeInFinDoc");
        includeInFinDocColumn.setConverter(Converters.boolConverter((String)Messages.include, (String)Messages.exclude));
        FxUtil.addListener((ObservableValue)panel.getAutoGeneratedSystemNumbersNode().valueProperty(), (s, o, newValue) -> {
            panel.getTicketNumberRequiredNode().setDisable(newValue.booleanValue());
            if (newValue.booleanValue()) {
                panel.getTicketNumberRequiredNode().setValue(false);
            }
        });
    }

    protected void validateData(UniversalProductDescriptionContainerController controller, List<Message> messages) {
        UniversalProductDescriptionContainer container = controller.getView();
        if (container.getNameNode().getValue() == null || container.getNameNode().getValue().isEmpty()) {
            messages.add(this.getMessage(Messages.Name_of_the_universal_product_is_not_specified));
        }
        if (container.getBaseFareSupportedNode().getValue() & container.getBlankOwnerAndSupplierAreAgencyNode().getValue()) {
            messages.add(this.getMessage(Messages.Displaying_the_basic_tariff_not_possible));
        }
        ArrayList idList = new ArrayList();
        container.getCustomParametersNode().getViews().forEach(param -> {
            idList.add(param.getIdNode().getValue());
            if (param.getIdNode().getValue() == null || param.getIdNode().getValue().isEmpty()) {
                messages.add(this.getMessage(Messages.In_additional_parameters_ID_not_specified));
            }
            if (param.getDisplayNameNode().getValue() == null || param.getDisplayNameNode().getValue().isEmpty()) {
                messages.add(this.getMessage(Messages.In_additional_parameters_Name_not_specified));
            }
            if (param.getTypeNode().getValue() == null) {
                messages.add(this.getMessage(Messages.In_additional_parameters_Type_of_parameter_not_specified));
            } else if (((UniversalProductCustomParameterType)param.getTypeNode().getValue()).equals((Object)UniversalProductCustomParameterType.DICTIONARY) && param.getTypeAdditionalInfoNode().getValue() == null) {
                messages.add(this.getMessage(Messages.In_additional_parameters_Subtype_of_parameter_not_specified));
            }
        });
        long uniqueIdCount = idList.stream().filter(Objects::nonNull).map(String::trim).map(String::toUpperCase).distinct().count();
        if ((long)container.getCustomParametersNode().getViews().size() != uniqueIdCount) {
            messages.add(this.getMessage(Messages.In_additional_parameters_same_id));
        }
    }

    private Message getMessage(String text) {
        Message msg = new Message();
        msg.setType(MessageType.ERROR);
        L10nMessage l10 = new L10nMessage();
        l10.setKey(text);
        msg.setMessage(l10);
        return msg;
    }
}

