/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.activity.NavToolable;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.service.IndexListService;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavTool;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolData;
import com.gridnine.xtrip.common.Environment;
import java.io.Serializable;
import javafx.scene.control.SelectionMode;

public class IndexListActivityHandler
extends ActivityHandler<IndexListPane<?, ?>, IndexListNavToolData>
implements NavToolable<IndexListPane<?, ?>, IndexListNavToolData> {
    private static final String ID = "index-list-activity-handler";

    public static IndexListActivityHandler get() {
        return (IndexListActivityHandler)IndexListActivityHandler.forId((String)ID);
    }

    public static void register(ClientRegistry registry) {
        if (!registry.allOf(TYPE).containsKey(ID)) {
            registry.register((RegistryItem)new IndexListActivityHandler());
        }
    }

    private IndexListActivityHandler() {
        Environment.publish(IndexListService.class, (token, title, listParameters) -> {
            IndexListNavToolData data = new IndexListNavToolData();
            data.setIndexType(listParameters.getIndexType());
            data.setLimit(listParameters.getLimit());
            data.getSearchCriterions().addAll(listParameters.getSearchCriterions());
            data.getSortings().putAll(listParameters.getSortings());
            data.getColumns().addAll(listParameters.getColumns());
            data.getFilters().addAll(listParameters.getFilters());
            NavigationParameters parameters = new NavigationParameters();
            parameters.setTitle(title);
            parameters.setDescription(title);
            parameters.setParameters((Object)data);
            ActivityManager.get().navigate(token, (ActivityHandler)IndexListActivityHandler.get(), parameters);
        });
    }

    public String getId() {
        return ID;
    }

    protected IndexListPane<?, ?> createView(final ActivityState<IndexListPane<?, ?>, IndexListNavToolData> state) {
        IndexListPane result = new IndexListPane(state.getMutex(), new MultiSupplier(){

            public int count() {
                return 1;
            }

            public String getDisplayName(int idx) {
                return null;
            }

            public Object get(int idx) {
                IndexListParameters listParams = new IndexListParameters();
                listParams.setIndexType(((IndexListNavToolData)state.getParameters()).getIndexType());
                listParams.setLimit(((IndexListNavToolData)state.getParameters()).getLimit());
                listParams.getSearchCriterions().addAll(((IndexListNavToolData)state.getParameters()).getSearchCriterions());
                listParams.getRestrictions().addAll(((IndexListNavToolData)state.getParameters()).getRestrictionGroups());
                listParams.getSortings().putAll(((IndexListNavToolData)state.getParameters()).getSortings());
                listParams.getColumns().addAll(((IndexListNavToolData)state.getParameters()).getColumns());
                listParams.getFilters().addAll(((IndexListNavToolData)state.getParameters()).getFilters());
                listParams.getProjections().addAll(((IndexListNavToolData)state.getParameters()).getProjections());
                IndexListPaneConfiguration configuration = new IndexListPaneConfiguration(listParams.getIndexType());
                configuration.setSelectionMode(SelectionMode.MULTIPLE);
                configuration.setPatternSearchEnabled(true);
                configuration.setActionsEnabled(true);
                configuration.setLimit(listParams.getLimit());
                configuration.applyParameters(listParams);
                return configuration;
            }
        });
        EventBus.get().subscribe(EntityModificationEvent.TYPE, result.getModificationEventHandler());
        return result;
    }

    protected void onClosed(ActivityState<IndexListPane<?, ?>, IndexListNavToolData> state) {
        IndexListPane pane = (IndexListPane)this.getView(state);
        if (pane == null) {
            return;
        }
        EventBus.get().unsubscribe((Object)pane.getModificationEventHandler());
    }

    protected void saveChanges(ActivityState<IndexListPane<?, ?>, IndexListNavToolData> state) {
    }

    protected Serializer<IndexListNavToolData> getSerializer() {
        return IndexListNavToolData.SERIALIZER;
    }

    public void update(ActivityState<IndexListPane<?, ?>, IndexListNavToolData> state, NavigationParameters<IndexListNavToolData> parameters) {
        state.titleProperty().set((Object)parameters.getTitle());
        state.descriptionProperty().set((Object)parameters.getDescription());
        state.setParameters(parameters.getParameters());
        IndexListPane view = (IndexListPane)this.getView(state);
        if (view != null) {
            Serializable viewState = view.persistState();
            view.selectConfiguration(0);
            view.restoreState(viewState);
        }
    }

    public boolean isSupported(NavTool<?> tool) {
        return tool instanceof IndexListNavTool;
    }
}

