/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.list.ListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListActivityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolData;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolFieldsEditor;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolFiltersEditor;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolParameters;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolParametersEditor;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolProjectionsEditor;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolQueryEditor;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolSortingsEditor;
import com.gridnine.xtrip.client.fx.standard.helpers.IndexHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.ArrayList;
import java.util.List;

public class IndexListNavTool
implements NavTool<IndexListNavToolData> {
    public static final String ID = "index-list-nav-tool";

    public String getId() {
        return ID;
    }

    public IconShape getShape(boolean leaf) {
        return leaf ? StandardIconShapes.NAVIGATION_INDEX_14X14 : StandardIconShapes.NAVIGATION_INDEX_FOLDER_14X14;
    }

    public Serializer<IndexListNavToolData> getSerializer() {
        return IndexListNavToolData.SERIALIZER;
    }

    public void execute(String token, String name, String description, IndexListNavToolData data, boolean stateful, boolean update, boolean background) {
        if (data == null || data.getIndexType() == null) {
            Notifications.get().showFlashNotification(Messages.Viewing_is_not_possible, name);
            return;
        }
        IndexType indexType = MetaRegistryHelper.getIndexType((String)data.getIndexType().getName());
        if (indexType == null || !IndexHelper.isAvailable(indexType)) {
            Notifications.get().showFlashNotification(Messages.Viewing_is_not_possible, name);
            return;
        }
        NavigationParameters parameters = new NavigationParameters();
        parameters.setTitle(name);
        parameters.setDescription(description);
        parameters.setParameters((Object)data);
        ActivityManager.get().navigate(token, (ActivityHandler)IndexListActivityHandler.get(), parameters, stateful, update ? view -> {
            ActivityState state = ActivityManager.get().findState(token);
            if (state != null) {
                IndexListActivityHandler.get().update(state, (NavigationParameters<IndexListNavToolData>)parameters);
            }
        } : null, background);
    }

    public AclQuery toolACLQuery() {
        return null;
    }

    public AclQuery itemACLQuery(IndexListNavToolData data) {
        return data.getIndexType() == null ? null : AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.VIEW.getId(), data.getIndexType().getName()).build();
    }

    public boolean isExecutable() {
        return true;
    }

    public IndexListNavToolData createParameters() {
        return new IndexListNavToolData();
    }

    public IndexListNavToolData cloneParameters(IndexListNavToolData data) throws Exception {
        return IndexListNavToolParameters.clone(data);
    }

    public IndexListNavToolData cleanParameters(IndexListNavToolData data) {
        return IndexListNavToolParameters.clean(data);
    }

    public List<NavToolEditor> createEditors() {
        ArrayList<NavToolEditor> result = new ArrayList<NavToolEditor>();
        result.add(new IndexListNavToolParametersEditor());
        result.add(new IndexListNavToolQueryEditor());
        result.add(new IndexListNavToolFieldsEditor());
        result.add(new IndexListNavToolSortingsEditor());
        result.add(new IndexListNavToolFiltersEditor());
        if (ListPane.PROJECTIONS_ENABLED) {
            result.add(new IndexListNavToolProjectionsEditor());
        }
        return result;
    }
}

