/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.MetaField;
import com.gridnine.xtrip.client.fx.standard.helpers.IndexHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class IndexListNavToolHelper {
    IndexListNavToolHelper() {
    }

    static Supplier<List<IndexType>> createIndexTypesSupplier() {
        ValueHolder list = new ValueHolder(Collections.emptyList());
        Notifications.get().submitTask(() -> {
            List<IndexType> types = IndexHelper.getAvalableIndexTypes();
            HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
            for (IndexType indexType : types) {
                map.put(indexType.getId(), new AclQuery(StandardRestrictionResourceOperations.VIEW.getId(), indexType.getId()));
            }
            Set grantedUids = FxAclUtil.applyACL(map);
            Iterator<IndexType> it = types.iterator();
            while (it.hasNext()) {
                IndexType indexType = it.next();
                if (grantedUids.contains(indexType.getId())) continue;
                it.remove();
            }
            list.set(types);
        }, Messages.Forming_a_list_of_data_types);
        return () -> ((ValueHolder)list).get();
    }

    static List<MetaField> getAvailableFields(IndexType type, Predicate<IndexProperty> propertyFilter, Predicate<IndexCollection> collectionFilter) {
        if (type == null) {
            return Collections.emptyList();
        }
        return Stream.concat(type.getProperties().values().stream().filter(propertyFilter).map(item -> new MetaField((IndexProperty)item)), type.getCollections().values().stream().filter(collectionFilter).map(item -> new MetaField((IndexCollection)item))).collect(Collectors.toList());
    }
}

