/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolData;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.workspace.event.WorkspaceItemChangedEvent;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

class IndexListNavToolParametersEditor
extends StackPane
implements NavToolEditor,
DevTool {
    private static final List<Integer> limits = Arrays.asList(50, 100, 150, 200, 500);
    private GridCell<ComboBoxWidget<IndexType>> indexTypeCell;
    private GridCell<RadioBoxWidget<Integer>> indexLimitCell;
    private FxWorkspaceItem workspaceItem;
    private boolean initialized;

    IndexListNavToolParametersEditor() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Pane editorPane = this.createEditorPane();
        this.getChildren().setAll((Object[])new Node[]{editorPane});
    }

    private Pane createEditorPane() {
        this.indexTypeCell = new GridCell(Messages.Data_Type, (Node)new ComboBoxWidget(false));
        ((ComboBoxWidget)this.indexTypeCell.getPayload()).setNoNulls(true);
        ((ComboBoxWidget)this.indexTypeCell.getPayload()).setItemsSupplier(IndexListNavToolHelper.createIndexTypesSupplier());
        ((ComboBoxWidget)this.indexTypeCell.getPayload()).setLive(true);
        ((ComboBoxWidget)this.indexTypeCell.getPayload()).setConverter((StringConverter)new StringConverter<IndexType>(){

            public String toString(IndexType object) {
                return object != null ? object.getDisplayName() : UiUtil.NULL_TEXT;
            }

            public IndexType fromString(String string) {
                return null;
            }
        });
        ((ComboBoxWidget)this.indexTypeCell.getPayload()).setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(((ComboBoxWidget)this.indexTypeCell.getPayload()).getConverter(), ((ComboBoxWidget)this.indexTypeCell.getPayload()).getItemsSupplier(), ((ComboBoxWidget)this.indexTypeCell.getPayload()).isSortItems()));
        this.indexLimitCell = new GridCell(Messages.Elements_per_page, (Node)new RadioBoxWidget(false));
        ((RadioBoxWidget)this.indexLimitCell.getPayload()).setItemsSupplier(() -> limits);
        GridContainer editorPane = new GridContainer(3);
        editorPane.getCells().addAll((Object[])new GridCell[]{this.indexTypeCell, this.indexLimitCell});
        return editorPane;
    }

    private void createBindings() {
    }

    private void createListeners() {
        ((ComboBoxWidget)this.indexTypeCell.getPayload()).valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.initialized) {
                block9: {
                    if (newValue != null) {
                        NavTool tool = NavTool.forId((String)this.workspaceItem.getToolId());
                        try {
                            IndexListNavToolData data = (IndexListNavToolData)tool.createParameters();
                            if (data != null) {
                                Class indexType = XSHelper.getClass((String)newValue.getId());
                                Class entityType = XSHelper.getClass((String)newValue.getEntityId());
                                if (indexType != null && entityType != null) {
                                    data.setIndexType(indexType);
                                    EntityIndexHandler handler = EntityIndexHandler.forIndexClass((Class)indexType);
                                    if (handler != null) {
                                        IndexListParameters indexListParameters = handler.createListParameters();
                                        int limit = indexListParameters.getLimit();
                                        if (limit <= 0) {
                                            limit = 100;
                                        }
                                        data.setLimit(limit);
                                        data.getSortings().clear();
                                        data.getSortings().putAll(indexListParameters.getSortings());
                                        data.getColumns().clear();
                                        data.getColumns().addAll(indexListParameters.getColumns());
                                        data.getFilters().clear();
                                        data.getFilters().addAll(indexListParameters.getFilters());
                                        data.getProjections().clear();
                                        data.getProjections().addAll(indexListParameters.getProjections());
                                        data.getRestrictionGroups().clear();
                                        data.getRestrictionGroups().addAll(indexListParameters.getRestrictions());
                                        data.getSearchCriterions().clear();
                                        data.getSearchCriterions().addAll(indexListParameters.getSearchCriterions());
                                    }
                                }
                                this.workspaceItem.setParameters(tool.getSerializer().serialize((Object)data));
                                break block9;
                            }
                            this.workspaceItem.setParameters(null);
                        }
                        catch (Exception e) {
                            ErrorHandler.handle((Throwable)e);
                        }
                    } else {
                        this.workspaceItem.setParameters(null);
                    }
                }
                EventBus.get().publishSync((Event)new WorkspaceItemChangedEvent(WorkspaceItemChangedEvent.ChangeType.PARAMETERS));
            }
        });
    }

    public Card<Node> getContent() {
        return new Card("displayParameters", UiCardsContainer.Style.STATIC, Messages.Display_Options, (Node)this);
    }

    public boolean isDataChanged() {
        if (this.workspaceItem == null) {
            return false;
        }
        NavTool tool = NavTool.forId((String)this.workspaceItem.getToolId());
        try {
            IndexListNavToolData data = (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(this.workspaceItem.getParameters()));
            if (data != null) {
                if (!MiscUtil.equals(data.getIndexType(), ((ComboBoxWidget)this.indexTypeCell.getPayload()).getValue() != null ? XSHelper.getClass((String)((IndexType)((ComboBoxWidget)this.indexTypeCell.getPayload()).getValue()).getId()) : null)) {
                    return true;
                }
                if (!MiscUtil.equals((Object)data.getLimit(), (Object)((RadioBoxWidget)this.indexLimitCell.getPayload()).getValue())) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return false;
    }

    public void readData(FxWorkspaceItem item) {
        this.initialized = false;
        this.workspaceItem = item;
        ((ComboBoxWidget)this.indexTypeCell.getPayload()).setValue(null);
        ((RadioBoxWidget)this.indexLimitCell.getPayload()).setValue(null);
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data = (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters()));
            if (data != null) {
                IndexType indexType;
                IndexType indexType2 = indexType = data.getIndexType() != null ? (IndexType)MetaRegistry.get().getIndexes().get(data.getIndexType().getName()) : null;
                if (indexType != null) {
                    ((ComboBoxWidget)this.indexTypeCell.getPayload()).setValue((Object)indexType);
                    int limit = data.getLimit();
                    ((RadioBoxWidget)this.indexLimitCell.getPayload()).setValue((Object)limit);
                }
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        this.initialized = true;
    }

    public void writeData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data;
            IndexListNavToolData indexListNavToolData = data = item.getParameters() != null ? (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters())) : (IndexListNavToolData)tool.createParameters();
            if (data != null) {
                Class indexType;
                Class clazz = indexType = ((ComboBoxWidget)this.indexTypeCell.getPayload()).getValue() != null ? XSHelper.getClass((String)((IndexType)((ComboBoxWidget)this.indexTypeCell.getPayload()).getValue()).getId()) : null;
                if (indexType != null) {
                    data.setIndexType(indexType);
                    Integer indexLimit = (Integer)((RadioBoxWidget)this.indexLimitCell.getPayload()).getValue();
                    if (indexLimit == null || indexLimit <= 0) {
                        indexLimit = 100;
                    }
                    data.setLimit(indexLimit);
                }
                item.setParameters(tool.getSerializer().serialize((Object)data));
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Arrays.asList(IndexListNavToolParametersEditor.this.indexTypeCell, IndexListNavToolParametersEditor.this.indexLimitCell);
            }

            public String getInfo() {
                return ((Object)((Object)IndexListNavToolParametersEditor.this)).getClass().getSimpleName();
            }
        };
    }
}

