/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.custom.restrictions.RestrictionsData;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolData;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.restriction.BasicRestrictionsWidget;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

class IndexListNavToolQueryEditor
extends StackPane
implements NavToolEditor,
DevTool {
    private BasicRestrictionsWidget table;

    IndexListNavToolQueryEditor() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Pane editorPane = this.createEditorPane();
        this.getChildren().setAll((Object[])new Node[]{editorPane});
    }

    private Pane createEditorPane() {
        this.table = new BasicRestrictionsWidget(false);
        return this.table;
    }

    private void createBindings() {
    }

    private void createListeners() {
    }

    public Card<Node> getContent() {
        return new Card("criterions", UiCardsContainer.Style.COLLAPSED, Messages.Selection_criteria, (Node)this);
    }

    public boolean isDataChanged() {
        return this.table.isDataChanged();
    }

    public void readData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data = (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters()));
            if (data != null) {
                IndexType indexType = data.getIndexType() != null ? (IndexType)MetaRegistry.get().getIndexes().get(data.getIndexType().getName()) : null;
                RestrictionsData restrictionsData = new RestrictionsData();
                restrictionsData.setRestrictionId(indexType != null ? indexType.getId() : null);
                restrictionsData.getRestrictions().clear();
                restrictionsData.getRestrictions().addAll(data.getRestrictionGroups());
                this.table.readData(restrictionsData);
            } else {
                this.table.readData(new RestrictionsData());
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            this.table.readData(new RestrictionsData());
        }
    }

    public void writeData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data;
            IndexListNavToolData indexListNavToolData = data = item.getParameters() != null ? (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters())) : (IndexListNavToolData)tool.createParameters();
            if (data != null) {
                RestrictionsData restrictionsData = new RestrictionsData();
                this.table.writeData(restrictionsData);
                data.getRestrictionGroups().clear();
                data.getRestrictionGroups().addAll(restrictionsData.getRestrictions());
                item.setParameters(tool.getSerializer().serialize((Object)data));
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(IndexListNavToolQueryEditor.this.table);
            }

            public String getInfo() {
                return ((Object)((Object)IndexListNavToolQueryEditor.this)).getClass().getSimpleName();
            }
        };
    }
}

