/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.factory.basic;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataOrganizationRequestSearchDataPanelController;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataPersonRequestSearchDataPanelController;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.personal.data.PersonalDataRequestControllerInterceptorHelper;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.PersonalDataService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.PersonalDataOrganizationSearchData;
import com.gridnine.xtrip.common.model.PersonalDataPerson;
import com.gridnine.xtrip.common.model.PersonalDataPersonEmail;
import com.gridnine.xtrip.common.model.PersonalDataPersonName;
import com.gridnine.xtrip.common.model.PersonalDataPersonPassport;
import com.gridnine.xtrip.common.model.PersonalDataPersonPhone;
import com.gridnine.xtrip.common.model.PersonalDataPersonSearchData;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import javafx.scene.Node;

enum PersonalDataFactoryTools implements FactoryTool
{
    ERASURE_PERSON_REQUEST{

        public String getName() {
            return com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataErasurePersonRequest;
        }

        public void execute() {
            Dialog dialog = new Dialog();
            PersonalDataPersonRequestSearchDataPanelController controller = new PersonalDataPersonRequestSearchDataPanelController(false);
            PersonalDataRequestControllerInterceptorHelper.configurePersonSearchData(controller, () -> false);
            dialog.setBody((Node)controller.getView()).setTitle(this.getName()).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel, () -> dialog.close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Create, () -> {
                PersonalDataPersonSearchData searchData = new PersonalDataPersonSearchData();
                searchData.setPerson(controller.getView().getPersonNode().getValue());
                ArrayList nameRows = new ArrayList();
                ArrayList passportRows = new ArrayList();
                ArrayList phoneRows = new ArrayList();
                ArrayList emailRows = new ArrayList();
                controller.getNames().writeData(nameRows);
                controller.getPassports().writeData(passportRows);
                controller.getPhones().writeData(phoneRows);
                controller.getEmails().writeData(emailRows);
                VMHelper.transfer(nameRows, searchData.getNames(), source -> new PersonalDataPersonName(), (source, destination) -> {
                    destination.setLastName(source.getLastName());
                    destination.setFirstName(source.getFirstName());
                    destination.setMiddleName(source.getMiddleName());
                });
                VMHelper.transfer(passportRows, searchData.getPassports(), source -> new PersonalDataPersonPassport(), (source, destination) -> destination.setNumber(source.getNumber()));
                VMHelper.transfer(phoneRows, searchData.getPhones(), source -> new PersonalDataPersonPhone(), (source, destination) -> destination.setNumber(source.getNumber()));
                VMHelper.transfer(emailRows, searchData.getEmails(), source -> new PersonalDataPersonEmail(), (source, destination) -> destination.setAddress(source.getAddress()));
                ArrayList<Message> messages = new ArrayList<Message>();
                if (searchData.getNames().stream().anyMatch(item -> TextUtil.isBlank((String)item.getLastName()) || TextUtil.isBlank((String)item.getFirstName()))) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataPersonRequestSearchDataNameNotSpecified, (Object[])new Object[0]));
                }
                if (searchData.getNames().size() == 0) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataPersonRequestSearchDataNameEmpty, (Object[])new Object[0]));
                }
                if (searchData.getPassports().stream().anyMatch(item -> TextUtil.isBlank((String)item.getNumber()))) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataPersonRequestSearchDataPassportNotSpecified, (Object[])new Object[0]));
                }
                if (searchData.getPassports().size() == 0) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataPersonRequestSearchDataPassportEmpty, (Object[])new Object[0]));
                }
                if (messages.size() > 0) {
                    dialog.setValidationMessages(true, messages);
                } else {
                    dialog.close();
                    Notifications.get().submitTask(() -> {
                        EntityReference request = ((PersonalDataService)RpcServiceManager.get().getService(PersonalDataService.class)).createErasurePersonRequest(ServiceInvocationContext.get(), searchData);
                        FxUtil.submitToFxThread(() -> RootEntityEditingService.navigateTo((EntityReference)request));
                    }, Messages.General_Data_loading);
                }
            }).setExpandToParent(true).setAutoClose(false).setOnCloseRequest(() -> dialog.close()).showGlobal();
        }

        public AclQuery getACLQuery() {
            return null;
        }
    }
    ,
    ERASURE_ORGANIZATION_REQUEST{

        public String getName() {
            return com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataErasureOrganizationRequest;
        }

        public void execute() {
            Dialog dialog = new Dialog();
            PersonalDataOrganizationRequestSearchDataPanelController controller = new PersonalDataOrganizationRequestSearchDataPanelController(false);
            PersonalDataRequestControllerInterceptorHelper.configureOrganizationSearchData(controller, () -> false);
            dialog.setBody((Node)controller.getView()).setTitle(this.getName()).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel, () -> dialog.close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Create, () -> {
                PersonalDataOrganizationSearchData searchData = new PersonalDataOrganizationSearchData();
                searchData.setOrganization(controller.getView().getOrganizationNode().getValue());
                ArrayList personRows = new ArrayList();
                controller.getPersons().writeData(personRows);
                VMHelper.transfer(personRows, searchData.getPersons(), source -> new PersonalDataPerson(), (source, destination) -> {
                    destination.setPerson(source.getPerson());
                    destination.setSearch(source.isSearch());
                });
                ArrayList<Message> messages = new ArrayList<Message>();
                if (searchData.getPersons().stream().allMatch(item -> !item.isSearch())) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataOrganizationRequestSearchDataPersonNotSelected, (Object[])new Object[0]));
                }
                if (searchData.getPersons().size() == 0) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataOrganizationRequestSearchDataPersonEmpty, (Object[])new Object[0]));
                }
                if (messages.size() > 0) {
                    dialog.setValidationMessages(true, messages);
                } else {
                    dialog.close();
                    Notifications.get().submitTask(() -> {
                        EntityReference request = ((PersonalDataService)RpcServiceManager.get().getService(PersonalDataService.class)).createErasureOrganizationRequest(ServiceInvocationContext.get(), searchData);
                        FxUtil.submitToFxThread(() -> RootEntityEditingService.navigateTo((EntityReference)request));
                    }, Messages.General_Data_loading);
                }
            }).setExpandToParent(true).setAutoClose(false).setOnCloseRequest(() -> dialog.close()).showGlobal();
        }

        public AclQuery getACLQuery() {
            return null;
        }
    }
    ,
    RESTRICTION_PERSON_REQUEST{

        public String getName() {
            return com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataRestrictionPersonRequest;
        }

        public void execute() {
            Dialog dialog = new Dialog();
            PersonalDataPersonRequestSearchDataPanelController controller = new PersonalDataPersonRequestSearchDataPanelController(false);
            PersonalDataRequestControllerInterceptorHelper.configurePersonSearchData(controller, () -> false);
            dialog.setBody((Node)controller.getView()).setTitle(this.getName()).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel, () -> dialog.close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Create, () -> {
                PersonalDataPersonSearchData searchData = new PersonalDataPersonSearchData();
                searchData.setPerson(controller.getView().getPersonNode().getValue());
                ArrayList nameRows = new ArrayList();
                ArrayList passportRows = new ArrayList();
                ArrayList phoneRows = new ArrayList();
                ArrayList emailRows = new ArrayList();
                controller.getNames().writeData(nameRows);
                controller.getPassports().writeData(passportRows);
                controller.getPhones().writeData(phoneRows);
                controller.getEmails().writeData(emailRows);
                VMHelper.transfer(nameRows, searchData.getNames(), source -> new PersonalDataPersonName(), (source, destination) -> {
                    destination.setLastName(source.getLastName());
                    destination.setFirstName(source.getFirstName());
                    destination.setMiddleName(source.getMiddleName());
                });
                VMHelper.transfer(passportRows, searchData.getPassports(), source -> new PersonalDataPersonPassport(), (source, destination) -> destination.setNumber(source.getNumber()));
                VMHelper.transfer(phoneRows, searchData.getPhones(), source -> new PersonalDataPersonPhone(), (source, destination) -> destination.setNumber(source.getNumber()));
                VMHelper.transfer(emailRows, searchData.getEmails(), source -> new PersonalDataPersonEmail(), (source, destination) -> destination.setAddress(source.getAddress()));
                ArrayList<Message> messages = new ArrayList<Message>();
                if (searchData.getNames().stream().anyMatch(item -> TextUtil.isBlank((String)item.getLastName()) || TextUtil.isBlank((String)item.getFirstName()))) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataPersonRequestSearchDataNameNotSpecified, (Object[])new Object[0]));
                }
                if (searchData.getNames().size() == 0) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataPersonRequestSearchDataNameEmpty, (Object[])new Object[0]));
                }
                if (searchData.getPassports().stream().anyMatch(item -> TextUtil.isBlank((String)item.getNumber()))) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataPersonRequestSearchDataPassportNotSpecified, (Object[])new Object[0]));
                }
                if (searchData.getPassports().size() == 0) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.personalDataPersonRequestSearchDataPassportEmpty, (Object[])new Object[0]));
                }
                if (messages.size() > 0) {
                    dialog.setValidationMessages(true, messages);
                } else {
                    dialog.close();
                    Notifications.get().submitTask(() -> {
                        EntityReference request = ((PersonalDataService)RpcServiceManager.get().getService(PersonalDataService.class)).createRestrictionPersonRequest(ServiceInvocationContext.get(), searchData);
                        FxUtil.submitToFxThread(() -> RootEntityEditingService.navigateTo((EntityReference)request));
                    }, Messages.General_Data_loading);
                }
            }).setExpandToParent(true).setAutoClose(false).setOnCloseRequest(() -> dialog.close()).showGlobal();
        }

        public AclQuery getACLQuery() {
            return null;
        }
    };


    public String getUid() {
        return "personal-data-tools:" + this.name();
    }

    public FactoryToolCategory getCategory() {
        return StandardCategories.PERSONAL_DATA;
    }

    public double getWeight() {
        return this.ordinal();
    }

    public boolean isAuxiliary() {
        return false;
    }
}

