/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ProfilesSynchronizationService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SabreProfilesUpdatePersonTask
extends ClientTask {
    private final EntityContainer<Person> person;

    public SabreProfilesUpdatePersonTask(EntityContainer<Person> person) {
        this.person = person;
    }

    protected String getTitle() {
        return Messages.Traveler_update_Sabre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        ProfilesSynchronizationService syncService = (ProfilesSynchronizationService)RpcServiceManager.get().getService(ProfilesSynchronizationService.class);
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        ArrayList<Message> validationErrors = new ArrayList<Message>();
        ValueHolder continueHolder = new ValueHolder((Object)Boolean.TRUE);
        if (!this.checkAccess(this.person, validationErrors)) {
            this.showErrors(validationErrors);
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.No_permissions_for_synhronization_traveler_profile, (Object[])new Object[0])});
            continueHolder.set((Object)Boolean.FALSE);
        }
        if (this.person == null || this.person.getEntity() == null) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Profile_is_empty_obj, (Object[])new Object[0]));
            this.showErrors(validationErrors);
            return;
        }
        if (!syncService.isLoadAllowed(ServiceInvocationContext.get(), this.person.toReference())) {
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"SabreProfiles_ProfileLoadingNotAllowed", (Object[])new Object[]{this.person.toReference()})});
        }
        SabreProfilesPccSettings pccSetting = null;
        if (Boolean.TRUE.equals(continueHolder.get()) && ((pccSetting = SabreProfilesSynchronizationUtil.getUniqueIDsPccSettings(Messages.Traveler_update_Sabre, validationErrors, (ValueHolder<Boolean>)continueHolder, SabreProfilesSynchronizationUtil.getPccSettingsFromProfilesUniqueIDs(this.person))) == null || TextUtil.isBlank((String)pccSetting.getPcc()))) {
            this.showErrors(Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Treveler_profile_didnt_updated_no_pcc, (Object[])new Object[0])));
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Treveler_profile_didnt_updated_no_pcc, (Object[])new Object[0])});
            continueHolder.set((Object)Boolean.FALSE);
        }
        if (Boolean.TRUE.equals(continueHolder.get())) {
            pccSetting.setPcc(pccSetting.getPcc().toUpperCase());
            ArrayList<Message> msgs = new ArrayList<Message>();
            try {
                MiscUtil.Pair result = syncService.loadExistPerson(sic, this.person.toReference(), pccSetting, false, true);
                msgs.addAll((Collection)result.getSecond());
            }
            catch (Exception e) {
                msgs.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"{0}", (Object[])new Object[]{e.getMessage()}));
            }
            finally {
                this.showErrors(msgs);
            }
        }
        if (Boolean.TRUE.equals(continueHolder.get())) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.person.toReference(), EntityModification.ModificationType.CHANGE)));
        }
    }

    private boolean checkAccess(EntityContainer<Person> perCont, List<Message> messages) throws Exception {
        return true;
    }

    private void showErrors(List<Message> validationErrors) throws Exception {
        this.addMessages(validationErrors);
    }
}

