/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.common.fx.model.AppConfigData;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import java.util.Date;

public final class AppConfigHelper {
    private static final String SCOPE_MOM = "mom";
    private static final String SCOPE_IBE = "ibe";
    private static AppConfigData configData;

    public static void init(AppConfigData config) {
        configData = config;
    }

    public static boolean isOnlineGdsEnabled() {
        return configData != null && configData.isOnlineGdsEnabled();
    }

    public static boolean isIbeEnabled() {
        return configData != null && configData.isIbeEnabled();
    }

    public static boolean isTravelPolicyEnabled() {
        return configData != null && configData.isTravelPolicyAuthEnabled();
    }

    public static boolean isCollectTechnicalFee() {
        return configData != null && configData.isCollectTechnicalFee();
    }

    public static Date getCollectTechnicalFeeBeginDate() {
        return configData != null ? configData.getCollectTechnicalFeeBeginDate() : null;
    }

    public static boolean isInScope(DictionaryType type) {
        return AppConfigHelper.check(type.getScope(), null);
    }

    public static boolean isInScope(EntityType type) {
        return AppConfigHelper.check(type.getScope(), null);
    }

    public static boolean isInScope(IndexType type) {
        return AppConfigHelper.check(type.getScope(), null);
    }

    public static boolean isInScope(IndexProperty type) {
        return AppConfigHelper.check(type.getScope(), null);
    }

    public static boolean isInScope(IndexCollection type) {
        return AppConfigHelper.check(type.getScope(), null);
    }

    public static boolean isInScope(IndexType type, IndexProperty prop) {
        return AppConfigHelper.check(type.getScope(), prop.getScope());
    }

    public static boolean isInScope(IndexType type, IndexCollection coll) {
        return AppConfigHelper.check(type.getScope(), coll.getScope());
    }

    private static boolean check(String typeScope, String fieldScope) {
        if (typeScope == null && fieldScope == null) {
            return true;
        }
        if (fieldScope != null) {
            if (SCOPE_IBE.equals(fieldScope)) {
                return AppConfigHelper.isIbeEnabled();
            }
            if (SCOPE_MOM.equals(fieldScope)) {
                return AppConfigHelper.isOnlineGdsEnabled();
            }
            if (typeScope == null) {
                return true;
            }
        }
        if (SCOPE_IBE.equals(typeScope)) {
            return AppConfigHelper.isIbeEnabled();
        }
        if (SCOPE_MOM.equals(typeScope)) {
            return AppConfigHelper.isOnlineGdsEnabled();
        }
        return true;
    }

    private AppConfigHelper() {
    }
}

