/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.QueryDataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.PlainGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ListItemStringConverter;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentDocumentsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentRelatedDocumentsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentTransactionsViewVM;
import com.gridnine.xtrip.client.fx.model.system.AddRelatedDocumentPanel;
import com.gridnine.xtrip.client.fx.model.system.RelatedDocumentNavigationKey;
import com.gridnine.xtrip.client.fx.model.system.RelatedDocumentsDataItemVM;
import com.gridnine.xtrip.client.fx.model.system.RelatedDocumentsPanel;
import com.gridnine.xtrip.client.fx.model.system.SysLogDataItemVM;
import com.gridnine.xtrip.client.fx.standard.helpers.RelatedDocumentsActions;
import com.gridnine.xtrip.client.fx.standard.helpers.RelatedDocumentsConfiguration;
import com.gridnine.xtrip.client.fx.standard.helpers.RelatedDocumentsFilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.fx.rpc.TransactionDataForBookingFile;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.CreditSlip;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;
import javafx.scene.input.TransferMode;
import javafx.util.Pair;
import javafx.util.StringConverter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;

public final class DataViewWidgetHelper {
    public static void configurePaymentRelatedDocumentsView(DataViewWidget<BasePaymentDocumentRelatedDocumentsViewVM> widget, final Supplier<EntityContainer<? extends BasePaymentDocument>> supplier, ObservableValue<Boolean> collapsed) {
        DataViewHandler<BasePaymentDocumentRelatedDocumentsViewVM> handler = new DataViewHandler<BasePaymentDocumentRelatedDocumentsViewVM>(){

            protected int getLimit() {
                return Integer.MAX_VALUE;
            }

            protected int getOffset() {
                return 0;
            }

            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                EntityContainer container = (EntityContainer)supplier.get();
                if (container == null) {
                    this.getData().clear();
                    return;
                }
                Notifications.get().submitTask(() -> {
                    ArrayList<BasePaymentDocumentRelatedDocumentsViewVM> data = new ArrayList<BasePaymentDocumentRelatedDocumentsViewVM>();
                    EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                    BasePaymentDocument doc = (BasePaymentDocument)container.getEntity();
                    List finDocRefs = doc.getFinanceDocuments();
                    for (EntityReference finDocRef : finDocRefs) {
                        EntityContainer finDocCtr = entityService.load(ServiceInvocationContext.get(), finDocRef);
                        if (finDocCtr == null) continue;
                        FinanceDocument financeDocumentEntity = (FinanceDocument)finDocCtr.getEntity();
                        BasePaymentDocumentRelatedDocumentsViewVM vm = new BasePaymentDocumentRelatedDocumentsViewVM();
                        vm.setType(financeDocumentEntity.getType() != null ? financeDocumentEntity.getType().toString() : null);
                        vm.setNumber(financeDocumentEntity.getNumber());
                        vm.setName(financeDocumentEntity.getName());
                        vm.setReference(finDocCtr.toReference());
                        data.add(vm);
                    }
                    doc.getRelatedShipments().forEach(shipmentRef -> {
                        EntityContainer shipmentCtr = null;
                        try {
                            shipmentCtr = entityService.load(ServiceInvocationContext.get(), shipmentRef);
                        }
                        catch (ServiceException e) {
                            ErrorHandler.handle((Throwable)e);
                        }
                        if (shipmentCtr != null) {
                            Shipment shipmentEntity = (Shipment)shipmentCtr.getEntity();
                            BasePaymentDocumentRelatedDocumentsViewVM vm = new BasePaymentDocumentRelatedDocumentsViewVM();
                            vm.setType(Messages.Implementation);
                            vm.setNumber(shipmentEntity.getNumber());
                            vm.setName(shipmentEntity.toString());
                            vm.setReference(shipmentCtr.toReference());
                            data.add(vm);
                        }
                    });
                    if (doc instanceof CreditSlip) {
                        for (EntityReference reference : ((CreditSlip)doc).getOwners()) {
                            BasePaymentDocumentRelatedDocumentsViewVM vm = new BasePaymentDocumentRelatedDocumentsViewVM();
                            vm.setType(Messages.booking);
                            vm.setNumber(reference.getCaption());
                            vm.setName(reference.getCaption());
                            vm.setReference(reference);
                            data.add(vm);
                        }
                    }
                    Collections.sort(data, (lhs, rhs) -> {
                        int result = MiscUtil.compare((Comparable)((Object)rhs.getType()), (Comparable)((Object)lhs.getType()));
                        if (result != 0) {
                            return result;
                        }
                        result = MiscUtil.compare((Comparable)((Object)rhs.getNumber()), (Comparable)((Object)lhs.getNumber()));
                        if (result != 0) {
                            return result;
                        }
                        return MiscUtil.compare((Comparable)((Object)rhs.getName()), (Comparable)((Object)lhs.getName()));
                    });
                    FxUtil.waitForFxThread(() -> this.getData().setAll((Collection)data));
                }, this.getMutex());
            }
        };
        widget.setHandler((DataViewHandler)handler);
        widget.getTableView().setActionHandler((TableActionHandler)new TableActionHandler<BasePaymentDocumentRelatedDocumentsViewVM>(){

            public void onAction(TableColumn<BasePaymentDocumentRelatedDocumentsViewVM, ?> column, BasePaymentDocumentRelatedDocumentsViewVM item) {
                RootEntityEditingService.navigateTo((EntityReference)item.getReference());
            }

            public boolean isActive(TableColumn<BasePaymentDocumentRelatedDocumentsViewVM, ?> column, BasePaymentDocumentRelatedDocumentsViewVM item) {
                return false;
            }
        });
        widget.setDefaultActionHandler(() -> {
            BasePaymentDocumentRelatedDocumentsViewVM selected = (BasePaymentDocumentRelatedDocumentsViewVM)widget.getTableView().getSelectionModel().getSelectedItem();
            if (selected != null) {
                RootEntityEditingService.navigateTo((EntityReference)selected.getReference());
            }
        });
        if (collapsed != null) {
            FxUtil.addListener(collapsed, (obj, o, n) -> {
                if (!n.booleanValue() && !widget.isDataLoaded()) {
                    widget.reloadData();
                }
            });
        }
    }

    public static void configureTransactionsDataViewForSlip(final DataViewWidget<BasePaymentDocumentTransactionsViewVM> widget, final Supplier<EntityContainer<? extends BasePaymentDocument>> supplier, ObservableValue<Boolean> collapsed) {
        QueryDataViewHandler<BasePaymentDocumentTransactionsViewVM> handler = new QueryDataViewHandler<BasePaymentDocumentTransactionsViewVM>(){

            protected List<BasePaymentDocumentTransactionsViewVM> executeQuery(SearchQuery query) throws Exception {
                EntityContainer ctr = (EntityContainer)supplier.get();
                if (ctr == null) {
                    return Collections.emptyList();
                }
                ArrayList<BasePaymentDocumentTransactionsViewVM> resultVM = new ArrayList<BasePaymentDocumentTransactionsViewVM>();
                List indexList = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).loadTransactionForSlip(ServiceInvocationContext.get(), ctr.toReference(), ((BasePaymentDocument)ctr.getEntity()).getOrganization());
                DimensionType dimensionType1 = null;
                DimensionType dimensionType2 = null;
                DimensionType dimensionType3 = null;
                for (TransactionDataForBookingFile index : indexList) {
                    BasePaymentDocumentTransactionsViewVM dataViewVM = new BasePaymentDocumentTransactionsViewVM();
                    dataViewVM.setDate((String)StandardRenderers.DATE.apply((Object)index.getTransactionDate()));
                    dataViewVM.setDescription(index.getDescription());
                    if (index.isCredit()) {
                        dataViewVM.setCreditAmount((String)StandardRenderers.PRICE.apply((Object)index.getTransactionSum()));
                    } else {
                        dataViewVM.setDebitAmount((String)StandardRenderers.PRICE.apply((Object)index.getTransactionSum()));
                    }
                    if (index.getStatus() != null) {
                        dataViewVM.setStatus(index.getStatus().toString());
                    }
                    dimensionType1 = index.getDimensionType1();
                    dimensionType2 = index.getDimensionType2();
                    dimensionType3 = index.getDimensionType3();
                    if (index.getDimensionValue1() != null) {
                        DataViewWidgetHelper.fillingDataViewVM(index.getDimensionType1(), dataViewVM, index.getDimensionValue1().toString());
                    }
                    if (index.getDimensionValue2() != null) {
                        DataViewWidgetHelper.fillingDataViewVM(index.getDimensionType2(), dataViewVM, index.getDimensionValue2().toString());
                    }
                    if (index.getDimensionValue3() != null) {
                        DataViewWidgetHelper.fillingDataViewVM(index.getDimensionType3(), dataViewVM, index.getDimensionValue3().toString());
                    }
                    resultVM.add(dataViewVM);
                }
                DimensionType finalDimensionType1 = dimensionType1;
                DimensionType finalDimensionType2 = dimensionType2;
                DimensionType finalDimensionType3 = dimensionType3;
                FxUtil.waitForFxThread(() -> DataViewWidgetHelper.configureColumns((DataViewWidget<BasePaymentDocumentTransactionsViewVM>)widget, finalDimensionType1, finalDimensionType2, finalDimensionType3));
                return resultVM;
            }
        };
        handler.setQuery(new SearchQuery());
        widget.setHandler((DataViewHandler)handler);
        if (collapsed != null) {
            FxUtil.addListener(collapsed, (obj, o, n) -> {
                if (!n.booleanValue() && !widget.isDataLoaded()) {
                    widget.reloadData();
                }
            });
        }
    }

    public static void configureTransactionsDataViewForBankTransferOrder(final DataViewWidget<BasePaymentDocumentTransactionsViewVM> widget, final Supplier<EntityContainer<? extends BasePaymentDocument>> supplier, ObservableValue<Boolean> collapsed) {
        QueryDataViewHandler<BasePaymentDocumentTransactionsViewVM> handler = new QueryDataViewHandler<BasePaymentDocumentTransactionsViewVM>(){

            protected List<BasePaymentDocumentTransactionsViewVM> executeQuery(SearchQuery query) throws Exception {
                if (supplier.get() == null) {
                    return Collections.emptyList();
                }
                ArrayList<BasePaymentDocumentTransactionsViewVM> resultVM = new ArrayList<BasePaymentDocumentTransactionsViewVM>();
                NestedEntityReference nestedRefContract = ((BasePaymentDocument)((EntityContainer)supplier.get()).getEntity()).getContract();
                if (nestedRefContract == null) {
                    return Collections.emptyList();
                }
                EntityReference refContract = new EntityReference(nestedRefContract.getUid(), nestedRefContract.getType(), nestedRefContract.getCaption());
                List indexList = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).loadTransactionForBankTransferOrder(ServiceInvocationContext.get(), ((EntityContainer)supplier.get()).toReference(), refContract);
                DimensionType dimensionType1 = null;
                DimensionType dimensionType2 = null;
                DimensionType dimensionType3 = null;
                for (TransactionDataForBookingFile index : indexList) {
                    BasePaymentDocumentTransactionsViewVM dataViewVM = new BasePaymentDocumentTransactionsViewVM();
                    dataViewVM.setDate((String)StandardRenderers.DATE.apply((Object)index.getTransactionDate()));
                    dataViewVM.setDescription(index.getDescription());
                    if (index.isCredit()) {
                        dataViewVM.setCreditAmount((String)StandardRenderers.PRICE.apply((Object)index.getTransactionSum()));
                    } else {
                        dataViewVM.setDebitAmount((String)StandardRenderers.PRICE.apply((Object)index.getTransactionSum()));
                    }
                    if (index.getStatus() != null) {
                        dataViewVM.setStatus(index.getStatus().toString());
                    }
                    dimensionType1 = index.getDimensionType1();
                    dimensionType2 = index.getDimensionType2();
                    dimensionType3 = index.getDimensionType3();
                    if (index.getDimensionValue1() != null) {
                        DataViewWidgetHelper.fillingDataViewVM(index.getDimensionType1(), dataViewVM, index.getDimensionValue1().toString());
                    }
                    if (index.getDimensionValue2() != null) {
                        DataViewWidgetHelper.fillingDataViewVM(index.getDimensionType2(), dataViewVM, index.getDimensionValue2().toString());
                    }
                    if (index.getDimensionValue3() != null) {
                        DataViewWidgetHelper.fillingDataViewVM(index.getDimensionType3(), dataViewVM, index.getDimensionValue3().toString());
                    }
                    resultVM.add(dataViewVM);
                }
                DimensionType finalDimensionType1 = dimensionType1;
                DimensionType finalDimensionType2 = dimensionType2;
                DimensionType finalDimensionType3 = dimensionType3;
                FxUtil.waitForFxThread(() -> DataViewWidgetHelper.configureColumns((DataViewWidget<BasePaymentDocumentTransactionsViewVM>)widget, finalDimensionType1, finalDimensionType2, finalDimensionType3));
                return resultVM;
            }
        };
        handler.setQuery(new SearchQuery());
        widget.setHandler((DataViewHandler)handler);
        if (collapsed != null) {
            FxUtil.addListener(collapsed, (obj, o, n) -> {
                if (!n.booleanValue() && !widget.isDataLoaded()) {
                    widget.reloadData();
                }
            });
        }
    }

    static void configureColumns(DataViewWidget<BasePaymentDocumentTransactionsViewVM> widget, DimensionType finalDimensionType1, DimensionType finalDimensionType2, DimensionType finalDimensionType3) {
        int id;
        ((TableColumn)widget.getTableView().getColumns().get(0)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(1)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(2)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(3)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(4)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(5)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(6)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(7)).setVisible(false);
        if (finalDimensionType1 != null) {
            id = DataViewWidgetHelper.getNumberColumns(finalDimensionType1);
            ((TableColumn)widget.getTableView().getColumns().get(id)).setVisible(true);
        }
        if (finalDimensionType2 != null) {
            id = DataViewWidgetHelper.getNumberColumns(finalDimensionType2);
            ((TableColumn)widget.getTableView().getColumns().get(id)).setVisible(true);
        }
        if (finalDimensionType3 != null) {
            id = DataViewWidgetHelper.getNumberColumns(finalDimensionType3);
            ((TableColumn)widget.getTableView().getColumns().get(id)).setVisible(true);
        }
        widget.getTableView().setColumnResizePolicy(CustomTableView.getConstrainedResizePolicy());
    }

    private static int getNumberColumns(DimensionType dimensionType) {
        switch (dimensionType) {
            case PAYMENT_TYPE: {
                return 0;
            }
            case CONTRACT_TYPE: {
                return 1;
            }
            case ORGANIZATION: {
                return 2;
            }
            case SALES_POINT: {
                return 3;
            }
            case AGENT: {
                return 4;
            }
            case CASH: {
                return 5;
            }
            case CASH_REGISTER: {
                return 6;
            }
            case CASH_REGISTER_WORKPLACE: {
                return 7;
            }
        }
        throw Xeption.forDeveloper((String)String.format("For dimension type: %s, not found view", dimensionType), (Object[])new Object[0]);
    }

    static void fillingDataViewVM(DimensionType dimensionType, BasePaymentDocumentTransactionsViewVM dataViewVM, String value) {
        switch (dimensionType) {
            case PAYMENT_TYPE: {
                dataViewVM.setPaymentTypeDem1(value);
                break;
            }
            case CONTRACT_TYPE: {
                dataViewVM.setContractTypeDem2(value);
                break;
            }
            case ORGANIZATION: {
                dataViewVM.setOrganizationDem3(value);
                break;
            }
            case SALES_POINT: {
                dataViewVM.setSalesPointDem4(value);
                break;
            }
            case AGENT: {
                dataViewVM.setAgentDem5(value);
                break;
            }
            case CASH: {
                dataViewVM.setCashDem6(value);
                break;
            }
            case CASH_REGISTER: {
                dataViewVM.setCashRegisterDem7(value);
                break;
            }
            case CASH_REGISTER_WORKPLACE: {
                dataViewVM.setCashRegisterWorkplaceDem8(value);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)String.format("For dimension type: %s, not found view", dimensionType), (Object[])new Object[0]);
            }
        }
    }

    public static void configurePaymentDocumentsDataView(DataViewWidget<BasePaymentDocumentDocumentsViewVM> widget, final Supplier<EntityContainer<? extends BasePaymentDocument>> supplier, ObservableValue<Boolean> collapsed) {
        QueryDataViewHandler<BasePaymentDocumentDocumentsViewVM> handler = new QueryDataViewHandler<BasePaymentDocumentDocumentsViewVM>(){

            protected List<BasePaymentDocumentDocumentsViewVM> executeQuery(SearchQuery query) throws Exception {
                ValueHolder containerHolder = new ValueHolder();
                FxUtil.waitForFxThread(() -> 5.lambda$executeQuery$0(containerHolder, (Supplier)supplier));
                if (containerHolder.get() == null) {
                    return Collections.emptyList();
                }
                ArrayList<BasePaymentDocumentDocumentsViewVM> result = new ArrayList<BasePaymentDocumentDocumentsViewVM>();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)((EntityContainer)containerHolder.get()).toReference()), SearchCriterion.contains((String)BasicDocumentIndex.Property.ownersUids.name(), (Object)((EntityContainer)containerHolder.get()).getUid())}));
                if (query.getCriteria().getOrders().isEmpty()) {
                    query.getCriteria().getOrders().put(BasicDocumentIndex.Property.created.name(), SortOrder.DESC);
                }
                List list = entityService.search(ServiceInvocationContext.get(), BasicDocumentIndex.class, query);
                for (BasicDocumentIndex index : list) {
                    BasePaymentDocumentDocumentsViewVM vm = new BasePaymentDocumentDocumentsViewVM();
                    vm.setDate(index.getCreated() != null ? index.getCreated().toString() : null);
                    vm.setTitle(index.getTitle());
                    vm.setContentType(index.getContentType() != null ? index.getContentType().toString() : null);
                    vm.setReference(index.getSource());
                    result.add(vm);
                }
                return result;
            }

            private static /* synthetic */ void lambda$executeQuery$0(ValueHolder containerHolder, Supplier supplier2) throws Exception {
                containerHolder.set(supplier2.get());
            }
        };
        handler.setQuery(new SearchQuery());
        widget.setHandler((DataViewHandler)handler);
        widget.getTableView().setActionHandler((TableActionHandler)new TableActionHandler<BasePaymentDocumentDocumentsViewVM>(){

            public void onAction(TableColumn<BasePaymentDocumentDocumentsViewVM, ?> column, BasePaymentDocumentDocumentsViewVM item) {
                RootEntityEditingService.navigateTo((EntityReference)item.getReference());
            }

            public boolean isActive(TableColumn<BasePaymentDocumentDocumentsViewVM, ?> column, BasePaymentDocumentDocumentsViewVM item) {
                return false;
            }
        });
        widget.setDefaultActionHandler(() -> {
            BasePaymentDocumentDocumentsViewVM selected = (BasePaymentDocumentDocumentsViewVM)widget.getTableView().getSelectionModel().getSelectedItem();
            if (selected != null) {
                RootEntityEditingService.navigateTo((EntityReference)selected.getReference());
            }
        });
        if (collapsed != null) {
            FxUtil.addListener(collapsed, (obj, o, n) -> {
                if (!n.booleanValue() && !widget.isDataLoaded()) {
                    widget.reloadData();
                }
            });
        }
    }

    public static void configureRelatedDocumentsTile(Tile<Node, RelatedDocumentsPanel> tile, Supplier<EntityReference<?>> ownerSupplier, ObservableValue<Boolean> expanded, RelatedDocumentsConfiguration configuration) {
        tile.expandedProperty().addListener((s, o, n) -> {
            ObservableList actions = tile.getActions();
            if (configuration.isActionsVisible() && n.booleanValue()) {
                actions.setAll((Object[])RelatedDocumentsActions.values());
            } else {
                actions.clear();
            }
        });
        DataViewWidgetHelper.configureRelatedDocumentsDataView(tile, ownerSupplier, configuration);
        if (configuration.isSysLogVisible()) {
            DataViewWidgetHelper.configureSysLogDataView((DataViewWidget<SysLogDataItemVM>)((DataViewWidget)((RelatedDocumentsPanel)tile.getFullNode()).getSystemLogCard().getContent()), ownerSupplier, (ObservableValue<Boolean>)tile.expandedProperty());
        } else {
            ((RelatedDocumentsPanel)tile.getFullNode()).getCards().remove((Object)((RelatedDocumentsPanel)tile.getFullNode()).getSystemLogCard());
            ((RelatedDocumentsPanel)tile.getFullNode()).getDocumentsCard().setAdaptiveHeight(true);
        }
    }

    private static void configureRelatedDocumentsDataView(Tile<Node, RelatedDocumentsPanel> tile, Supplier<EntityReference<?>> ownerSupplier, RelatedDocumentsConfiguration configuration) {
        Card documentsCard = ((RelatedDocumentsPanel)tile.getFullNode()).getDocumentsCard();
        DataViewWidget widget = (DataViewWidget)documentsCard.getContent();
        if (!configuration.isActionsVisible()) {
            documentsCard.setHelp(null);
        }
        RelatedDocumentsFilterableDataViewHandler handler = new RelatedDocumentsFilterableDataViewHandler(ownerSupplier, configuration);
        widget.setHandler((DataViewHandler)handler);
        widget.getTableView().setActionHandler((TableActionHandler)new TableActionHandler<RelatedDocumentsDataItemVM>(){

            public void onAction(TableColumn<RelatedDocumentsDataItemVM, ?> column, RelatedDocumentsDataItemVM item) {
                RootEntityEditingService.navigateTo((EntityReference)item.getReference());
            }

            public boolean isActive(TableColumn<RelatedDocumentsDataItemVM, ?> column, RelatedDocumentsDataItemVM item) {
                return false;
            }
        });
        widget.setDefaultActionHandler(() -> {
            RelatedDocumentsDataItemVM selected = (RelatedDocumentsDataItemVM)widget.getTableView().getSelectionModel().getSelectedItem();
            if (selected != null) {
                RootEntityEditingService.navigateTo((EntityReference)selected.getReference());
            }
        });
        if (configuration.isActionsVisible()) {
            widget.getTableView().setOnDragOver(evt -> {
                evt.consume();
                if (ViewController.forView((Node)tile.getFullNode()).isReadonly()) {
                    return;
                }
                if (evt.getDragboard().hasFiles()) {
                    evt.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                }
            });
            widget.getTableView().setOnDragDropped(evt -> {
                List files;
                evt.consume();
                if (ViewController.forView((Node)tile.getFullNode()).isReadonly()) {
                    return;
                }
                if (evt.getDragboard().hasFiles() && !(files = evt.getDragboard().getFiles()).isEmpty()) {
                    DataViewWidgetHelper.showAddFileDialog((Control)widget.getTableView(), tile, (File)files.get(0));
                }
            });
            UiUtil.configureDnDHighlighting((Node)widget.getTableView(), evt -> {
                if (ViewController.forView((Node)tile.getFullNode()).isReadonly()) {
                    return false;
                }
                return evt.getDragboard().hasFiles();
            });
        }
        FxUtil.addListener((ObservableValue)tile.expandedProperty(), (obj, o, n) -> {
            if (n.booleanValue() && !widget.isDataLoaded()) {
                widget.reloadData();
            }
        });
    }

    public static void configureSysLogDataView(final DataViewWidget<SysLogDataItemVM> widget, final Supplier<EntityReference<?>> ownerSupplier, ObservableValue<Boolean> expanded) {
        QueryDataViewHandler<SysLogDataItemVM> handler = new QueryDataViewHandler<SysLogDataItemVM>(){

            protected List<SysLogDataItemVM> executeQuery(SearchQuery query) throws Exception {
                ValueHolder referenceHolder = new ValueHolder();
                FxUtil.waitForFxThread(() -> 8.lambda$executeQuery$0(referenceHolder, (Supplier)ownerSupplier));
                if (referenceHolder.get() == null) {
                    return Collections.emptyList();
                }
                ArrayList<SysLogDataItemVM> result = new ArrayList<SysLogDataItemVM>();
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceType.name(), (Object)((EntityReference)referenceHolder.get()).getType().getName()));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceUid.name(), (Object)((EntityReference)referenceHolder.get()).getUid()));
                if (query.getCriteria().getOrders().isEmpty()) {
                    query.getCriteria().getOrders().put(SysLogItem.Property.eventDate.name(), SortOrder.DESC);
                }
                AssetService assetService = (AssetService)RpcServiceManager.get().getService(AssetService.class);
                assetService.search(sic, SysLogItem.class, query).getData().forEach(sysLog -> {
                    SysLogDataItemVM sysLogVM = new SysLogDataItemVM();
                    sysLogVM.setCreationDate((String)StandardRenderers.DATE_TIME.apply((Object)sysLog.getDate()));
                    if (sysLog.getMessage() != null) {
                        Message m = sysLog.getMessage();
                        sysLogVM.setImportance(DataViewWidgetHelper.stringValueOf(m.getType()));
                        sysLogVM.setMessage(DataViewWidgetHelper.stringValueOf(m.getMessage()));
                    }
                    sysLogVM.setType(sysLog.getType().toString());
                    sysLogVM.setUser(sysLog.getUser());
                    sysLogVM.setMark(sysLog.getTag());
                    sysLogVM.setSysLogItem(sysLog);
                    sysLogVM.setDetailsLink(Messages.Show);
                    result.add(sysLogVM);
                });
                return result;
            }

            private static /* synthetic */ void lambda$executeQuery$0(ValueHolder referenceHolder, Supplier ownerSupplier2) throws Exception {
                referenceHolder.set(ownerSupplier2.get());
            }
        };
        handler.setQuery(new SearchQuery());
        widget.setHandler((DataViewHandler)handler);
        widget.getTableView().setActionHandler((TableActionHandler)new TableActionHandler<SysLogDataItemVM>(){

            public void onAction(TableColumn<SysLogDataItemVM, ?> column, SysLogDataItemVM item) {
                Dialog.message((Node)widget, (String)Messages.Detailing_the_message, (String)DataViewWidgetHelper.buildDetails(item.getSysLogItem()));
            }

            public boolean isActive(TableColumn<SysLogDataItemVM, ?> column, SysLogDataItemVM item) {
                return "detailsLink".equals(column.getId());
            }
        });
        widget.setDefaultActionHandler(() -> {
            SysLogDataItemVM selected = (SysLogDataItemVM)widget.getTableView().getSelectionModel().getSelectedItem();
            if (selected != null) {
                Dialog.message((Node)widget, (String)Messages.Detailing_the_message, (String)DataViewWidgetHelper.buildDetails(selected.getSysLogItem()));
            }
        });
        if (expanded != null) {
            FxUtil.addListener(expanded, (obj, o, n) -> {
                if (n.booleanValue() && !widget.isDataLoaded()) {
                    widget.reloadData();
                }
            });
        }
    }

    static String stringValueOf(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    static String buildDetails(SysLogItem item) {
        if (item == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String nl = System.getProperty("line.separator");
        buf.append(Messages.Date_of_create).append((String)StandardRenderers.DATE_TIME.apply((Object)item.getDate())).append(nl);
        buf.append(Messages.User2).append(item.getUser()).append(nl);
        buf.append(Messages.Label2).append(item.getTag()).append(nl);
        if (item.getMessage() != null) {
            buf.append(Messages.Message2).append(item.getMessage().getType()).append("] :").append(LocaleManager.get().getL10nResourceManager().getMessage(item.getMessage().getMessage())).append(nl);
            if (item.getMessage().getDetails() != null) {
                buf.append(Messages.Detailing2).append(nl).append(item.getMessage().getDetails()).append(nl);
            }
        }
        if (item.getType() != null) {
            switch (item.getType()) {
                case MODIFICATION: {
                    buf.append(Messages.New_value2).append(item.getValueNew()).append(nl);
                    buf.append(Messages.Old_value2).append(item.getValueOld()).append(nl);
                    break;
                }
                case METRIC: {
                    buf.append(Messages.Metric).append(item.getMetricValue()).append(nl);
                    break;
                }
            }
        }
        return buf.toString();
    }

    static void showAddFileDialog(Control source, Tile<Node, RelatedDocumentsPanel> tile, File selectedFile) {
        Pair selectedFileData;
        final AddRelatedDocumentPanel body = new AddRelatedDocumentPanel(false);
        body.getTitleNode().getViewState().setReadonly(true);
        body.getDescriptionNode().getViewState().setReadonly(true);
        body.getFileNode().getFiles().addListener(change -> {
            ContentType ct;
            ObservableList files = body.getFileNode().getFiles();
            if (files.isEmpty()) {
                ct = null;
            } else {
                String ext;
                switch (ext = FilenameUtils.getExtension((String)((File)files.get(0)).getName()).toLowerCase()) {
                    case "xml": 
                    case "xsd": 
                    case "xsl": 
                    case "xslt": {
                        ct = ContentType.XML;
                        break;
                    }
                    case "txt": {
                        ct = ContentType.TEXT;
                        break;
                    }
                    case "pdf": {
                        ct = ContentType.PDF;
                        break;
                    }
                    case "xls": {
                        ct = ContentType.EXCEL;
                        break;
                    }
                    case "htm": 
                    case "html": {
                        ct = ContentType.HTML;
                        break;
                    }
                    case "jasper": {
                        ct = ContentType.JASPERPRINT;
                        break;
                    }
                    case "groovy": {
                        ct = ContentType.GROOVY;
                        break;
                    }
                    case "dbf": {
                        ct = ContentType.DBF;
                        break;
                    }
                    case "xlsx": {
                        ct = ContentType.EXCEL_2007;
                        break;
                    }
                    case "png": {
                        ct = ContentType.PNG;
                        break;
                    }
                    case "jpeg": 
                    case "jpg": {
                        ct = ContentType.JPEG;
                        break;
                    }
                    case "gif": {
                        ct = ContentType.GIF;
                        break;
                    }
                    case "jrxml": {
                        ct = ContentType.JASPERDESIGN;
                        break;
                    }
                    case "json": {
                        ct = ContentType.JSON;
                        break;
                    }
                    case "doc": {
                        ct = ContentType.WORD;
                        break;
                    }
                    case "docx": {
                        ct = ContentType.WORD_2007;
                        break;
                    }
                    case "css": {
                        ct = ContentType.CSS;
                        break;
                    }
                    case "cldr": {
                        ct = ContentType.CALENDAR;
                        break;
                    }
                    default: {
                        ct = TextUtil.isBlank((String)ext) ? null : ContentType.BINARY;
                    }
                }
            }
            body.getTypeNode().setValue(ct);
            body.getTitleNode().setValue(files.isEmpty() ? "" : ((File)files.get(0)).getName());
            body.getTitleNode().getViewState().setReadonly(false);
            body.getDescriptionNode().setValue(files.isEmpty() ? "" : ((File)files.get(0)).getName());
            body.getDescriptionNode().getViewState().setReadonly(false);
        });
        boolean isBookingFile = tile.getSpace() instanceof BookingFileSpace;
        if (isBookingFile) {
            body.getNavigationKeyNode().setItemsSupplier(() -> {
                ArrayList<RelatedDocumentNavigationKey> result = new ArrayList<RelatedDocumentNavigationKey>();
                BookingFileSpace bookingFileSpace = (BookingFileSpace)tile.getSpace();
                CompactNavigatorWidget productsWidget = (CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent();
                ListItemStringConverter productsConverter = productsWidget.getConverter();
                for (int i = 0; i < productsWidget.getViews().size(); ++i) {
                    RelatedDocumentNavigationKey key = DataViewWidgetHelper.buildRelatedDocumentNavigationKey((Node)productsWidget.getViews().get(i), i, productsConverter);
                    if (key == null) {
                        return null;
                    }
                    result.add(key);
                }
                PlainGroupsWidget reservationsWidget = (PlainGroupsWidget)((BookingFileReservationsFullPanel)bookingFileSpace.getReservationsTile().getFullNode()).getContent();
                ListItemStringConverter reservationsConverter = reservationsWidget.getConverter();
                for (int i = 0; i < reservationsWidget.getViews().size(); ++i) {
                    RelatedDocumentNavigationKey key = DataViewWidgetHelper.buildRelatedDocumentNavigationKey((Node)reservationsWidget.getViews().get(i), i, reservationsConverter);
                    if (key == null) {
                        return null;
                    }
                    result.add(key);
                }
                return result;
            });
            body.getNavigationKeyNode().setConverter((StringConverter)new StringConverter<RelatedDocumentNavigationKey>(){

                public String toString(RelatedDocumentNavigationKey object) {
                    return object.getCaption();
                }

                public RelatedDocumentNavigationKey fromString(String string) {
                    return ((List)body.getNavigationKeyNode().getItemsSupplier().get()).stream().filter(key -> ObjectUtils.equals((Object)string, (Object)key.getCaption())).findFirst().orElse(null);
                }
            });
        } else {
            body.getNavigationKeyCell().setHidden(true);
        }
        if (selectedFile != null) {
            body.getFileNode().getFiles().add((Object)selectedFile);
            body.getFileNode().getViewState().setNotEditable(true);
            try {
                selectedFileData = new Pair((Object)selectedFile.getName(), (Object)Files.readAllBytes(selectedFile.toPath()));
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
                return;
            }
        } else {
            selectedFileData = null;
        }
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Adding_document).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Add_document, () -> {
            Pair fileData;
            if (selectedFileData != null) {
                fileData = selectedFileData;
            } else {
                ObservableList files = body.getFileNode().getFiles();
                if (files.isEmpty()) {
                    return;
                }
                File file = (File)files.get(0);
                try {
                    fileData = new Pair((Object)file.getName(), (Object)Files.readAllBytes(file.toPath()));
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                    return;
                }
            }
            if (!isBookingFile || body.getNavigationKeyNode().getValue() != null && TextUtil.nonBlank((String)((RelatedDocumentNavigationKey)body.getNavigationKeyNode().getValue()).getUid())) {
                dialog.close();
                String navigationKey = body.getNavigationKeyNode().getValue() != null ? ((RelatedDocumentNavigationKey)body.getNavigationKeyNode().getValue()).getUid() : null;
                DataViewWidgetHelper.addFile((Pair<String, byte[]>)fileData, navigationKey, tile, body);
            } else {
                Dialog dialog2 = new Dialog();
                dialog2.setTitle(Messages.Adding_document).setMessage(Messages.AreYouSureYouWantAddDocumentWithoutProduct).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog2).close()).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Add_document, () -> {
                    dialog.close();
                    DataViewWidgetHelper.addFile((Pair<String, byte[]>)fileData, null, tile, body);
                }).show((Node)body);
            }
        }).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).setBody((Node)body).show((Node)source);
    }

    private static <N extends Node> RelatedDocumentNavigationKey buildRelatedDocumentNavigationKey(N view, int i, ListItemStringConverter<N> converter) {
        String uid = (String)view.getProperties().get((Object)"model-uid");
        if (TextUtil.isBlank((String)uid)) {
            return null;
        }
        String caption = converter.toString(view, i);
        if (caption != null) {
            caption = caption.trim();
        }
        RelatedDocumentNavigationKey key = new RelatedDocumentNavigationKey();
        key.setUid(uid);
        key.setCaption(caption);
        return key;
    }

    private static void addFile(Pair<String, byte[]> fileData, String navigationKey, Tile<Node, RelatedDocumentsPanel> tile, AddRelatedDocumentPanel body) {
        EntityContainer doc = new EntityContainer(Document.class);
        ((Document)doc.getEntity()).setCreated(new Date());
        ((Document)doc.getEntity()).setName((String)fileData.getKey());
        ((Document)doc.getEntity()).setTitle(body.getTitleNode().getValue());
        ((Document)doc.getEntity()).setContentType((ContentType)body.getTypeNode().getValue());
        ((Document)doc.getEntity()).setType((DocumentType)body.getDocumentTypeNode().getValue());
        ((Document)doc.getEntity()).setExternal(true);
        ((Document)doc.getEntity()).setDoNotShowOnSite(!body.getShowOnSiteNode().getValue());
        ((Document)doc.getEntity()).setDescription(body.getDescriptionNode().getValue());
        RootEntityPane rootPane = RootEntityPane.lookup((Node)tile.getFullNode());
        EntityReference owner = rootPane.getData().getContainer().toReference();
        ((Document)doc.getEntity()).setOwner(owner);
        if (TextUtil.nonBlank((String)navigationKey)) {
            ((Document)doc.getEntity()).setNavigationKey(navigationKey);
        } else {
            ((Document)doc.getEntity()).setNavigationKey(owner.getUid());
        }
        doc.getVersionInfo().setDataSource("fx-client");
        doc.getVersionInfo().setVersionNotes("add file action");
        Notifications.get().submitTask(() -> {
            ((Document)doc.getEntity()).setContent((byte[])fileData.getValue());
            ((Document)doc.getEntity()).setCheckSum(MiscUtil.getCheckSum((byte[])((Document)doc.getEntity()).getContent()));
            ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), doc, null, true);
            FxUtil.submitToFxThread(() -> ((DataViewWidget)((RelatedDocumentsPanel)tile.getFullNode()).getDocumentsCard().getContent()).reloadData());
        }, Messages.Saving);
    }

    private DataViewWidgetHelper() {
    }
}

