/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.metadata.MetadataBasedEditor;
import com.gridnine.xtrip.client.fx.core.entity.raw.RawEntityEditor;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.DiffViewActivityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DiffViewParameters;
import com.gridnine.xtrip.client.fx.standard.helpers.RootEntityVersionActivityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.RootEntityVersionParameters;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.Region;

public final class EntityEditorHelper {
    public static void showVersionsDialog(EntityReference<?> ref, Integer versionNumber, Node parent, ObservableMutex mutex) {
        Notifications.get().submitTask(() -> EntityEditorHelper.loadVersions(ref, versionNumber, parent), mutex);
    }

    public static <E extends BaseEntity> RootEntityHandler<E, ?> createHandler(final Class<E> entityClass) {
        return new RootEntityHandler<E, Void>(){

            public Class<E> getEntityClass() {
                return entityClass;
            }

            public Class<Void> getSupplementClass() {
                return Void.class;
            }

            public Class<? extends EntityIndex<?>> getStandardIndexClass() {
                EntityType ett = MetaRegistryHelper.getEntityType((String)entityClass.getName());
                Collection indexes = MetaRegistryHelper.getIndexes((EntityType)ett);
                if (indexes.isEmpty()) {
                    return null;
                }
                try {
                    return XSHelper.getClass((String)((IndexType)indexes.iterator().next()).getId());
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                    return null;
                }
            }

            public ViewController<?, DataTransferPackage<E, Void>> createEditorController(boolean readonly) {
                try {
                    return EntityEditorHelper.createGenericController(entityClass);
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                    return null;
                }
            }

            public boolean isAvaibleInConfiguration() {
                EntityType ent = (EntityType)MetaRegistry.get().getEntities().get(this.getEntityClass().getName());
                return ent != null && AppConfigHelper.isInScope(ent);
            }
        };
    }

    public static <E extends BaseEntity> ViewController<?, DataTransferPackage<E, ?>> createGenericController(Class<E> entityClass) throws Exception {
        ViewController result;
        EntityType ett = MetaRegistryHelper.getEntityType((String)entityClass.getName());
        if ("true".equals(ett.getParameters().get("useMetadataBasedSystemSettingsClientHandlerFX"))) {
            boolean hideInstallationId = "true".equals(ett.getParameters().get("hideInstallationId"));
            boolean hideType = "true".equals(ett.getParameters().get("hideType"));
            EntityType baseEtt = MetaRegistryHelper.getEntityType((String)BaseSystemSettings.class.getName());
            result = MetadataBasedEditor.createController((EntityType)ett, (ettLocal, field) -> {
                if (!AppConfigHelper.isInScope(ett)) {
                    return false;
                }
                if (!MetadataBasedEditor.STANDARD_FILTER.test(ettLocal, field)) {
                    return false;
                }
                if (!hideInstallationId && !hideType) {
                    return true;
                }
                if (!MetaRegistryHelper.isAssignableFrom((EntityType)baseEtt, (EntityType)ettLocal)) {
                    return true;
                }
                if (hideInstallationId && "installationId".equals(field)) {
                    return false;
                }
                return !hideType || !"type".equals(field);
            });
        } else {
            result = RawEntityEditor.createContainerController(entityClass);
            Node view = result.getView();
            ((Region)view).setPrefHeight(500.0);
        }
        return new ViewController<Node, DataTransferPackage<E, Void>>(){
            private DataTransferPackage<E, Void> localData;

            public Node getView() {
                return result.getView();
            }

            public DataTransferPackage<E, Void> getData() {
                return this.localData;
            }

            public void readData(DataTransferPackage<E, Void> model) {
                this.localData = model;
                result.readData((Object)model.getContainer());
            }

            public void writeData(DataTransferPackage<E, Void> model) {
                this.localData = model;
                result.writeData((Object)model.getContainer());
            }

            public boolean isReadonly() {
                return result.isReadonly();
            }

            public void setReadonly(boolean readonly) {
                result.setReadonly(readonly);
            }

            public void setNotEditable(boolean notEditable) {
                result.setNotEditable(notEditable);
            }

            public void setAclNotEditable(boolean aclNotEditable) {
                result.setAclNotEditable(aclNotEditable);
            }

            public boolean isDataChanged() {
                return result.isDataChanged();
            }

            public void validateData(List<Message> messages) {
                result.validateData(messages);
            }
        };
    }

    private static void loadVersions(EntityReference<?> ref, Integer versionNumber, Node view) throws Exception {
        List versionInfos = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).getVersionInfos(ServiceInvocationContext.get(), ref);
        if (versionInfos.isEmpty()) {
            Notifications.get().showFlashNotification(Messages.VersionsHelper_Version_information_isnt_available + ref, null);
            return;
        }
        Collections.sort(versionInfos, (info1, info2) -> Integer.compare(info2.getVersionNumber(), info1.getVersionNumber()));
        VersionInfo lastVersionInfo = (VersionInfo)versionInfos.get(0);
        final VersionInfo currentVersionInfo = versionNumber == null ? (VersionInfo)versionInfos.get(0) : (VersionInfo)versionInfos.stream().filter(info -> versionNumber.intValue() == info.getVersionNumber()).findFirst().orElse(null);
        final CustomTableView tableView = new CustomTableView();
        tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        TableColumnSettings colSettings = new TableColumnSettings();
        colSettings.setDisplayName("\u2116");
        colSettings.setRenderer((Renderer)StandardRenderers.NUMBER_INTEGRAL);
        colSettings.setId("number");
        colSettings.setSortable(false);
        colSettings.setPrefWidth(Double.valueOf(50.0));
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getVersionNumber() + 1));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.VersionsHelper_Created);
        colSettings.setRenderer((Renderer)StandardRenderers.GENERIC);
        colSettings.setId("createdBy");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getCreatedBy()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.Date_of_creation);
        colSettings.setRenderer((Renderer)StandardRenderers.DATE_TIME);
        colSettings.setId("created");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getCreated()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.VersionsHelper_Changed);
        colSettings.setRenderer((Renderer)StandardRenderers.GENERIC);
        colSettings.setId("modifiedBy");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getModifiedBy()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.VersionsHelper_Date_of_change);
        colSettings.setRenderer((Renderer)StandardRenderers.DATE_TIME);
        colSettings.setId("modified");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getModified()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.VersionsHelper_Source);
        colSettings.setRenderer((Renderer)StandardRenderers.GENERIC);
        colSettings.setId("dataSource");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getDataSource()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.Comment);
        colSettings.setRenderer((Renderer)StandardRenderers.GENERIC);
        colSettings.setId("notes");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getVersionNotes()));
        tableView.setInterlacingHighlight(true);
        tableView.getItems().addAll((Collection)versionInfos);
        FxUtil.submitToFxThread(() -> {
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.VersionsHelper_List_of_versions).setBody((Node)tableView).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Open, () -> {
                for (VersionInfo info : tableView.getSelectionModel().getSelectedItems()) {
                    if (lastVersionInfo.equals((Object)info)) {
                        RootEntityEditingService.navigateTo((EntityReference)ref);
                        continue;
                    }
                    try {
                        EntityEditorHelper.open(ref, info.getVersionNumber());
                    }
                    catch (NullPointerException exception) {
                        ArrayList<StackTraceElement> incidentStackTraces = new ArrayList<StackTraceElement>();
                        incidentStackTraces.add(IncidentsHelper.getContextStackTraceElement((String)"EntityType", (String)ref.getType().getName()));
                        incidentStackTraces.add(IncidentsHelper.getContextStackTraceElement((String)"EntityCtrCaption", (String)ref.getCaption()));
                        incidentStackTraces.add(IncidentsHelper.getContextStackTraceElement((String)"EntityUid", (String)ref.getUid()));
                        incidentStackTraces.forEach(incident -> {
                            NullPointerException cfr_ignored_0 = (NullPointerException)IncidentsHelper.addStackTraceElement((Throwable)exception, (StackTraceElement[])new StackTraceElement[]{incident});
                        });
                        throw exception;
                    }
                }
            }, (BooleanExpression)new BooleanBinding(){
                {
                    this.bind(new Observable[]{tableView.getSelectionModel().getSelectedItems()});
                }

                protected boolean computeValue() {
                    VersionInfo info = (VersionInfo)tableView.getSelectionModel().getSelectedItem();
                    return info != null && currentVersionInfo != null && currentVersionInfo.getVersionNumber() != info.getVersionNumber();
                }
            });
            if (Prefetched.getData().getCurrentAgentData().isPrivilegedGroup()) {
                dialog.addButton(DialogButtonStyle.AUXILARY, "\u0421\u0440\u0430\u0432\u043d\u0438\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u0438", () -> {
                    ObservableList selectedItems = tableView.getSelectionModel().getSelectedItems();
                    VersionInfo vi1 = (VersionInfo)selectedItems.get(0);
                    VersionInfo vi2 = (VersionInfo)selectedItems.get(1);
                    String token = ref.getType().getName() + '|' + ref.getUid() + "|" + vi1.getVersionNumber() + "|" + vi2.getVersionNumber();
                    NavigationParameters navParams = new NavigationParameters();
                    navParams.setTitle(String.format("%s: \u0432\u0435\u0440\u0441\u0438\u0438 %s \u0438 %s", ref, vi1.getVersionNumber() + 1, vi2.getVersionNumber() + 1));
                    DiffViewParameters params = new DiffViewParameters();
                    params.ref = ref;
                    params.version1 = vi1.getVersionNumber();
                    params.version2 = vi2.getVersionNumber();
                    navParams.setParameters((Object)params);
                    ActivityManager.get().navigate(token, (ActivityHandler)DiffViewActivityHandler.INSTANCE, navParams);
                }, (BooleanExpression)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{tableView.getSelectionModel().getSelectedItems()});
                    }

                    protected boolean computeValue() {
                        return tableView.getSelectionModel().getSelectedItems().size() == 2;
                    }
                });
            }
            dialog.show(view);
        });
    }

    public static void open(EntityReference<?> ref, Integer versionNumber) {
        RootEntityVersionParameters data = new RootEntityVersionParameters();
        RootEntityHandler handler = RootEntityHandler.forEntityClass((Class)ref.getType());
        data.handlerId = handler == null ? ref.getType().getName() : handler.getId();
        data.containerUid = ref.getUid();
        data.versionNumber = versionNumber;
        String token = data.handlerId + '|' + data.containerUid;
        if (data.versionNumber != null) {
            token = token + 124 + String.valueOf(data.versionNumber);
        }
        NavigationParameters parameters = new NavigationParameters();
        parameters.setParameters((Object)data);
        ActivityManager.get().navigate(token, (ActivityHandler)RootEntityVersionActivityHandler.INSTANCE, parameters);
    }

    private EntityEditorHelper() {
    }
}

