/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class IndexHelper {
    public static List<IndexType> getAvalableIndexTypes() {
        return MetaRegistry.get().getIndexes().values().stream().filter(IndexHelper::isAvailable).collect(Collectors.toCollection(ArrayList::new));
    }

    public static boolean isAvailable(IndexType indexType) {
        if (indexType.isHidden()) {
            return false;
        }
        if (indexType.getId().equals("com.gridnine.xtrip.common.gds.model.OrganizationAirlineSettingsIndex")) {
            return true;
        }
        try {
            Class entityClass = XSHelper.getClass((String)indexType.getEntityId());
            if (BaseExchangeDocument.class.isAssignableFrom(entityClass)) {
                return false;
            }
            EntityIndexHandler indexHandler = EntityIndexHandler.forIndexClass((String)indexType.getId());
            if (indexHandler == null || !indexHandler.isAvaibleInConfiguration()) {
                return false;
            }
            if (BaseSystemSettings.class.isAssignableFrom(entityClass)) {
                return false;
            }
            if (entityClass.getName().contains(".reports.")) {
                return false;
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return false;
        }
        return true;
    }

    private IndexHelper() {
    }
}

