/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers.fiscal;

import com.gridnine.kkt.common.model.api.CalculationWay;
import com.gridnine.kkt.common.model.api.CorporateClient;
import com.gridnine.kkt.common.model.api.ReceiptType;
import com.gridnine.kkt.common.model.api.Supplier;
import com.gridnine.kkt.common.model.api.VatRate;
import com.gridnine.xtrip.common.model.fiscal.PaymentMethod;
import com.gridnine.xtrip.common.model.fiscal.ReceiptClient;
import com.gridnine.xtrip.common.model.fiscal.ReceiptVatType;

public class FiscalReceiptConverter {
    static VatRate convertVatType(ReceiptVatType vatType) {
        if (vatType == null) {
            return VatRate.WITHOUT_VAT;
        }
        switch (vatType) {
            case VAT_0: {
                return VatRate.VAT_0;
            }
            case VAT_5: 
            case VAT_5_105: {
                return VatRate.VAT_5;
            }
            case VAT_7: 
            case VAT_7_107: {
                return VatRate.VAT_7;
            }
            case VAT_10: 
            case VAT_10_110: {
                return VatRate.VAT_10;
            }
            case VAT_18: 
            case VAT_18_118: 
            case VAT_20: {
                return VatRate.VAT_20;
            }
        }
        return VatRate.WITHOUT_VAT;
    }

    public static ReceiptType convertReceiptType(com.gridnine.xtrip.common.model.fiscal.ReceiptType receiptType) {
        switch (receiptType) {
            case SELL: {
                return ReceiptType.SELL;
            }
            case SELL_CORRECTION: {
                return ReceiptType.CORRECTION_SELL;
            }
            case SELL_REFUND: {
                return ReceiptType.VOID;
            }
        }
        return null;
    }

    static CalculationWay convertPaymentMethod(PaymentMethod paymentMethod) {
        switch (paymentMethod) {
            case FULL_PREPAYMENT: {
                return CalculationWay.PREPAYMENT_100;
            }
            case CREDIT: {
                return CalculationWay.CREDIT;
            }
            case PREPAYMENT: {
                return CalculationWay.PREPAYMENT;
            }
            case ADVANCE: {
                return CalculationWay.ADVANCE;
            }
            case FULL_PAYMENT: {
                return CalculationWay.FULL_CALCULATION;
            }
            case PARTIAL_PAYMENT: {
                return CalculationWay.PARTIAL_CALCULATION;
            }
            case CREDIT_PAYMENT: {
                return CalculationWay.CREDIT_PAYMENT;
            }
        }
        return null;
    }

    static Supplier convertSupplier(com.gridnine.xtrip.common.model.fiscal.Supplier sup) {
        Supplier result = new Supplier();
        result.setINN(sup.getINN());
        result.setName(sup.getName());
        result.setPhoneNum(sup.getPhoneNum());
        return result;
    }

    static CorporateClient convertReceiptClient(ReceiptClient client) {
        if (client != null) {
            CorporateClient result = new CorporateClient();
            result.setName(client.getName());
            result.setRegistrationId(client.getINN());
            return result;
        }
        return null;
    }
}

