/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers.fiscal;

import com.gridnine.kkt.client.FiscalRestClient;
import com.gridnine.kkt.client.RestResponse;
import com.gridnine.kkt.client.RestResponseType;
import com.gridnine.kkt.common.model.api.MidofficeCashier;
import com.gridnine.kkt.common.model.api.PaymentLine;
import com.gridnine.kkt.common.model.api.PrintReceiptResponse;
import com.gridnine.kkt.common.model.api.ReceiptLine;
import com.gridnine.kkt.common.model.api.ReceiptType;
import com.gridnine.kkt.common.model.api.SessionOpenResponse;
import com.gridnine.xtrip.client.fx.standard.helpers.fiscal.FiscalReceiptConverter;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.fiscal.FiscalReceiptCalculatedDataHolder;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineSellType;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiscalReceiptHelper {
    public static final transient Logger log = LoggerFactory.getLogger(FiscalReceiptHelper.class);

    public static void registerFiscalReceipt(Receipt momReceipt) throws Exception {
        boolean disableCashCheckOption;
        com.gridnine.kkt.common.model.api.Receipt receipt = new com.gridnine.kkt.common.model.api.Receipt();
        receipt.setCashierName(ServiceInvocationContext.get().getUser());
        receipt.setMidofficeCashier(FiscalReceiptHelper.getMidofficeCashier());
        ReceiptData data = momReceipt.getReceiptData();
        receipt.setReceiptType(FiscalReceiptConverter.convertReceiptType(data.getType()));
        receipt.setClient(FiscalReceiptConverter.convertReceiptClient(data.getReceiptClient()));
        receipt.setClientAddress(data.getClentEmail());
        FiscalReceiptCalculatedDataHolder receiptDataHolder = new FiscalReceiptCalculatedDataHolder(data);
        receipt.getReceiptLines().addAll(receiptDataHolder.getReceiptLines().stream().map(receiptLine -> {
            ReceiptLine fiscalLine = new ReceiptLine();
            fiscalLine.setPrintName(receiptLine.getPrintName());
            fiscalLine.setTotal(receiptLine.getTotal());
            fiscalLine.setQuantity(receiptLine.getQuantity());
            fiscalLine.setPrice(receiptLine.getPrice());
            fiscalLine.setVatRate(FiscalReceiptConverter.convertVatType(receiptLine.getVatType()));
            fiscalLine.setPrintNumber("");
            fiscalLine.setPrintDetails("");
            fiscalLine.setCalculationWay(FiscalReceiptConverter.convertPaymentMethod(receiptLine.getPaymentMethod()));
            if (receiptLine.getSupplier() != null) {
                fiscalLine.setSupplier(FiscalReceiptConverter.convertSupplier(receiptLine.getSupplier()));
            }
            fiscalLine.setAgentSale(Boolean.valueOf(receiptLine.getSellType() == ReceiptLineSellType.AGENT));
            return fiscalLine;
        }).collect(Collectors.toList()));
        receipt.getPaymentLines().addAll(receiptDataHolder.getPaymentsMap().entrySet().stream().map(paymentEntry -> {
            PaymentLine pl = new PaymentLine();
            pl.setPaymentType(com.gridnine.kkt.common.model.api.PaymentType.valueOf((String)((PaymentType)paymentEntry.getKey()).name()));
            pl.setSum((BigDecimal)paymentEntry.getValue());
            return pl;
        }).collect(Collectors.toList()));
        boolean bl = disableCashCheckOption = receipt.getReceiptType() == ReceiptType.VOID && receipt.getPaymentLines().stream().noneMatch(paymentLine -> paymentLine.getPaymentType() == com.gridnine.kkt.common.model.api.PaymentType.CASH);
        if (disableCashCheckOption) {
            receipt.getOptions().add("DISABLE_CASH_CHECK");
        }
        FiscalReceiptHelper.checkSession();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.printReceipt(receipt);
        if (result.getResponseType() == RestResponseType.OK) {
            if (log.isDebugEnabled()) {
                log.debug("Receipt printed: " + receipt.toString());
            }
            if (result.getEntity() != null) {
                data.setDocNumber(((PrintReceiptResponse)result.getEntity()).getDocNumber());
                data.setFiscalSign(((PrintReceiptResponse)result.getEntity()).getFiscalSign());
                Long date = ((PrintReceiptResponse)result.getEntity()).getDate();
                if (date != null) {
                    data.setDate(new Date(date));
                }
            }
        } else {
            String message = result.getErrorMessage() + " " + result.getErrorDescription();
            log.error("Unable to print receipt: " + message);
            throw new Exception("Unable to print receipt: " + message);
        }
    }

    public static void checkDevice() throws Exception {
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.isDeviceReady();
        if (result == null) {
            log.error("Unable to get device status: ");
            throw new Exception("Device not responding");
        }
        if (result.getResponseType() != RestResponseType.OK) {
            String message = result.getErrorMessage() + " " + result.getErrorDescription();
            log.error("Unable to get device status: " + message);
            throw new Exception(message);
        }
    }

    public static boolean isSessionOpen() throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.isSessionOpen();
        if (result.getEntity() == null) {
            throw FiscalReceiptHelper.getException(result, "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u043e\u0432 \u0438 \u043a\u0430\u0441\u0441\u043e\u0432\u044b\u043c \u0430\u043f\u043f\u0430\u0440\u0430\u0442\u043e\u043c");
        }
        if (((SessionOpenResponse)result.getEntity()).getCashierName() == null) {
            throw FiscalReceiptHelper.getException(result);
        }
        return result.getResponseType() == RestResponseType.OK && ((SessionOpenResponse)result.getEntity()).getValue();
    }

    public static void openSession() throws Exception {
        FiscalReceiptHelper.checkDevice();
        String cashierLogin = ServiceInvocationContext.get().getUser();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.openSession(cashierLogin, FiscalReceiptHelper.getMidofficeCashier());
        if (result.getResponseType() != RestResponseType.OK) {
            String message = result.getErrorMessage() + " " + result.getErrorDescription();
            log.error("Unable to open session: " + message);
            throw new Exception("Unable to open session: " + message);
        }
        log.info("Session has been opened");
    }

    public static boolean isCloseSessionRequirePassword() throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.isCloseSessionRequirePassword();
        return (Boolean)result.getEntity();
    }

    public static boolean checkCloseSessionPassword(String password) throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.checkCloseSessionPassword(password);
        return (Boolean)result.getEntity();
    }

    public static void closeSession() throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.closeSession();
        if (result.getResponseType() != RestResponseType.OK) {
            String message = result.getErrorMessage() + " " + result.getErrorDescription();
            log.error("Unable to close session: " + message);
            throw new Exception("Unable to close session: " + message);
        }
        log.info("Session has been closed");
    }

    public static boolean isSessionExpired() throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.isSessionExpired();
        if (result.getResponseType() == RestResponseType.OK) {
            return (Boolean)result.getEntity();
        }
        throw FiscalReceiptHelper.getException(result);
    }

    public static String getOrganizationCode() throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.getOrganizationCode();
        if (result.getResponseType() == RestResponseType.OK) {
            return (String)result.getEntity();
        }
        throw FiscalReceiptHelper.getException(result);
    }

    public static boolean isFiscalMode() throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.isFiscalMode();
        if (result.getResponseType() == RestResponseType.OK) {
            return (Boolean)result.getEntity();
        }
        throw FiscalReceiptHelper.getException(result);
    }

    public static void printXReport() throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.printXReport();
        if (result.getResponseType() != RestResponseType.OK) {
            throw FiscalReceiptHelper.getException(result);
        }
    }

    public static String checkOFDConnection() throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.checkOFDConnection();
        if (result.getResponseType() == RestResponseType.OK) {
            return (String)result.getEntity();
        }
        throw FiscalReceiptHelper.getException(result);
    }

    public static Double getCashBoxAmount() throws Exception {
        FiscalReceiptHelper.checkDevice();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.getCashBoxAmount();
        if (result.getResponseType() == RestResponseType.OK) {
            return (Double)result.getEntity();
        }
        throw FiscalReceiptHelper.getException(result);
    }

    public static Double cashIncome(Double amount) throws Exception {
        FiscalReceiptHelper.checkSession();
        String cashierLogin = ServiceInvocationContext.get().getUser();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.cashIncome(amount, cashierLogin, FiscalReceiptHelper.getMidofficeCashier());
        if (result.getResponseType() == RestResponseType.OK) {
            return (Double)result.getEntity();
        }
        throw FiscalReceiptHelper.getException(result);
    }

    public static Double cashOutcome(Double amount) throws Exception {
        FiscalReceiptHelper.checkSession();
        String cashierLogin = ServiceInvocationContext.get().getUser();
        FiscalRestClient restClient = new FiscalRestClient(FiscalReceiptHelper.getServerAddress());
        RestResponse result = restClient.cashOutcome(amount, cashierLogin, FiscalReceiptHelper.getMidofficeCashier());
        if (result.getResponseType() == RestResponseType.OK) {
            return (Double)result.getEntity();
        }
        throw FiscalReceiptHelper.getException(result);
    }

    public static String getServerAddress() throws Exception {
        EntityReference cashRegisterRef = Prefetched.getData().getCurrentAgentData().getCashRegister();
        EntityContainer cashRegisterContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), cashRegisterRef);
        if (cashRegisterContainer != null) {
            String url = ((CashRegister)cashRegisterContainer.getEntity()).getUrl();
            if (TextUtil.nonBlank((String)url)) {
                return url;
            }
            throw Xeption.forEndUser((String)String.format("Server url not defined for cash register %s", ((CashRegister)cashRegisterContainer.getEntity()).getName()), (Object[])new Object[0]);
        }
        throw Xeption.forEndUser((String)String.format("Cash register %s not found", cashRegisterRef), (Object[])new Object[0]);
    }

    private static Exception getException(RestResponse<?> result, String customMessage) throws Exception {
        throw new Exception(String.format("%s:\n%s (%s)", customMessage, result.getErrorMessage(), result.getErrorDescription()));
    }

    private static Exception getException(RestResponse<?> result) throws Exception {
        throw new Exception(String.format("%s (%s)", result.getErrorMessage(), result.getErrorDescription()));
    }

    private static void checkSession() throws Exception {
        if (!FiscalReceiptHelper.isSessionOpen()) {
            FiscalReceiptHelper.openSession();
        }
        if (FiscalReceiptHelper.isSessionExpired()) {
            FiscalReceiptHelper.closeSession();
            FiscalReceiptHelper.openSession();
        }
    }

    private static MidofficeCashier getMidofficeCashier() throws Exception {
        boolean useMidofficeCashier = Prefetched.getData().getFiscalSettings().isUseMidofficeCashier();
        if (useMidofficeCashier) {
            EntityReference cashierRef = Prefetched.getData().getCurrentAgentData().getAgent();
            EntityContainer cashierCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), cashierRef);
            String cashierName = PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)((PersonalLocalizableName)cashierCtr.getEntity()), (boolean)true, (Locale)LocaleHelper.getCurrentLocale(), (boolean)true);
            String cashierInn = ((Person)cashierCtr.getEntity()).getRegistrationId();
            StringBuilder validationResult = new StringBuilder();
            if (TextUtil.isBlank((String)cashierName) || !cashierName.matches("([A-Z\u0410-\u042f][a-z\u0430-\u044f]*)(\\s[A-Z\u0410-\u042f]\\.){1,2}")) {
                validationResult.append("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0424\u0418\u041e \u043a\u0430\u0441\u0441\u0438\u0440\u0430: ").append(cashierName).append("\n");
            }
            if (TextUtil.isBlank((String)cashierInn) || cashierInn.matches(".*\\D.*")) {
                validationResult.append("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0418\u041d\u041d \u043a\u0430\u0441\u0441\u0438\u0440\u0430: ").append(cashierInn).append("\n");
            } else if (cashierInn.length() != 12) {
                validationResult.append("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u0418\u041d\u041d. \u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f: 12 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e: ").append(cashierInn.length());
            }
            if (validationResult.length() > 0) {
                throw new Exception("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043a\u0430\u0441\u0441\u0438\u0440\u0430: \n" + validationResult.toString());
            }
            MidofficeCashier cashier = new MidofficeCashier();
            cashier.setFullName(cashierName);
            cashier.setCashierINN(cashierInn);
            return cashier;
        }
        return null;
    }
}

