/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt;

import com.gridnine.xtrip.client.fx.core.assets.AssetHandler;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListAction;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPane;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LongRunningTaskInfoHandler;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtAction;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.scene.control.SelectionMode;

class LrtManagerPane
extends AssetsListPane {
    private static MultiSupplier<AssetsListPaneConfiguration> createSupplier() {
        return new MultiSupplier<AssetsListPaneConfiguration>(){
            private AssetsListPaneConfiguration allTasks;
            private AssetsListPaneConfiguration runningTasks;

            public String getDisplayName(int idx) {
                return idx == 0 ? Messages.All_tasks : Messages.Undone_tasks;
            }

            public AssetsListPaneConfiguration get(int idx) {
                if (idx == 0) {
                    if (this.allTasks == null) {
                        this.allTasks = this.createConfiguration();
                    }
                    return this.allTasks;
                }
                if (this.runningTasks == null) {
                    this.runningTasks = this.createConfiguration();
                    this.runningTasks.getSearchCriterions().add(SearchCriterion.ne((String)LongRunningTaskInfo.Property.state.name(), (Object)LongRunningTaskInfo.State.COMPLETED));
                }
                return this.runningTasks;
            }

            public int count() {
                return 2;
            }

            private AssetsListPaneConfiguration createConfiguration() {
                AssetsListPaneConfiguration result = new AssetsListPaneConfiguration((AssetHandler)LongRunningTaskInfoHandler.INSTANCE);
                result.applyParameters(LongRunningTaskInfoHandler.INSTANCE.getStandardListParameters());
                result.setPatternSearchEnabled(false);
                result.setActionsEnabled(true);
                result.setSelectionMode(SelectionMode.MULTIPLE);
                result.getSorting().put(LongRunningTaskInfo.Property.created.name(), SortOrder.DESC);
                return result;
            }
        };
    }

    LrtManagerPane(ObservableMutex mutex) {
        super(mutex, LrtManagerPane.createSupplier());
    }

    protected Collection<AssetsListAction> collectActions() {
        return ClientRegistry.get().allOf(AssetsListAction.TYPE).values().stream().filter(action -> action instanceof LrtAction).collect(Collectors.toList());
    }
}

