/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.model.custom.restrictions.RestrictionsData;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.client.fx.standard.restriction.BasicRestrictionsWidget;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.finance.FinanceInitialization2TaskConfiguration;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.Node;

public class FinanceInitializationTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "FinanceInitializationTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.FinanceInitialization2Task";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final CheckBoxWidget useSimple = new CheckBoxWidget(false);
        private final BasicRestrictionsWidget criterions = new BasicRestrictionsWidget(false);

        Configurator() {
            super(2);
            GridCell critCell = new GridCell(Messages.Criteria, (Node)this.criterions);
            critCell.setColSpan(Integer.MAX_VALUE);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.Simple_Initialization, (Node)this.useSimple), GridCell.NEW_ROW_MARKER, critCell});
            IndexType indexType = (IndexType)MetaRegistry.get().getIndexes().get(OrganizationIndex.class.getName());
            RestrictionsData restrictionsData = new RestrictionsData();
            restrictionsData.setRestrictionId(indexType != null ? indexType.getId() : null);
            restrictionsData.getRestrictions().clear();
            restrictionsData.getRestrictions().addAll(new ArrayList());
            this.criterions.readData(restrictionsData);
        }

        FinanceInitialization2TaskConfiguration createConfiguration() {
            FinanceInitialization2TaskConfiguration configuration = new FinanceInitialization2TaskConfiguration();
            configuration.setSimple(this.useSimple.isSelected());
            RestrictionsData restrictionsData = new RestrictionsData();
            this.criterions.writeData(restrictionsData);
            configuration.getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)restrictionsData.getRestrictions(), OrganizationIndex.class, Collections.emptyList()));
            return configuration;
        }
    }
}

