/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.client.fx.standard.lrt.handlers.TaskHelper;
import com.gridnine.xtrip.common.model.tasks.FindDifferentsTask2Configuration;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class FindDifferentsTask2Handler
implements LrtHandler<Configurator> {
    public String getId() {
        return "FindDifferentsTask2";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.FindDifferentsTask2";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        protected final ComboBoxWidget<String> primaryStorage = new ComboBoxWidget(false);
        protected final ComboBoxWidget<String> secondaryStorage;
        protected final DateValueWidget date;
        protected final IntValueWidget hours;
        protected final IntValueWidget threadCount;
        protected final IntValueWidget maxResultCount;
        protected final BooleanValueWidget searchOverMax;
        protected final BooleanValueWidget isUsedCreateDate;
        protected final BooleanValueWidget stopOnError;
        protected final BooleanValueWidget repairTypes;
        protected GridContainer treePane;
        protected CustomCheckBoxTreeView<TaskHelper.Item> tree;

        Configurator() {
            super(3);
            this.primaryStorage.setAsync(true);
            this.primaryStorage.setItemsSupplier(() -> TaskHelper.createListAndConverter(this.primaryStorage));
            this.secondaryStorage = new ComboBoxWidget(false);
            this.secondaryStorage.setAsync(true);
            this.secondaryStorage.setItemsSupplier(() -> TaskHelper.createListAndConverter(this.secondaryStorage));
            this.date = new DateValueWidget(false);
            this.hours = new IntValueWidget(false);
            this.threadCount = new IntValueWidget(false);
            this.maxResultCount = new IntValueWidget(false);
            this.searchOverMax = new BooleanValueWidget(true, false);
            this.isUsedCreateDate = new BooleanValueWidget(true, false);
            this.stopOnError = new BooleanValueWidget(true, false);
            this.repairTypes = new BooleanValueWidget(true, false);
            CustomCheckBoxTreeView<TaskHelper.Item> customTreeView = TaskHelper.createTree();
            customTreeView.setReadonly(true);
            this.treePane = GridContainer.wrap((Node)customTreeView.getTreePane());
            this.tree = customTreeView;
            this.repairTypes.valueProperty().addListener((obs, oldValue, newValue) -> customTreeView.setReadonly(newValue == false));
            this.searchOverMax.setValue(true);
            this.isUsedCreateDate.setValue(true);
            this.stopOnError.setValue(true);
            this.repairTypes.setValue(false);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.PrimaryStorage, this.primaryStorage), new GridCell(Messages.SecondaryStorage, this.secondaryStorage), new GridCell(Messages.Date, (Node)this.date), new GridCell(Messages.Hours, (Node)this.hours), new GridCell(Messages.ThreadCount, (Node)this.threadCount), new GridCell(Messages.MaxResultCount, (Node)this.maxResultCount), new GridCell(Messages.isUsedCreateDate, (Node)this.isUsedCreateDate), new GridCell(Messages.StopOnError2, (Node)this.stopOnError), new GridCell(Messages.RepairTypes, (Node)this.repairTypes), new GridCell(Messages.List, (Node)this.treePane)});
        }

        FindDifferentsTask2Configuration createConfiguration() {
            FindDifferentsTask2Configuration result = new FindDifferentsTask2Configuration();
            result.setPrimaryStorageUid((String)this.primaryStorage.getValue());
            result.setSecondaryStorageUid((String)this.secondaryStorage.getValue());
            result.setDate(DateUtils.asDate((LocalDate)this.date.getValue()));
            result.setHours(this.hours.getValue() == null ? 0 : (Integer)this.hours.getValue());
            result.setThreadCount(this.threadCount.getValue() == null ? 0 : (Integer)this.threadCount.getValue());
            result.setUsedCreateDate(this.isUsedCreateDate.getValue());
            result.setStopOnError(this.stopOnError.getValue());
            result.setMaxResultCount(this.maxResultCount.getValue() == null ? 0 : (Integer)this.maxResultCount.getValue());
            result.setSearchOverMax(this.searchOverMax.getValue());
            if (this.repairTypes.getValue()) {
                for (String id : this.tree.getSelectedItemsIds()) {
                    if (id.equals("root")) continue;
                    result.getTypeList().add(id);
                }
            } else {
                result.getTypeList().addAll(this.tree.getTreeView().getRoot().getChildren().stream().map(item -> ((TaskHelper.Item)item.getValue()).getId()).filter(str -> !str.equals("root")).collect(Collectors.toList()));
            }
            return result;
        }
    }
}

