/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.alt;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.MainTool;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiSettings;
import com.gridnine.xtrip.client.fx.standard.helpers.EntityEditorHelper;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionGroupResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class OpenByUidTool
implements MainTool {
    private static final AclQuery ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.USE.getId(), StandardRestrictionGroupResources.GROUP_ADMINISTRATION.getId());

    public String getId() {
        return "main-tool-open-by-uid";
    }

    public String getName() {
        return "Open by UID";
    }

    public boolean isAltTool() {
        return true;
    }

    public double getWeight() {
        return 5.0;
    }

    public AclQuery getACLQuery() {
        return ACL_QUERY;
    }

    public void execute() {
        GridContainer ctr = new GridContainer(1);
        final GridCell typeCell = new GridCell("Root Entity Type", (Node)new ComboBoxWidget(false));
        final List rootEntities = MetaRegistryHelper.getRootEntities().stream().filter(ett -> !ett.isAbstract() && !ett.isHidden()).collect(Collectors.toList());
        ((ComboBoxWidget)typeCell.getPayload()).setItemsSupplier(() -> rootEntities);
        ((ComboBoxWidget)typeCell.getPayload()).setConverter((StringConverter)new StringConverter<EntityType>(){

            public String toString(EntityType object) {
                return object == null ? null : object.getDisplayName();
            }

            public EntityType fromString(String string) {
                return null;
            }
        });
        ((ComboBoxWidget)typeCell.getPayload()).setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(((ComboBoxWidget)typeCell.getPayload()).getConverter(), ((ComboBoxWidget)typeCell.getPayload()).getItemsSupplier(), ((ComboBoxWidget)typeCell.getPayload()).isSortItems()));
        ((ComboBoxWidget)typeCell.getPayload()).guessPrefWidth();
        ctr.getCells().add((Object)typeCell);
        final GridCell uidCell = new GridCell("Root Entity UID", (Node)new TextFieldWidget(false));
        ctr.getCells().add((Object)uidCell);
        UiSettings settings = new UiSettings("open-by-uid-dialog", new UiSettings.Persister[]{new UiSettings.Persister(){

            public void read(Properties props) throws Exception {
                String type = props.getProperty("type");
                if (type != null) {
                    for (EntityType ett : rootEntities) {
                        if (!ett.getId().equals(type)) continue;
                        ((ComboBoxWidget)typeCell.getPayload()).setValue((Object)ett);
                        break;
                    }
                }
                ((TextFieldWidget)uidCell.getPayload()).setValue(props.getProperty("uid"));
            }

            public void write(Properties props) throws Exception {
                EntityType value = (EntityType)((ComboBoxWidget)typeCell.getPayload()).getValue();
                if (value != null) {
                    props.setProperty("type", value.getId());
                }
                props.setProperty("uid", ((TextFieldWidget)uidCell.getPayload()).getValue());
            }
        }});
        settings.load();
        new Dialog().setTitle("Open Root Entity by UID").setBody((Node)ctr).addButton(DialogButtonStyle.ACCEPT_REGULAR, "Open", () -> {
            settings.save();
            EntityType entityType = (EntityType)((ComboBoxWidget)typeCell.getPayload()).getValue();
            String uid = ((TextFieldWidget)uidCell.getPayload()).getValue();
            try {
                EntityReference ref = new EntityReference(uid, XSHelper.getClass((String)entityType.getId()), null);
                if (RootEntityHandler.forEntityClass((Class)ref.getType()) != null) {
                    RootEntityEditingService.navigateTo((EntityReference)ref);
                } else {
                    EntityEditorHelper.open(ref, null);
                }
            }
            catch (ClassNotFoundException e) {
                ErrorHandler.handle((Throwable)e);
            }
        }, (BooleanExpression)new BooleanBinding(){
            {
                this.bind(new Observable[]{((ComboBoxWidget)typeCell.getPayload()).valueProperty(), ((TextFieldWidget)uidCell.getPayload()).valueProperty()});
            }

            protected boolean computeValue() {
                return ((ComboBoxWidget)typeCell.getPayload()).getValue() != null && !TextUtil.isBlank((String)((TextFieldWidget)uidCell.getPayload()).getValue());
            }
        }).showGlobal();
    }
}

