/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.bugreport;

import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportDialog;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportPanel;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BugReportContractPanel;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.support.ContractBugReport;
import com.gridnine.xtrip.common.model.system.exchange.ExportType;
import com.gridnine.xtrip.common.model.system.exchange.ExportedItem;
import com.gridnine.xtrip.common.model.system.exchange.ExternalFile;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.model.system.exchange.ItemType;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class BugReportContractDialog
extends BaseBugReportDialog<ContractBugReport, BugReportContractPanel> {
    private ItemExportSettings settings;

    @Override
    protected BugReportContractPanel createPanel() {
        return new BugReportContractPanel(BaseBugReportPanel.BugReportPanelMode.DIALOG);
    }

    @Override
    protected void updateSettings(ArrayList<ItemExportSettings> exportSettings, BugReportContractPanel panel, BiConsumer<ArrayList<ItemExportSettings>, BugReportContractPanel> callback) {
        EntityReference<BookingFile> bookingFile = panel.getBookingFile();
        if (bookingFile != null) {
            this.settings = new ItemExportSettings();
            this.settings.setExportType(ExportType.SELECTED);
            this.settings.setItemType(ItemType.ENTITY);
            this.settings.getSelectedItems().add(bookingFile);
            this.settings.setObjectId(BookingFile.class.getName());
            exportSettings.add(this.settings);
        } else {
            this.settings = null;
        }
        callback.accept(exportSettings, panel);
    }

    @Override
    protected String getDialogTitle() {
        return Messages.Description_of_the_situation;
    }

    @Override
    protected String getTaskTitle() {
        return Messages.Collection_of_information;
    }

    @Override
    protected ContractBugReport createSupportObject(BugReportContractPanel panel) {
        ContractBugReport res = new ContractBugReport();
        this.setGeneralFields(panel, res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setCustomFields(BugReportContractPanel panel, ContractBugReport data, Map<ItemExportSettings, List<ExportedItem>> result) {
        List<ExportedItem> exportedItem;
        File tchFile = panel.getTchFile();
        if (tchFile != null) {
            if (tchFile.exists()) {
                ExternalFile externalFile = new ExternalFile();
                externalFile.setFileName(tchFile.getAbsolutePath());
                try (FileInputStream fis = new FileInputStream(tchFile);){
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IoUtil.copyStream((InputStream)fis, (OutputStream)baos, (int)256);
                    externalFile.setContent(baos.toByteArray());
                    data.setTchXmlNotification(externalFile);
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.An_error_has_occurred, (Throwable)e, (Object[])new Object[0]));
                }
            }
        } else {
            data.setTchXmlNotification(null);
        }
        if (this.settings != null && (exportedItem = result.get(this.settings)) != null) {
            data.getExportedItems().addAll(exportedItem);
        }
        data.setBooking(panel.getBookingFile());
    }
}

