/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.bugreport;

import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportDialog;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportPanel;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BugReportParsingPanel;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.handlers.standard.ParsersEntitiesGroupHandler;
import com.gridnine.xtrip.common.model.support.parsers.ParsingBugReport;
import com.gridnine.xtrip.common.model.system.exchange.ExportType;
import com.gridnine.xtrip.common.model.system.exchange.ExportedItem;
import com.gridnine.xtrip.common.model.system.exchange.ExternalFile;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.model.system.exchange.ItemType;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class BugReportParsingDialog
extends BaseBugReportDialog<ParsingBugReport, BugReportParsingPanel> {
    @Override
    protected BugReportParsingPanel createPanel() {
        return new BugReportParsingPanel(BaseBugReportPanel.BugReportPanelMode.DIALOG);
    }

    @Override
    protected ParsingBugReport createSupportObject(BugReportParsingPanel panel) {
        ParsingBugReport res = new ParsingBugReport();
        this.setGeneralFields(panel, res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setCustomFields(BugReportParsingPanel panel, ParsingBugReport data, Map<ItemExportSettings, List<ExportedItem>> result) {
        data.getExchangeFiles().clear();
        try {
            for (File file : panel.getLocalFiles()) {
                if (file == null) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (FileInputStream fis = new FileInputStream(file);){
                    IoUtil.copyStream((InputStream)fis, (OutputStream)baos, (int)256);
                    ExternalFile item = new ExternalFile();
                    item.setFileName(file.getAbsolutePath());
                    item.setContent(baos.toByteArray());
                    data.getExchangeFiles().add(item);
                }
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.An_error_has_occurred, (Throwable)e, (Object[])new Object[0]));
        }
        data.getExchangeDocuments().clear();
        data.getExchangeDocuments().addAll(panel.getExchangeFiles());
    }

    @Override
    protected String getDialogTitle() {
        return Messages.Discription;
    }

    @Override
    protected String getTaskTitle() {
        return Messages.Collect_information;
    }

    @Override
    protected void updateSettings(ArrayList<ItemExportSettings> exportSettingsList, BugReportParsingPanel panel, BiConsumer<ArrayList<ItemExportSettings>, BugReportParsingPanel> callback) {
        HashMap<String, ArrayList<EntityReference<BaseExchangeDocument>>> docs = new HashMap<String, ArrayList<EntityReference<BaseExchangeDocument>>>();
        for (EntityReference<BaseExchangeDocument> item : panel.getExchangeFiles()) {
            if (item == null) continue;
            ArrayList<EntityReference<BaseExchangeDocument>> list = (ArrayList<EntityReference<BaseExchangeDocument>>)docs.get(item.getType().getName());
            if (list == null) {
                list = new ArrayList<EntityReference<BaseExchangeDocument>>();
                docs.put(item.getType().getName(), list);
            }
            list.add(item);
        }
        if (!docs.isEmpty()) {
            ItemExportSettings addSettings = new ItemExportSettings();
            addSettings.setExportType(ExportType.ALL);
            addSettings.setGroup(true);
            addSettings.setObjectId(ParsersEntitiesGroupHandler.exchangeFilesGroup.getId());
            for (Map.Entry entry : docs.entrySet()) {
                ItemExportSettings settings = new ItemExportSettings();
                settings.setExportType(ExportType.SELECTED);
                settings.setItemType(ItemType.ENTITY);
                settings.getSelectedItems().addAll((Collection)entry.getValue());
                settings.setObjectId((String)entry.getKey());
                addSettings.getChildren().add(settings);
                settings.setParent(addSettings);
            }
            exportSettingsList.add(addSettings);
        }
        callback.accept(exportSettingsList, panel);
    }
}

