/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.bugreport;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.FileChooserWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportPanel;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.support.parsers.ParsingBugReport;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import org.apache.commons.io.FilenameUtils;

public class BugReportParsingPanel
extends BaseBugReportPanel<ParsingBugReport> {
    private static final Set<String> OBJECT_IDS = new HashSet<String>(Arrays.asList(SalesPoint.class.getName(), Person.class.getName(), Contract.class.getName(), CommissionProperties.class.getName(), FeeProperties.class.getName(), DiscountProperties.class.getName(), BlankType.class.getName(), CommissionCategory.class.getName(), CurrencyRate.class.getName(), Organization.class.getName(), PassengerType.class.getName(), PassengerTypeCategory.class.getName(), ModelContract.class.getName()));
    private TableWidget<ValueHolder<EntityReference<BaseExchangeDocument>>> exchangeFilesWidget;
    private TableWidget<ValueHolder<MiscUtil.Pair<File, byte[]>>> localFilesWidget;
    private TableWidgetController<TableWidget<ValueHolder<EntityReference<BaseExchangeDocument>>>, ValueHolder<EntityReference<BaseExchangeDocument>>> exchangeFilesController;
    private TableWidgetController<TableWidget<ValueHolder<MiscUtil.Pair<File, byte[]>>>, ValueHolder<MiscUtil.Pair<File, byte[]>>> localFilesController;

    public BugReportParsingPanel(BaseBugReportPanel.BugReportPanelMode mode) {
        super(mode);
        this.createWidgets();
        this.createCards();
    }

    @Override
    protected Predicate<String> getObjectFilter() {
        return OBJECT_IDS::contains;
    }

    private void createWidgets() {
        this.exchangeFilesWidget = new TableWidget(false);
        this.exchangeFilesWidget.setItemsProvider(ValueHolder::new);
        this.exchangeFilesWidget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE);
        EntityBoxWidgetColumn column = new EntityBoxWidgetColumn(BaseExchangeDocument.class, ValueHolder::get, ValueHolder::set);
        column.setId("exchangeFile");
        column.setCaption(Messages.File_name);
        column.setListParametersSupplier(ControllerInterceptorsHelper.getExchangeDocumentsMulti());
        ArrayList<EntityBoxWidgetColumn> columns = new ArrayList<EntityBoxWidgetColumn>();
        columns.add(column);
        this.exchangeFilesWidget.setColumns(columns);
        this.localFilesWidget = new TableWidget(false);
        this.localFilesWidget.setItemsProvider(ValueHolder::new);
        this.localFilesWidget.setControlButtonsAvailability(this.mode == BaseBugReportPanel.BugReportPanelMode.EDITOR ? ControlsPane.NONE : ControlsPane.ADD_REMOVE);
        Function<ValueHolder, MiscUtil.Pair> getter = obj -> {
            if (obj.get() == null) {
                obj.set((Object)new MiscUtil.Pair());
            }
            return (MiscUtil.Pair)obj.get();
        };
        BiConsumer<ValueHolder, File> setter = (obj, value) -> ((MiscUtil.Pair)obj.get()).setFirst(value);
        FileChooserWidgetColumn column2 = new FileChooserWidgetColumn(getter, setter, this.mode == BaseBugReportPanel.BugReportPanelMode.EDITOR ? FileChooserWidget.ChoosingMode.SAVE_IMMEDIATELY : FileChooserWidget.ChoosingMode.OPEN_SINGLE);
        column2.setId("localFile");
        column2.setCaption(Messages.File_name);
        ArrayList<FileChooserWidgetColumn> columns2 = new ArrayList<FileChooserWidgetColumn>();
        columns2.add(column2);
        this.localFilesWidget.setColumns(columns2);
        this.exchangeFilesController = new TableWidgetController<TableWidget<ValueHolder<EntityReference<BaseExchangeDocument>>>, ValueHolder<EntityReference<BaseExchangeDocument>>>(){

            public TableWidget<ValueHolder<EntityReference<BaseExchangeDocument>>> getView() {
                return BugReportParsingPanel.this.exchangeFilesWidget;
            }
        };
        this.localFilesController = new TableWidgetController<TableWidget<ValueHolder<MiscUtil.Pair<File, byte[]>>>, ValueHolder<MiscUtil.Pair<File, byte[]>>>(){

            public TableWidget<ValueHolder<MiscUtil.Pair<File, byte[]>>> getView() {
                return BugReportParsingPanel.this.localFilesWidget;
            }
        };
    }

    private void createCards() {
        Card \u0441ard = new Card("mainParameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)this.buildMainParametersContainer());
        this.cards.add(\u0441ard);
        \u0441ard = new Card("registeredFiles", UiCardsContainer.Style.COLLAPSED, Messages.Registered_files, (Node)this.buildRegisteredFilesContainer());
        this.cards.add(\u0441ard);
        \u0441ard = new Card("localFiles", UiCardsContainer.Style.COLLAPSED, Messages.Local_files, (Node)this.buildLocalFilesContainer());
        this.cards.add(\u0441ard);
        \u0441ard = new Card("exportedData", UiCardsContainer.Style.COLLAPSED, Messages.Uploading_data, (Node)this.buildTreeParametersContainer());
        this.cards.add(\u0441ard);
        this.getCards().addAll((Collection)this.cards);
    }

    private GridContainer buildRegisteredFilesContainer() {
        GridContainer container = new GridContainer(8);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        container.getCells().addAll(cells);
        GridCell cell = new GridCell(this.exchangeFilesWidget);
        cell.setColSpan(8);
        cells.add(cell);
        container.getCells().addAll(cells);
        return container;
    }

    private GridContainer buildLocalFilesContainer() {
        GridContainer container = new GridContainer(8);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        container.getCells().addAll(cells);
        GridCell cell = new GridCell(this.localFilesWidget);
        cell.setColSpan(8);
        cells.add(cell);
        container.getCells().addAll(cells);
        return container;
    }

    public List<EntityReference<BaseExchangeDocument>> getExchangeFiles() {
        ArrayList res = new ArrayList();
        this.exchangeFilesController.writeData(res);
        return res.stream().map(obj -> (EntityReference)obj.get()).collect(Collectors.toList());
    }

    public List<File> getLocalFiles() {
        ArrayList res = new ArrayList();
        this.localFilesController.writeData(res);
        return res.stream().map(obj -> (File)((MiscUtil.Pair)obj.get()).getFirst()).collect(Collectors.toList());
    }

    @Override
    public void readData(ParsingBugReport model) {
        super.readData(model);
        List exchangeFilesHolders = model.getExchangeDocuments().stream().map(obj -> {
            ValueHolder holder = new ValueHolder();
            holder.set(obj);
            return holder;
        }).collect(Collectors.toList());
        this.exchangeFilesController.readData(exchangeFilesHolders);
        List localFilesHolders = model.getExchangeFiles().stream().map(obj -> {
            ValueHolder holder = new ValueHolder();
            MiscUtil.Pair pair = new MiscUtil.Pair();
            pair.setFirst((Object)new File(FilenameUtils.getName((String)obj.getFileName())));
            pair.setSecond((Object)obj.getContent());
            holder.set((Object)pair);
            return holder;
        }).collect(Collectors.toList());
        this.localFilesController.readData(localFilesHolders);
    }

    @Override
    public void setReadonly(boolean readonly) {
        super.setReadonly(readonly);
        this.exchangeFilesController.setReadonly(readonly);
        this.localFilesController.setReadonly(false);
    }

    @Override
    public void setNotEditable(boolean notEditable) {
        super.setNotEditable(notEditable);
        this.exchangeFilesController.setNotEditable(notEditable);
        this.localFilesController.setNotEditable(notEditable);
    }

    @Override
    public void setAclNotEditable(boolean aclNotEditable) {
        super.setAclNotEditable(aclNotEditable);
        this.exchangeFilesController.setAclNotEditable(aclNotEditable);
        this.localFilesController.setAclNotEditable(aclNotEditable);
    }
}

