/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.bugreport;

import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportDialog;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportPanel;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BugReportSalesReportPanel;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.support.reports.SalesReportBugReport;
import com.gridnine.xtrip.common.model.system.exchange.EntityQueryData;
import com.gridnine.xtrip.common.model.system.exchange.ExportType;
import com.gridnine.xtrip.common.model.system.exchange.ExportedItem;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.model.system.exchange.ItemType;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.SsodExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.SsodExchangeDocumentIndex;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class BugReportSalesReportDialog
extends BaseBugReportDialog<SalesReportBugReport, BugReportSalesReportPanel> {
    private ItemExportSettings productSettings;
    private ItemExportSettings stockBlankSettings;
    private ItemExportSettings hotFilesSettings;
    private ItemExportSettings ssodFilesSettings;
    private ItemExportSettings cccFilesSettings;

    @Override
    protected BugReportSalesReportPanel createPanel() {
        return new BugReportSalesReportPanel(BaseBugReportPanel.BugReportPanelMode.DIALOG);
    }

    @Override
    protected String getDialogTitle() {
        return Messages.Description_and_report;
    }

    @Override
    protected String getTaskTitle() {
        return Messages.Collect_and_report;
    }

    @Override
    protected void updateSettings(ArrayList<ItemExportSettings> exportSettings, BugReportSalesReportPanel panel, BiConsumer<ArrayList<ItemExportSettings>, BugReportSalesReportPanel> callback) {
        ReportParameters reportParameters = panel.getReportParametrers();
        this.productSettings = this.createProductExportSettings(reportParameters);
        exportSettings.add(this.productSettings);
        this.stockBlankSettings = this.createStockBlankExportSettings(reportParameters);
        exportSettings.add(this.stockBlankSettings);
        this.ssodFilesSettings = this.createExchangeFilesSettings(reportParameters, SsodExchangeDocument.class, SsodExchangeDocumentIndex.class, SsodExchangeDocumentIndex.Property.issued.name());
        exportSettings.add(this.ssodFilesSettings);
        this.cccFilesSettings = this.createExchangeFilesSettings(reportParameters, CCCExchangeDocument.class, CCCExchangeDocumentIndex.class, CCCExchangeDocumentIndex.Property.issued.name());
        exportSettings.add(this.cccFilesSettings);
        this.hotFilesSettings = this.createExchangeFilesSettings(reportParameters, HotExchangeDocument.class, HotExchangeDocumentIndex.class, HotExchangeDocumentIndex.Property.issued.name());
        exportSettings.add(this.hotFilesSettings);
        callback.accept(exportSettings, panel);
    }

    @Override
    protected String validate(BugReportSalesReportPanel panel) {
        String result = super.validate(panel);
        if (result != null) {
            return result;
        }
        if (panel.getStartDate() == null) {
            return Messages.No_start_date_specified;
        }
        if (panel.getEndDate() == null) {
            return Messages.No_end_date_specified;
        }
        return null;
    }

    @Override
    protected SalesReportBugReport createSupportObject(BugReportSalesReportPanel panel) {
        SalesReportBugReport res = new SalesReportBugReport();
        this.setGeneralFields(panel, res);
        return res;
    }

    @Override
    protected void setCustomFields(BugReportSalesReportPanel panel, SalesReportBugReport data, Map<ItemExportSettings, List<ExportedItem>> result) {
        List<ExportedItem> list;
        ReportParameters reportParameters = panel.getReportParametrers();
        data.setReportParameters(reportParameters);
        if (this.productSettings != null && (list = result.get(this.productSettings)) != null) {
            data.getExportedItems().addAll(list);
        }
        if (this.stockBlankSettings != null && (list = result.get(this.stockBlankSettings)) != null) {
            data.getExportedItems().addAll(list);
        }
        if (this.ssodFilesSettings != null && (list = result.get(this.ssodFilesSettings)) != null) {
            data.getExportedItems().addAll(list);
        }
        if (this.cccFilesSettings != null && (list = result.get(this.cccFilesSettings)) != null) {
            data.getExportedItems().addAll(list);
        }
        if (this.hotFilesSettings != null && (list = result.get(this.hotFilesSettings)) != null) {
            data.getExportedItems().addAll(list);
        }
    }

    private ItemExportSettings createProductExportSettings(ReportParameters reportParameters) {
        ItemExportSettings result = new ItemExportSettings();
        result.setExportType(ExportType.QUERY);
        result.setItemType(ItemType.ENTITY);
        result.setObjectId(BookingFile.class.getName());
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(ProductIndex.Property.issueDate.name());
        if (reportParameters.getBlankOwner() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)reportParameters.getBlankOwner()));
            query.getPreferredProperties().add(ProductIndex.Property.blankOwner.name());
        }
        if (!reportParameters.getAdditionalCriterions().isEmpty()) {
            query.getCriteria().getCriterions().addAll(reportParameters.getAdditionalCriterions());
        }
        if (reportParameters.getAgency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agency.name(), (Object)reportParameters.getAgency()));
            query.getPreferredProperties().add(ProductIndex.Property.agency.name());
        }
        if (reportParameters.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.salesPoint.name(), (Object)reportParameters.getSalesPoint()));
            query.getPreferredProperties().add(ProductIndex.Property.salesPoint.name());
        }
        if (reportParameters.getSubagency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)reportParameters.getSubagency()));
            query.getPreferredProperties().add(ProductIndex.Property.subagency.name());
        }
        if (reportParameters.getSupplier() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.supplier.name(), (Object)reportParameters.getSupplier()));
            query.getPreferredProperties().add(ProductIndex.Property.supplier.name());
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.firstFlightDate.name(), (Object)reportParameters.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.firstFlightDate.name(), (Object)reportParameters.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.lastFlightDate.name(), (Object)reportParameters.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.lastFlightDate.name(), (Object)reportParameters.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)reportParameters.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)reportParameters.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.dateOfVendorPayment.name(), (Object)reportParameters.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.dateOfVendorPayment.name(), (Object)reportParameters.getPeriodEnd())})}));
        EntityQueryData queryData = new EntityQueryData();
        queryData.setIndexClassName(ProductIndex.class.getName());
        queryData.setQuery(query);
        result.setQueryData(queryData);
        result.setObjectId(BookingFile.class.getName());
        return result;
    }

    private ItemExportSettings createStockBlankExportSettings(ReportParameters reportParameters) {
        Date beginDate = reportParameters.getPeriodBegin();
        EntityReference supplierRef = reportParameters.getSupplier();
        EntityReference ownerRef = reportParameters.getAgency();
        EntityReference agencyRef = reportParameters.getAgency();
        SearchQuery query = new SearchQuery();
        List criterions = query.getCriteria().getCriterions();
        if (ownerRef != null) {
            criterions.add(SearchCriterion.eq((String)StockBlankIndex.Property.owner.name(), (Object)ownerRef.getUid()));
        }
        if (supplierRef != null) {
            criterions.add(SearchCriterion.eq((String)StockBlankIndex.Property.supplier.name(), (Object)supplierRef.getUid()));
        }
        if (agencyRef != null) {
            criterions.add(SearchCriterion.eq((String)StockBlankIndex.Property.stockHolder.name(), (Object)agencyRef.getUid()));
        }
        SearchCriterion sc2 = SearchCriterion.eq((String)StockBlankIndex.Property.operationDate.name(), null);
        SearchCriterion sc3 = SearchCriterion.ge((String)StockBlankIndex.Property.operationDate.name(), (Object)beginDate);
        SearchCriterion sc4 = SearchCriterion.ne((String)StockBlankIndex.Property.vendorPaymentDate.name(), null);
        SearchCriterion sc5 = SearchCriterion.ge((String)StockBlankIndex.Property.vendorPaymentDate.name(), (Object)beginDate);
        criterions.add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{sc2, sc3, SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{sc4, sc5})})}));
        criterions.add(SearchCriterion.ne((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.LOCKED));
        ItemExportSettings result = new ItemExportSettings();
        result.setExportType(ExportType.QUERY);
        result.setItemType(ItemType.ENTITY);
        result.setObjectId(StockBlank.class.getName());
        EntityQueryData queryData = new EntityQueryData();
        queryData.setIndexClassName(StockBlankIndex.class.getName());
        queryData.setQuery(query);
        result.setQueryData(queryData);
        return result;
    }

    private <E extends BaseExchangeDocument, I extends EntityIndex<E>> ItemExportSettings createExchangeFilesSettings(ReportParameters reportParameters, Class<E> ettClass, Class<I> idxClass, String name) {
        Date beginDate = reportParameters.getPeriodBegin();
        Date endDate = reportParameters.getPeriodEnd();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)name, (Object)beginDate));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)name, (Object)endDate));
        ItemExportSettings result = new ItemExportSettings();
        result.setExportType(ExportType.QUERY);
        result.setItemType(ItemType.ENTITY);
        result.setObjectId(ettClass.getName());
        EntityQueryData queryData = new EntityQueryData();
        queryData.setIndexClassName(idxClass.getName());
        queryData.setQuery(query);
        result.setQueryData(queryData);
        return result;
    }
}

