/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.notifications;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.helpers.EntityEditorHelper;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.notifications.DateShift;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper;
import com.gridnine.xtrip.common.model.system.EventNotification;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import javafx.scene.Node;

class EventNotificationDialog {
    private static final String AUDIT_TAG = "notification";

    EventNotificationDialog() {
    }

    static void show(EntityContainer<EventNotification> notificationCtr, CountDownLatch cdl) {
        Dialog dialog = new Dialog();
        dialog.setTitle(TextUtil.isBlank((String)((EventNotification)notificationCtr.getEntity()).getTitle()) ? Messages.Notification_dialog_title : ((EventNotification)notificationCtr.getEntity()).getTitle()).setBody(EventNotificationDialog.buildPane((EventNotification)notificationCtr.getEntity())).setAutoClose(false).setOnCloseRequest(() -> {
            EventNotificationDialog.handleUserAction(null, notificationCtr, cdl);
            dialog.close();
        }).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Close, () -> {
            EventNotificationDialog.handleUserAction(null, notificationCtr, cdl);
            dialog.close();
        }).addButton(DialogButtonStyle.AUXILARY, Messages.Notification_remind_later, src -> {
            ComboBoxWidget widget = new ComboBoxWidget(false);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(DateShift.class));
            widget.setSortItems(false);
            widget.setNoNulls(true);
            widget.setValue((Object)DateShift.ONE_MINUTE);
            widget.guessPrefWidth();
            LightDialog ld = new LightDialog();
            ld.setBody((Node)widget).setActionCaption("OK").setActionHandler(() -> {
                EventNotificationDialog.handleUserAction(((DateShift)((Object)((Object)((Object)widget.getValue())))).doShift(LocalDateTime.now()), notificationCtr, cdl);
                dialog.close();
            }).show(src);
            cdl.countDown();
        }, null);
        FxUtil.submitToFxThread(() -> ((Dialog)dialog).showGlobal());
        try {
            ((AssetService)RpcServiceManager.get().getService(AssetService.class)).save(ServiceInvocationContext.get(), (BaseAsset)SysLogHelper.newAuditItem((EntityReference)notificationCtr.toReference(), (String)AUDIT_TAG, (Message)MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Notification_msg_displayed, (Object[])new Object[0])));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    private static Node buildPane(EventNotification notification) {
        GridCell cell;
        GridContainer result = new GridContainer(3);
        DateTimeValueWidget widget = new DateTimeValueWidget(true);
        widget.setValue(DateUtils.asLocalDateTime((Date)notification.getEventDate()));
        result.getCells().add((Object)new GridCell(Messages.Notification_event_date, (Node)widget));
        if (notification.getEntityReference() != null) {
            widget = new HyperlinkWidget();
            widget.setText(notification.getEntityReference().toString());
            widget.setOnAction(evt -> EntityEditorHelper.navigate((EntityReference)notification.getEntityReference(), (boolean)false));
            cell = new GridCell(Messages.Notification_entity_reference, (Node)widget);
            cell.setColSpan(Integer.MAX_VALUE);
            result.getCells().add((Object)cell);
        }
        result.getCells().add((Object)GridCell.NEW_ROW_MARKER);
        widget = new TextAreaWidget(true);
        widget.setValue(notification.getText());
        cell = new GridCell(Messages.Notification_text, (Node)widget);
        cell.setColSpan(Integer.MAX_VALUE);
        result.getCells().add((Object)cell);
        return result;
    }

    private static void handleUserAction(LocalDateTime newAlarmDate, EntityContainer<EventNotification> notificationCtr, CountDownLatch cdl) {
        Notifications.get().submitTask(() -> {
            try {
                SysLogItem sysLogItem;
                EventNotification eventNotification = (EventNotification)notificationCtr.getEntity();
                eventNotification.setViewingDate(null);
                if (newAlarmDate == null) {
                    if (eventNotification.isRepeatOnceYear()) {
                        if (eventNotification.getAlarmDate().before(new Date())) {
                            LocalDateTime dateTimeNextAlarm = LocalDateTime.now().plusYears(1L);
                            eventNotification.setAlarmDate(DateUtils.asDate((LocalDateTime)dateTimeNextAlarm));
                        }
                        sysLogItem = SysLogHelper.newAuditItem((EntityReference)notificationCtr.toReference(), (String)AUDIT_TAG, (Message)MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Notification_msg_planned_for_next_year, (Object[])new Object[0]));
                    } else {
                        sysLogItem = SysLogHelper.newAuditItem((EntityReference)notificationCtr.toReference(), (String)AUDIT_TAG, (Message)MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Notification_msg_stopped, (Object[])new Object[0]));
                    }
                } else {
                    eventNotification.setAlarmDate(DateUtils.asDate((LocalDateTime)newAlarmDate));
                    eventNotification.setMailingDate(null);
                    sysLogItem = SysLogHelper.newAuditItem((EntityReference)notificationCtr.toReference(), (String)AUDIT_TAG, (Message)MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Notification_msg_postponed, (Object[])new Object[0]));
                }
                notificationCtr.getVersionInfo().setDataSource("fx-client-notification");
                notificationCtr.getVersionInfo().setVersionNotes("notification process");
                ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), notificationCtr, null, true);
                ((AssetService)RpcServiceManager.get().getService(AssetService.class)).save(ServiceInvocationContext.get(), (BaseAsset)sysLogItem);
                EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(notificationCtr.toReference(), EntityModification.ModificationType.CHANGE)));
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
            cdl.countDown();
        }, Messages.Notification_processing);
    }
}

