/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.notifications;

import com.gridnine.xtrip.client.fx.core.registry.basic.AppStartHook;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.notifications.EventNotificationDialog;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.EventNotification;
import com.gridnine.xtrip.common.model.system.EventNotificationIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class EventNotificationsAppStartHook
implements AppStartHook {
    public double getWeight() {
        return 150.0;
    }

    public String getId() {
        return "event-notification-scheduler";
    }

    public void execute() {
        try {
            long period = 60000L;
            long delay = 60000L;
            Notifications.get().getScheduler().scheduleWithFixedDelay(this::processNotifications, delay, period, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    private synchronized void processNotifications() {
        if (!Prefetched.getData().isNotificationsEnabled()) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)EventNotificationIndex.Property.active.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)EventNotificationIndex.Property.viewingDate.name(), (Object)new Date()));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)EventNotificationIndex.Property.recipientLogins.name(), (Object)ServiceInvocationContext.get().getUser()));
        try {
            EntityService es = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            for (EventNotificationIndex idx : es.search(ServiceInvocationContext.get(), EventNotificationIndex.class, query)) {
                EntityContainer ctr = es.load(ServiceInvocationContext.get(), idx.getSource());
                if (ctr == null) continue;
                CountDownLatch cdl = new CountDownLatch(1);
                EventNotificationDialog.show((EntityContainer<EventNotification>)ctr, cdl);
                cdl.await();
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }
}

