/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.restriction;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.grouptable.GroupTableItem;
import com.gridnine.xtrip.client.fx.core.lib.widgets.grouptable.GroupTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.grouptable.GroupTableWidgetRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.property.PropertyRendererWidget;
import com.gridnine.xtrip.client.fx.core.property.PropertyRendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.property.ValueRenderer;
import com.gridnine.xtrip.client.fx.core.property.ValueRendererRegistryItem;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.custom.restrictions.RestrictionsData;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.RestrictionGroupType;
import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyDynamicValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class RestrictionsWidget
extends CustomWidget<RestrictionsData>
implements DevTool {
    private final GroupTableWidget.GroupHandler<RestrictionGroupType> restrictionGroupHandler = new GroupTableWidget.GroupHandler<RestrictionGroupType>(){

        public String getName(RestrictionGroupType group) {
            if (group == RestrictionGroupType.SIMPLE) {
                return Messages.Simple_Condition;
            }
            if (group == RestrictionGroupType.NOT) {
                return Messages.Logical_NOT;
            }
            if (group == RestrictionGroupType.AND) {
                return Messages.Logical_AND;
            }
            if (group == RestrictionGroupType.OR) {
                return Messages.Logical_OR;
            }
            return group.getName();
        }

        public IconShape getGroupShape(RestrictionGroupType group) {
            if (group == RestrictionGroupType.SIMPLE) {
                return StandardIconShapes.UNDEFINED;
            }
            if (group == RestrictionGroupType.NOT) {
                return StandardIconShapes.NOT_22X14;
            }
            if (group == RestrictionGroupType.AND) {
                return StandardIconShapes.AND_22X14;
            }
            if (group == RestrictionGroupType.OR) {
                return StandardIconShapes.OR_22X14;
            }
            return StandardIconShapes.UNDEFINED;
        }

        public IconShape getMenuShape(RestrictionGroupType group) {
            if (group == RestrictionGroupType.SIMPLE) {
                return StandardIconShapes.UNDEFINED;
            }
            if (group == RestrictionGroupType.NOT) {
                return StandardIconShapes.NOT_14X14;
            }
            if (group == RestrictionGroupType.AND) {
                return StandardIconShapes.AND_14X14;
            }
            if (group == RestrictionGroupType.OR) {
                return StandardIconShapes.OR_14X14;
            }
            return StandardIconShapes.UNDEFINED;
        }

        public boolean isSimple(RestrictionGroupType group) {
            return group == RestrictionGroupType.SIMPLE;
        }

        public boolean isHidden(RestrictionGroupType group) {
            return group == RestrictionGroupType.SIMPLE;
        }

        public Supplier<List<RestrictionGroupType>> getSupplier() {
            return Suppliers.createEnumSupplier(RestrictionGroupType.class);
        }
    };
    private GroupTableWidget<RestrictionGroupType, RestrictionValueWrapper> table;
    private ComboBoxWidgetColumn<RestrictionValueWrapper, RestrictionResource> resourceColumn;
    private ComboBoxWidgetColumn<RestrictionValueWrapper, RestrictionResourceProperty> propertyColumn;
    private ComboBoxWidgetColumn<RestrictionValueWrapper, RestrictionResourcePropertyCondition> conditionColumn;
    private ComboBoxWidgetColumn<RestrictionValueWrapper, RestrictionValueType> typeColumn;
    private PropertyRendererWidgetColumn<RestrictionValueWrapper> valueColumn;
    protected final StringProperty restrictionId = new SimpleStringProperty();
    protected final ObjectProperty<RestrictionResourcesRegistry> registry = new SimpleObjectProperty((Object)RestrictionResourcesRegistry.get());
    protected final ObjectProperty<Supplier<Collection<RestrictionResourcePropertyDynamicValueHandler>>> dynamicValueHandlersSupplier = new SimpleObjectProperty(() -> Collections.emptyList());
    private final boolean showResourceColumn;
    private final boolean showSystemProperties;

    public RestrictionsWidget(boolean showResourceColumn, boolean readonly) {
        this(showResourceColumn, false, readonly);
    }

    public RestrictionsWidget(boolean showResourceColumn, boolean showSystemProperties, boolean readonly) {
        this.showResourceColumn = showResourceColumn;
        this.showSystemProperties = showSystemProperties;
        this.createGUI(readonly);
        this.createBindings();
        this.createListeners();
    }

    private void createGUI(boolean readonly) {
        this.table = new GroupTableWidget(readonly);
        this.table.setValueFactory(() -> new RestrictionValueWrapper());
        this.table.setGroupHandler(this.restrictionGroupHandler);
        ArrayList<Object> restrictionColumns = new ArrayList<Object>();
        if (this.showResourceColumn) {
            this.resourceColumn = new ComboBoxWidgetColumn(wrapper -> wrapper.resource, (wrapper, value) -> {
                wrapper.resource = value;
            });
            this.resourceColumn.setNoNulls(true);
            this.resourceColumn.setItemsSupplier(() -> Collections.emptyList());
            this.resourceColumn.setConverter((StringConverter)new StringConverter<RestrictionResource>(){

                public String toString(RestrictionResource object) {
                    return object != null ? object.getName() : (RestrictionsWidget.this.table.getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT);
                }

                public RestrictionResource fromString(String string) {
                    return null;
                }
            });
            this.resourceColumn.setCaption(Messages.Widget_Resource);
            this.resourceColumn.setId("resource");
            this.resourceColumn.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(this.resourceColumn.getConverter(), () -> (List)this.resourceColumn.getItemsSupplier().get(), this.resourceColumn.isSortItems()));
            restrictionColumns.add(this.resourceColumn);
        }
        this.propertyColumn = new ComboBoxWidgetColumn(wrapper -> wrapper.property, (wrapper, value) -> {
            wrapper.property = value;
        });
        this.propertyColumn.setNoNulls(true);
        this.propertyColumn.setItemsSupplier(() -> Collections.emptyList());
        this.propertyColumn.setConverter((StringConverter)new StringConverter<RestrictionResourceProperty>(){

            public String toString(RestrictionResourceProperty object) {
                return object != null ? object.getName() : (RestrictionsWidget.this.table.getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT);
            }

            public RestrictionResourceProperty fromString(String string) {
                return null;
            }
        });
        this.propertyColumn.setCaption(Messages.Widget_Field);
        this.propertyColumn.setId("property");
        this.propertyColumn.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(this.propertyColumn.getConverter(), () -> (List)this.propertyColumn.getItemsSupplier().get(), this.propertyColumn.isSortItems()));
        restrictionColumns.add(this.propertyColumn);
        this.conditionColumn = new ComboBoxWidgetColumn(wrapper -> wrapper.condition, (wrapper, value) -> {
            wrapper.condition = value;
        });
        this.conditionColumn.setNoNulls(true);
        this.conditionColumn.setItemsSupplier(() -> Collections.emptyList());
        this.conditionColumn.setConverter((StringConverter)new StringConverter<RestrictionResourcePropertyCondition>(){

            public String toString(RestrictionResourcePropertyCondition object) {
                return object != null ? object.getName() : (RestrictionsWidget.this.table.getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT);
            }

            public RestrictionResourcePropertyCondition fromString(String string) {
                return null;
            }
        });
        this.conditionColumn.setCaption(Messages.Condition);
        this.conditionColumn.setId("condition");
        this.conditionColumn.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(this.conditionColumn.getConverter(), () -> (List)this.conditionColumn.getItemsSupplier().get(), this.conditionColumn.isSortItems()));
        restrictionColumns.add(this.conditionColumn);
        this.typeColumn = new ComboBoxWidgetColumn(wrapper -> wrapper.type, (wrapper, value) -> {
            wrapper.type = value;
        });
        this.typeColumn.setNoNulls(true);
        this.typeColumn.setItemsSupplier(() -> Collections.emptyList());
        this.typeColumn.setConverter((StringConverter)new StringConverter<RestrictionValueType>(){

            public String toString(RestrictionValueType object) {
                return object != null ? object.toString() : (RestrictionsWidget.this.table.getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT);
            }

            public RestrictionValueType fromString(String string) {
                return null;
            }
        });
        this.typeColumn.setCaption(Messages.Type);
        this.typeColumn.setId("type");
        this.typeColumn.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(this.typeColumn.getConverter(), () -> (List)this.typeColumn.getItemsSupplier().get(), this.typeColumn.isSortItems()));
        restrictionColumns.add(this.typeColumn);
        this.valueColumn = new PropertyRendererWidgetColumn(wrapper -> wrapper.value, (wrapper, value) -> {
            wrapper.value = value;
        });
        this.valueColumn.setCaption(Messages.Value_text);
        this.valueColumn.setId("value");
        this.valueColumn.setPrefWidthEm(Double.valueOf(40.0));
        restrictionColumns.add(this.valueColumn);
        this.table.setColumns(restrictionColumns);
        this.getChildren().setAll((Object[])new Node[]{this.table});
    }

    private void createBindings() {
    }

    private void createListeners() {
        this.restrictionId.addListener((observable, oldValue, newValue) -> {
            this.table.readData(Collections.emptyList());
            if (this.showResourceColumn) {
                RestrictionResource resource;
                ArrayList<RestrictionResource> resources = new ArrayList<RestrictionResource>();
                RestrictionResource restrictionResource = resource = newValue != null && this.getRegistry() != null ? this.getRegistry().getResource(newValue) : null;
                while (resource != null) {
                    if (!this.getRegistry().getResourceProperties(resource.getId()).isEmpty()) {
                        resources.add(resource);
                    }
                    resource = this.getRegistry().getResource(resource.getParentId());
                }
                this.resourceColumn.setItemsSupplier(() -> resources.stream().filter(value -> value != null).sorted((value1, value2) -> MiscUtil.compare((Comparable)((Object)value1.getName()), (Comparable)((Object)value2.getName()))).collect(Collectors.toList()));
            } else {
                this.propertyColumn.setItemsSupplier(() -> {
                    if (newValue == null || this.getRegistry() == null) {
                        return Collections.emptyList();
                    }
                    return this.getRegistry().getResourceProperties(newValue).stream().map(value -> this.getRegistry().getProperty(value)).filter(value -> value != null).filter(value -> this.showSystemProperties || !value.isSystem()).sorted((value1, value2) -> MiscUtil.compare((Comparable)((Object)value1.getName()), (Comparable)((Object)value2.getName()))).collect(Collectors.toList());
                });
            }
        });
        this.registry.addListener((observable, oldValue, newValue) -> {
            this.table.readData(Collections.emptyList());
            if (this.showResourceColumn) {
                RestrictionResource resource;
                ArrayList<RestrictionResource> resources = new ArrayList<RestrictionResource>();
                RestrictionResource restrictionResource = resource = newValue != null && this.getRestrictionId() != null ? newValue.getResource(this.getRestrictionId()) : null;
                while (resource != null) {
                    if (!newValue.getResourceProperties(resource.getId()).isEmpty()) {
                        resources.add(resource);
                    }
                    resource = newValue.getResource(resource.getParentId());
                }
                this.resourceColumn.setItemsSupplier(() -> resources.stream().filter(value -> value != null).sorted((value1, value2) -> MiscUtil.compare((Comparable)((Object)value1.getName()), (Comparable)((Object)value2.getName()))).collect(Collectors.toList()));
            } else {
                this.propertyColumn.setItemsSupplier(() -> newValue != null && this.getRestrictionId() != null ? newValue.getResourceProperties(this.getRestrictionId()).stream().map(value -> newValue.getProperty(value)).filter(value -> value != null).sorted((value1, value2) -> MiscUtil.compare((Comparable)((Object)value1.getName()), (Comparable)((Object)value2.getName()))).collect(Collectors.toList()) : Collections.emptyList());
            }
        });
        this.table.setOnRowsAction(event -> {
            if (event.getEventType() != GroupTableWidgetRowEvent.ROW_ADD) {
                return;
            }
            ComboBoxWidget resourceComboBox = this.showResourceColumn ? (ComboBoxWidget)event.getWidget(this.resourceColumn) : null;
            ComboBoxWidget propertyComboBox = (ComboBoxWidget)event.getWidget(this.propertyColumn);
            ComboBoxWidget conditionComboBox = (ComboBoxWidget)event.getWidget(this.conditionColumn);
            ComboBoxWidget typeComboBox = (ComboBoxWidget)event.getWidget(this.typeColumn);
            PropertyRendererWidget valueRenderer = (PropertyRendererWidget)event.getWidget(this.valueColumn);
            if (this.showResourceColumn) {
                propertyComboBox.setLive(true);
            }
            conditionComboBox.setLive(true);
            typeComboBox.setLive(true);
            if (this.showResourceColumn) {
                propertyComboBox.setVisible(false);
            }
            conditionComboBox.setVisible(false);
            typeComboBox.setVisible(false);
            valueRenderer.setVisible(false);
            if (this.showResourceColumn) {
                resourceComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
                    propertyComboBox.setVisible(newValue != null);
                    propertyComboBox.setItemsSupplier(() -> newValue != null && this.getRegistry() != null ? this.getRegistry().getResourceProperties(newValue.getId()).stream().map(value -> this.getRegistry().getProperty(value)).filter(value -> value != null).sorted((value1, value2) -> MiscUtil.compare((Comparable)((Object)value1.getName()), (Comparable)((Object)value2.getName()))).collect(Collectors.toList()) : Collections.emptyList());
                    propertyComboBox.setValue(null);
                });
            }
            propertyComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
                conditionComboBox.setVisible(newValue != null);
                conditionComboBox.setItemsSupplier(() -> newValue != null && this.getRegistry() != null ? this.getRegistry().getPropertyConditions(newValue.getId()).stream().map(value -> this.getRegistry().getCondition(value)).filter(value -> value != null).sorted((value1, value2) -> MiscUtil.compare((Comparable)((Object)value1.getName()), (Comparable)((Object)value2.getName()))).collect(Collectors.toList()) : Collections.emptyList());
                conditionComboBox.setValue(null);
            });
            conditionComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
                typeComboBox.setVisible(newValue != null && newValue.hasRightSide());
                RestrictionResourceProperty property = (RestrictionResourceProperty)propertyComboBox.getValue();
                typeComboBox.setItemsSupplier(() -> {
                    if (newValue != null && newValue.hasRightSide() && this.getRegistry() != null) {
                        ArrayList<RestrictionValueType> types = new ArrayList<RestrictionValueType>();
                        types.add(RestrictionValueType.SIMPLE);
                        if (Stream.concat(this.getRegistry().getDynamicValueHandlers().stream(), this.getDynamicValueHandlersSupplier().get().stream()).anyMatch(item -> item.getCategoryId().equals(property.getCategoryId()) && item.getConditionIds(property).contains(newValue.getId()))) {
                            types.add(RestrictionValueType.DYNAMIC);
                        }
                        return types;
                    }
                    return Collections.emptyList();
                });
                typeComboBox.setValue(null);
            });
            typeComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
                valueRenderer.setVisible(newValue != null);
                RestrictionResourceProperty property = (RestrictionResourceProperty)propertyComboBox.getValue();
                RestrictionResourcePropertyCondition condition = (RestrictionResourcePropertyCondition)conditionComboBox.getValue();
                if (newValue == RestrictionValueType.SIMPLE) {
                    String handlerId = this.getRegistry().getPropertyConditionValueHandler(property.getId(), condition.getId());
                    valueRenderer.setRenderer(condition.hasRightSide() ? ValueRendererRegistryItem.forId((String)this.getRegistry().getValueHandler(handlerId).getRendererId(property, condition.getId())) : null, property.getType());
                } else if (newValue == RestrictionValueType.DYNAMIC) {
                    valueRenderer.setRenderer(condition.hasRightSide() ? this.createRenderer(property, condition.getId(), Stream.concat(this.getRegistry().getDynamicValueHandlers().stream(), this.getDynamicValueHandlersSupplier().get().stream()).filter(item -> item.getCategoryId().equals(property.getCategoryId()) && item.getConditionIds(property).contains(condition.getId())).collect(Collectors.toList())) : null, property.getType());
                } else {
                    valueRenderer.setRenderer(null, null);
                }
                valueRenderer.setValue(null);
            });
        });
    }

    private ValueRenderer createRenderer(final RestrictionResourceProperty propertry, final String conditionId, final List<RestrictionResourcePropertyDynamicValueHandler> values) {
        return new ValueRenderer(){

            public String getCategoryId() {
                return "";
            }

            public Node createNode(Class<?> type) {
                final ComboBoxWidget dynamicValuesComboBox = new ComboBoxWidget(false);
                dynamicValuesComboBox.setItemsSupplier(() -> values);
                dynamicValuesComboBox.setConverter((StringConverter)new StringConverter<RestrictionResourcePropertyDynamicValueHandler>(){

                    public String toString(RestrictionResourcePropertyDynamicValueHandler object) {
                        return object != null ? object.getName() : (dynamicValuesComboBox.getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT);
                    }

                    public RestrictionResourcePropertyDynamicValueHandler fromString(String string) {
                        return null;
                    }
                });
                dynamicValuesComboBox.setNoNulls(true);
                PropertyRendererWidget parametersRenderer = new PropertyRendererWidget();
                UiUtil.setHidden((Node)parametersRenderer, (boolean)true);
                dynamicValuesComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
                    parametersRenderer.setRenderer(newValue != null && newValue.hasParameters() ? ValueRendererRegistryItem.forId((String)newValue.getRendererId(propertry, conditionId)) : null, Object.class);
                    UiUtil.setHidden((Node)parametersRenderer, (newValue == null || !newValue.hasParameters() ? 1 : 0) != 0);
                });
                GridPane node = new GridPane();
                node.getStyleClass().add((Object)"grid-cell");
                UiUtil.gridPosition((GridPane)node, (Node)dynamicValuesComboBox).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
                UiUtil.gridPosition((GridPane)node, (Node)parametersRenderer).col(1).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
                return node;
            }

            public Object getValue(Node node) {
                if (node == null) {
                    return null;
                }
                RestrictionValue.DynamicValue value = new RestrictionValue.DynamicValue();
                value.setHandlerId(((ComboBoxWidget)((GridPane)node).getChildren().get(0)).getValue() != null ? ((RestrictionResourcePropertyDynamicValueHandler)((ComboBoxWidget)((GridPane)node).getChildren().get(0)).getValue()).getId() : null);
                value.setParameters(((PropertyRendererWidget)((GridPane)node).getChildren().get(1)).getValue());
                return value;
            }

            public void setValue(Node node, Object value) {
                if (node == null) {
                    return;
                }
                ((ComboBoxWidget)((GridPane)node).getChildren().get(0)).setValue(value != null && RestrictionsWidget.this.getRegistry() != null ? (RestrictionResourcePropertyDynamicValueHandler)Stream.concat(RestrictionsWidget.this.getRegistry().getDynamicValueHandlers().stream(), RestrictionsWidget.this.getDynamicValueHandlersSupplier().get().stream()).filter(item -> MiscUtil.equals((Object)item.getId(), (Object)((RestrictionValue.DynamicValue)value).getHandlerId())).findFirst().orElse(null) : null);
                ((PropertyRendererWidget)((GridPane)node).getChildren().get(1)).setValue(value != null ? ((RestrictionValue.DynamicValue)value).getParameters() : null);
            }

            public void setEditable(Node node, boolean editable) {
                if (node == null) {
                    return;
                }
                ((ComboBoxWidget)((GridPane)node).getChildren().get(0)).getViewState().setReadonly(!editable);
                ((PropertyRendererWidget)((GridPane)node).getChildren().get(1)).setReadonly(!editable);
            }

            public boolean isValueEmpty(Node node) {
                if (node == null) {
                    return true;
                }
                return ((ComboBoxWidget)((GridPane)node).getChildren().get(0)).getValue() == null || ((PropertyRendererWidget)((GridPane)node).getChildren().get(1)).getValue() == null;
            }
        };
    }

    private Collection<RestrictionGroup> toRestrictionGroups(Collection<GroupTableItem<RestrictionGroupType, RestrictionValueWrapper>> restrictionGroupItems) {
        ArrayList<RestrictionGroup> restrictionGroups = new ArrayList<RestrictionGroup>();
        for (GroupTableItem<RestrictionGroupType, RestrictionValueWrapper> restrictionGroupItem : restrictionGroupItems) {
            RestrictionGroup restrictionGroup = new RestrictionGroup();
            restrictionGroup.setType((RestrictionGroupType)restrictionGroupItem.getGroup());
            if (restrictionGroupItem.getGroup() != null) {
                if (this.restrictionGroupHandler.isSimple(restrictionGroupItem.getGroup())) {
                    RestrictionValue restrictionValue = new RestrictionValue();
                    restrictionValue.setPropertyId(((RestrictionValueWrapper)restrictionGroupItem.getValue()).property != null ? ((RestrictionValueWrapper)restrictionGroupItem.getValue()).property.getId() : null);
                    restrictionValue.setConditionId(((RestrictionValueWrapper)restrictionGroupItem.getValue()).condition != null ? ((RestrictionValueWrapper)restrictionGroupItem.getValue()).condition.getId() : null);
                    RestrictionResourceProperty property = ((RestrictionValueWrapper)restrictionGroupItem.getValue()).property;
                    Object value = ((RestrictionValueWrapper)restrictionGroupItem.getValue()).value;
                    if (value != null && RestrictionValue.DynamicValue.class.isAssignableFrom(value.getClass())) {
                        restrictionValue.setValue(((RestrictionValueWrapper)restrictionGroupItem.getValue()).value);
                    } else if (property != null && value != null && Date.class.isAssignableFrom(property.getType())) {
                        if (Pair.class.isAssignableFrom(value.getClass())) {
                            if (property.isTimeIncluded()) {
                                restrictionValue.setValue((Object)new DateInterval(DateUtils.asDate((LocalDateTime)((LocalDateTime)((Pair)((RestrictionValueWrapper)restrictionGroupItem.getValue()).value).getFirst())), DateUtils.asDate((LocalDateTime)((LocalDateTime)((Pair)((RestrictionValueWrapper)restrictionGroupItem.getValue()).value).getLast()))));
                            } else {
                                restrictionValue.setValue((Object)new DateInterval(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)((LocalDate)((Pair)((RestrictionValueWrapper)restrictionGroupItem.getValue()).value).getFirst()))), MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)((LocalDate)((Pair)((RestrictionValueWrapper)restrictionGroupItem.getValue()).value).getLast())))));
                            }
                        } else if (property.isTimeIncluded()) {
                            restrictionValue.setValue((Object)DateUtils.asDate((LocalDateTime)((LocalDateTime)((RestrictionValueWrapper)restrictionGroupItem.getValue()).value)));
                        } else {
                            restrictionValue.setValue((Object)DateUtils.asDate((LocalDate)((LocalDate)((RestrictionValueWrapper)restrictionGroupItem.getValue()).value)));
                        }
                    } else {
                        restrictionValue.setValue(((RestrictionValueWrapper)restrictionGroupItem.getValue()).value);
                    }
                    restrictionGroup.setValue((Object)restrictionValue);
                } else {
                    restrictionGroup.setValue(this.toRestrictionGroups((Collection<GroupTableItem<RestrictionGroupType, RestrictionValueWrapper>>)restrictionGroupItem.getChildren()));
                }
            }
            restrictionGroups.add(restrictionGroup);
        }
        RestrictionsHelper.cleanRestrictions(restrictionGroups, RestrictionsHelper::isConsistent);
        return restrictionGroups;
    }

    private Collection<GroupTableItem<RestrictionGroupType, RestrictionValueWrapper>> toRestrictionGroupItems(Collection<RestrictionGroup> restrictionGroups) {
        RestrictionsHelper.cleanRestrictions(restrictionGroups, RestrictionsHelper::isConsistent);
        ArrayList<GroupTableItem<RestrictionGroupType, RestrictionValueWrapper>> restrictionGroupItems = new ArrayList<GroupTableItem<RestrictionGroupType, RestrictionValueWrapper>>();
        for (RestrictionGroup restrictionGroup : restrictionGroups) {
            if (restrictionGroup == null) continue;
            GroupTableItem restrictionGroupItem = new GroupTableItem();
            restrictionGroupItem.setGroup((Object)restrictionGroup.getType());
            if (this.restrictionGroupHandler.isSimple((Object)restrictionGroup.getType())) {
                RestrictionValueWrapper valueWrapper = new RestrictionValueWrapper();
                RestrictionValue restrictionValue = (RestrictionValue)restrictionGroup.getValue();
                if (this.showResourceColumn) {
                    valueWrapper.resource = this.getRegistry().getProperty(restrictionValue.getPropertyId()) != null ? this.getRegistry().getResource(this.getRegistry().getProperty(restrictionValue.getPropertyId()).getResourceId()) : null;
                }
                valueWrapper.property = this.getRegistry().getProperty(restrictionValue.getPropertyId());
                valueWrapper.condition = this.getRegistry().getCondition(restrictionValue.getConditionId());
                RestrictionResourceProperty property = this.getRegistry().getProperty(restrictionValue.getPropertyId());
                Object value = restrictionValue.getValue();
                if (value != null && RestrictionValue.DynamicValue.class.isAssignableFrom(value.getClass())) {
                    valueWrapper.type = RestrictionValueType.DYNAMIC;
                    valueWrapper.value = restrictionValue.getValue();
                } else {
                    valueWrapper.type = RestrictionValueType.SIMPLE;
                    valueWrapper.value = property != null && value != null && Date.class.isAssignableFrom(property.getType()) ? (DateInterval.class.isAssignableFrom(value.getClass()) ? (property.isTimeIncluded() ? new Pair((Object)DateUtils.asLocalDateTime((Date)((DateInterval)restrictionValue.getValue()).getBeginDate()), (Object)DateUtils.asLocalDateTime((Date)((DateInterval)restrictionValue.getValue()).getEndDate())) : new Pair((Object)DateUtils.asLocalDate((Date)MiscUtil.clearTime((Date)((DateInterval)restrictionValue.getValue()).getBeginDate())), (Object)DateUtils.asLocalDate((Date)MiscUtil.setDayEndTime((Date)((DateInterval)restrictionValue.getValue()).getEndDate())))) : (property.isTimeIncluded() ? DateUtils.asLocalDateTime((Date)((Date)restrictionValue.getValue())) : DateUtils.asLocalDate((Date)((Date)restrictionValue.getValue())))) : restrictionValue.getValue();
                }
                restrictionGroupItem.setValue((Object)valueWrapper);
            } else {
                restrictionGroupItem.getChildren().addAll(this.toRestrictionGroupItems((List)restrictionGroup.getValue()));
            }
            restrictionGroupItems.add((GroupTableItem<RestrictionGroupType, RestrictionValueWrapper>)restrictionGroupItem);
        }
        return restrictionGroupItems;
    }

    public void setRestrictionId(String value) {
        this.restrictionId.set((Object)value);
    }

    public String getRestrictionId() {
        return (String)this.restrictionId.get();
    }

    public void setRegistry(RestrictionResourcesRegistry value) {
        this.registry.set((Object)value);
    }

    public RestrictionResourcesRegistry getRegistry() {
        return (RestrictionResourcesRegistry)this.registry.get();
    }

    public void setDynamicValueHandlersSupplier(Supplier<Collection<RestrictionResourcePropertyDynamicValueHandler>> value) {
        this.dynamicValueHandlersSupplier.set(value);
    }

    public Supplier<Collection<RestrictionResourcePropertyDynamicValueHandler>> getDynamicValueHandlersSupplier() {
        return (Supplier)this.dynamicValueHandlersSupplier.get();
    }

    public void setFieldName(String value) {
    }

    public ViewState getViewState() {
        return this.table.getViewState();
    }

    public void readData(RestrictionsData restrictionsData) {
        this.setRestrictionId(restrictionsData.getRestrictionId());
        Collection<GroupTableItem<RestrictionGroupType, RestrictionValueWrapper>> restrictionGroupItems = this.toRestrictionGroupItems(restrictionsData.getRestrictions());
        this.table.readData(restrictionGroupItems);
    }

    public void writeData(RestrictionsData restrictionsData) {
        restrictionsData.setRestrictionId(this.getRestrictionId());
        ArrayList<GroupTableItem<RestrictionGroupType, RestrictionValueWrapper>> restrictionGroupItems = new ArrayList<GroupTableItem<RestrictionGroupType, RestrictionValueWrapper>>();
        this.table.writeData(restrictionGroupItems);
        restrictionsData.getRestrictions().clear();
        restrictionsData.getRestrictions().addAll(this.toRestrictionGroups(restrictionGroupItems));
    }

    public boolean isDataChanged() {
        return this.table.isDataChanged();
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(RestrictionsWidget.this.table);
            }

            public String getInfo() {
                return ((Object)((Object)RestrictionsWidget.this)).getClass().getSimpleName();
            }
        };
    }

    public static enum RestrictionValueType {
        SIMPLE{

            public String toString() {
                return Messages.Simple;
            }
        }
        ,
        DYNAMIC{

            public String toString() {
                return Messages.Dynamic;
            }
        };

    }

    private static class RestrictionValueWrapper {
        RestrictionResource resource;
        RestrictionResourceProperty property;
        RestrictionResourcePropertyCondition condition;
        RestrictionValueType type;
        Object value;

        private RestrictionValueWrapper() {
        }

        public String toString() {
            return (this.resource != null ? this.resource.getId() : "?") + " | " + (this.property != null ? this.property.getId() : "?") + " | " + (this.condition != null ? this.condition.getId() : "?") + " | " + (this.type != null ? this.type.name() : "?") + " | " + (this.value != null ? this.value.toString() : "?");
        }
    }
}

