/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.ActionLabelRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RestrictionLabelRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleActionRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRendererFactory;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleActionRenderers;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleValueRenderers;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;

public class BaseRulesTablePane
extends StackPane {
    protected RuleValueRenderer findRenderer(RuleProperty property, RuleCondition condition) {
        if (property == null || condition != null && !condition.hasRightSide()) {
            return StandardRuleValueRenderers.NULL;
        }
        RuleValueRendererFactory factory = RuleValueRendererFactory.forId(property.getId());
        if (factory != null) {
            return factory.createRenderer(condition);
        }
        RuleValueRenderer renderer = RuleValueRenderer.forId(property.getRendererId());
        if (renderer != null) {
            return renderer;
        }
        return new RestrictionLabelRenderer(String.format("no renderer with ID %s found for property %s", property.getRendererId(), property.getId()));
    }

    protected static RuleActionRenderer findRenderer(RuleAction action) {
        if (action != null) {
            RuleActionRenderer renderer = RuleActionRenderer.forId(action.getRendererId());
            if (renderer != null) {
                return renderer;
            }
            return new ActionLabelRenderer(String.format("no renderer with ID %s found for action %s", action.getRendererId(), action.getId()));
        }
        return StandardRuleActionRenderers.NULL;
    }

    protected <M> ViewController<InnerTableView, M> createExpandableViewController() {
        final InnerTableView view = new InnerTableView();
        ViewController vc = new ViewController<InnerTableView, M>(){
            private M data;

            public InnerTableView getView() {
                return view;
            }

            public M getData() {
                return this.data;
            }

            public void readData(M model) {
                this.data = model;
                this.getView().afterReadData();
            }

            public void writeData(M model) {
                this.data = model;
                this.getView().afterWriteData();
            }

            public boolean isReadonly() {
                return this.getView().isReadonly();
            }

            public void setReadonly(boolean readonly) {
                this.getView().setReadonly(readonly);
            }

            public void setNotEditable(boolean notEditable) {
                this.getView().setNotEditable(notEditable);
            }

            public void setAclNotEditable(boolean aclNotEditable) {
                this.getView().setAclNotEditable(aclNotEditable);
            }

            public boolean isDataChanged() {
                return this.getView().isDataChanged();
            }

            public void validateData(List<Message> messages) {
            }
        };
        return vc;
    }

    static class InnerTableView
    extends BorderPane
    implements DevTool {
        private TableWidget<?> tableWidget;
        private boolean readonly = false;
        private boolean notEditable = false;
        private boolean aclNotEditable = false;
        private boolean changed = false;

        InnerTableView() {
        }

        void afterReadData() {
            this.changed = false;
        }

        void afterWriteData() {
            this.changed = false;
        }

        boolean isReadonly() {
            return this.readonly;
        }

        void setReadonly(boolean value) {
            this.readonly = value;
            if (this.tableWidget != null) {
                this.tableWidget.getViewState().setReadonly(this.readonly);
            }
        }

        void setNotEditable(boolean value) {
            this.notEditable = value;
            if (this.tableWidget != null) {
                this.tableWidget.getViewState().setNotEditable(this.notEditable);
            }
        }

        void setAclNotEditable(boolean value) {
            this.aclNotEditable = value;
            if (this.tableWidget != null) {
                this.tableWidget.getViewState().setAclNotEditable(this.aclNotEditable);
            }
        }

        boolean isDataChanged() {
            return this.changed;
        }

        void setInnerTable(TableWidget<?> table) {
            this.tableWidget = table;
            if (this.tableWidget != null) {
                this.tableWidget.getViewState().setReadonly(this.readonly);
                this.tableWidget.getViewState().setNotEditable(this.notEditable);
                this.tableWidget.getViewState().setAclNotEditable(this.aclNotEditable);
                this.setCenter((Node)this.tableWidget);
                this.changed = false;
                this.tableWidget.setOnRowsAction(e -> {
                    this.changed = true;
                });
            } else {
                this.getChildren().clear();
            }
        }

        public DevToolItem asDevToolItem() {
            return new DevToolItem(){

                public Collection<?> getSubItems() {
                    if (tableWidget != null) {
                        return Collections.singleton(tableWidget);
                    }
                    return Collections.emptyList();
                }

                public String getInfo() {
                    return ((Object)((Object)this)).getClass().getSimpleName();
                }
            };
        }
    }
}

