/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.RuleParametersHandler;
import com.gridnine.xtrip.common.rules.RuleSettings;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;

public final class StandardRuleParameters {
    public static final RuleParametersHandler<BasicParametersPane> BASIC_HANDLER = new RuleParametersHandler<BasicParametersPane>(){

        @Override
        public BasicParametersPane createNode() {
            return new BasicParametersPane();
        }

        @Override
        public void readData(RuleSettings model, BasicParametersPane node) {
            node.readData(model);
        }

        @Override
        public void writeData(RuleSettings model, BasicParametersPane node) {
            node.writeData(model);
        }

        @Override
        public void setReadonly(boolean readonly, BasicParametersPane node) {
            node.setReadonly(readonly);
        }
    };

    private StandardRuleParameters() {
    }

    public static class BasicParametersPane
    extends GridContainer {
        private final TextFieldWidget nameWidget = new TextFieldWidget(false);
        private final DateValueWidget beginDateWidget = new DateValueWidget(false);
        private final DateValueWidget endDateWidget = new DateValueWidget(false);
        private final CheckBoxWidget ignoreOnExportWidget = new CheckBoxWidget(false);
        private final CheckBoxWidget preserveOnImportWidget = new CheckBoxWidget(false);
        private final InfoLabelWidget infoWidget = new InfoLabelWidget();

        protected BasicParametersPane() {
            super(3);
            this.ignoreOnExportWidget.setText(Messages.Do_not_export);
            this.preserveOnImportWidget.setText(Messages.Do_not_change_when_importing);
            ArrayList cells = new ArrayList();
            this.createCells(cells);
            this.getCells().addAll(cells);
        }

        protected void createCells(List<GridCell<?>> cells) {
            cells.add(new GridCell(Messages.Name, (Node)this.nameWidget));
            cells.add(new GridCell(Messages.Start_of_action, (Node)this.beginDateWidget));
            cells.add(new GridCell(Messages.Expiration, (Node)this.endDateWidget));
            cells.add(new GridCell((Node)this.ignoreOnExportWidget));
            cells.add(new GridCell((Node)this.preserveOnImportWidget));
            GridCell cell = new GridCell((Node)this.infoWidget);
            cell.setColSpan(Integer.MAX_VALUE);
            cells.add(cell);
        }

        protected void readData(RuleSettings model) {
            this.nameWidget.setValue(model.getName());
            this.beginDateWidget.setValue(DateUtils.asLocalDate((Date)model.getPeriodBegin()));
            this.endDateWidget.setValue(DateUtils.asLocalDate((Date)model.getPeriodEnd()));
            this.ignoreOnExportWidget.setSelected(model.isIgnoreOnExport());
            this.preserveOnImportWidget.setSelected(model.isPreserveOnImport());
            this.infoWidget.setText(model.getAttributes().entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).collect(Collectors.joining(";")));
        }

        protected void writeData(RuleSettings model) {
            model.setName(this.nameWidget.getValue());
            model.setPeriodBegin(DateUtils.asDate((LocalDate)this.beginDateWidget.getValue()));
            model.setPeriodEnd(DateUtils.asDate(this.endDateWidget.getValue() != null ? this.endDateWidget.getValue().atTime(LocalTime.MAX) : null));
            model.setIgnoreOnExport(this.ignoreOnExportWidget.isSelected());
            model.setPreserveOnImport(this.preserveOnImportWidget.isSelected());
        }

        protected void setReadonly(boolean value) {
            this.nameWidget.getViewState().setReadonly(value);
            this.beginDateWidget.getViewState().setReadonly(value);
            this.endDateWidget.getViewState().setReadonly(value);
            this.ignoreOnExportWidget.getViewState().setReadonly(value);
            this.preserveOnImportWidget.getViewState().setReadonly(value);
        }
    }
}

