/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.exchange;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.RulesImportProperties;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.rules.standard.RuleAttributes;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;

public class ImportRulesConflictDialog {
    private RulesImportProperties.UserAction userAction;
    private boolean forAll = false;
    private DialogResult dialogResult = DialogResult.CONTINUE_CHECKING;
    private final Label coincTypeLabel = new Label(Messages.ConflictDialog_Conflict_Type);
    private final Label coincTypeTextLabel = new Label(Messages.Type);
    private final Label curRuleLabel = new Label(Messages.ConflictDialog_Current_rule);
    private final Label curRuleStatusLabel = new Label(Messages.ConflictDialog_Previous_Status);
    private final Label curRuleTextLabel = new Label(Messages.ConflictDialog_Rule_Text);
    private final Label newRuleLabel = new Label(Messages.ConflictDialog_New_Rule);
    private final Label newRuleStatusLabel = new Label(Messages.ConflictDialog_New_Status);
    private final Label newRuleTextLabel = new Label(Messages.ConflictDialog_Rule_Text);
    private final Label rulesToCheckCountLabel = new Label(Messages.ConflictDialog_Amount);
    private final Label rulesToCheckLabel = new Label(Messages.ConflictDialog_Rules_for_verification);
    private final CheckBoxWidget forAllCheckBox = new CheckBoxWidget(false);
    private final RadioBoxWidget<RulesImportProperties.UserAction> importTypeRadioBox;

    public ImportRulesConflictDialog(RuleSettings oldRule, RuleSettings newRule, RulesImportProperties.Coincidence coincType, int count, boolean keepLocked) {
        String type;
        this.curRuleTextLabel.setText(oldRule.getRestrictionsInfo());
        this.newRuleTextLabel.setText(newRule.getRestrictionsInfo());
        switch (coincType) {
            case TCH_TELEX_NO: {
                type = "TCH telex No";
                break;
            }
            case NAME: {
                type = "rule name";
                break;
            }
            case CONDITIONS: {
                type = "conditions";
                break;
            }
            case CONDITIONS_AND_RESULTS: {
                type = "conditions and results";
                break;
            }
            case FULL: {
                type = "full";
                break;
            }
            default: {
                type = "\u2014";
            }
        }
        this.coincTypeTextLabel.setText(type);
        this.rulesToCheckCountLabel.setText(String.valueOf(count));
        this.newRuleStatusLabel.setText(this.buildRuleDescription(newRule));
        this.curRuleStatusLabel.setText(this.buildRuleDescription(oldRule));
        this.forAllCheckBox.setText(Messages.ConflictDialog_Use_this_option_for_all_rules);
        this.importTypeRadioBox = this.createUserActionRadioBox();
    }

    public void show(Control source, String title) {
        GridContainer gridContainerDescription = this.createDescriptionContainer(this.curRuleLabel, this.curRuleStatusLabel, this.curRuleTextLabel, this.newRuleLabel, this.newRuleStatusLabel, this.newRuleTextLabel, this.coincTypeLabel, this.coincTypeTextLabel, this.rulesToCheckLabel, this.rulesToCheckCountLabel);
        GridContainer gridContainerOptions = ImportRulesConflictDialog.createOptionsContainer(this.importTypeRadioBox, this.forAllCheckBox);
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("description", UiCardsContainer.Style.STATIC, Messages.ConflictDialog_Description_of_the_conflict, (Node)gridContainerDescription));
        cardsContainer.getCards().add((Object)new Card("options", UiCardsContainer.Style.EXPANDED, Messages.Settings, (Node)gridContainerOptions));
        Dialog dialog = new Dialog();
        dialog.setTitle(title).setAutoClose(false).setBody((Node)cardsContainer).addButton(DialogButtonStyle.ACCEPT_REGULAR, "OK", () -> {
            this.saveUiData();
            this.dialogResult = DialogResult.OK;
        }).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.ConflictDialog_Continue_verification, () -> {
            this.saveUiData();
            this.dialogResult = DialogResult.CONTINUE_CHECKING;
        }).addButton(DialogButtonStyle.DECLINE, Messages.ConflictDialog_Cancel_Import, () -> {
            this.saveUiData();
            this.dialogResult = DialogResult.CANCEL_IMPORT;
            dialog.close();
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)source);
    }

    private static GridContainer createOptionsContainer(RadioBoxWidget<RulesImportProperties.UserAction> importTypeRadioBox, CheckBoxWidget forAllCheckBox) {
        GridContainer gridContainerOptions = new GridContainer();
        ArrayList<GridCell> cells2 = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.ConflictDialog_Select_an_action, importTypeRadioBox);
        cells2.add(cell);
        cell = new GridCell(null, (Node)forAllCheckBox);
        cells2.add(cell);
        gridContainerOptions.getCells().addAll(cells2);
        return gridContainerOptions;
    }

    private GridContainer createDescriptionContainer(Label curRuleLabel, Label curRuleStatusLabel, Label curRuleTextLabel, Label newRuleLabel, Label newRuleStatusLabel, Label newRuleTextLabel, Label coincTypeLabel, Label coincTypeTextLabel, Label rulesToCheckLabel, Label rulesToCheckCountLabel) {
        GridContainer gridContainerDescription = new GridContainer(2);
        ArrayList<GridCell> cells1 = new ArrayList<GridCell>();
        GridCell cell = new GridCell((Node)curRuleLabel);
        cells1.add(cell);
        cell = new GridCell((Node)curRuleStatusLabel);
        cells1.add(cell);
        cell = new GridCell((Node)curRuleTextLabel);
        cell.setColSpan(2);
        cells1.add(cell);
        cell = new GridCell((Node)newRuleLabel);
        cells1.add(cell);
        cell = new GridCell((Node)newRuleStatusLabel);
        cells1.add(cell);
        cell = new GridCell((Node)newRuleTextLabel);
        cell.setColSpan(2);
        cells1.add(cell);
        cell = new GridCell((Node)coincTypeLabel);
        cells1.add(cell);
        cell = new GridCell((Node)coincTypeTextLabel);
        cells1.add(cell);
        cell = new GridCell((Node)rulesToCheckLabel);
        cells1.add(cell);
        cell = new GridCell((Node)rulesToCheckCountLabel);
        cells1.add(cell);
        gridContainerDescription.getCells().addAll(cells1);
        return gridContainerDescription;
    }

    private RadioBoxWidget<RulesImportProperties.UserAction> createUserActionRadioBox() {
        RadioBoxWidget userActionRadioBox = new RadioBoxWidget(false);
        userActionRadioBox.setItemsSupplier(() -> {
            ArrayList<RulesImportProperties.UserAction> result = new ArrayList<RulesImportProperties.UserAction>();
            result.add(RulesImportProperties.UserAction.SAVE_OLD_IGNORE_NEW);
            result.add(RulesImportProperties.UserAction.IMPORT_NEW_DELETE_OLD);
            result.add(RulesImportProperties.UserAction.IMPORT_NEW_SAVE_OLD);
            return result;
        });
        userActionRadioBox.valueProperty().set((Object)RulesImportProperties.UserAction.SAVE_OLD_IGNORE_NEW);
        return userActionRadioBox;
    }

    private String buildRuleDescription(RuleSettings newRule) {
        String tchTelexNo;
        StringBuilder sb = new StringBuilder();
        String name = newRule.getName();
        boolean isFirst = true;
        if (!TextUtil.isBlank((String)name)) {
            sb.append(Messages.ConflictDialog_Name + name);
            isFirst = false;
        }
        if (!TextUtil.isBlank((String)(tchTelexNo = (String)newRule.getAttributes().get(RuleAttributes.TCH_TELEX_NO.name())))) {
            if (!isFirst) {
                sb.append(",");
            }
            sb.append(Messages.ConflictDialog_TSN_N_teleksa + tchTelexNo);
            isFirst = false;
        }
        return sb.toString();
    }

    void saveUiData() {
        this.userAction = (RulesImportProperties.UserAction)this.importTypeRadioBox.getValue();
        this.forAll = this.forAllCheckBox.isSelected();
    }

    public RulesImportProperties.UserAction getUserAction() {
        return this.userAction;
    }

    public boolean isForAll() {
        return this.forAll;
    }

    public DialogResult getDialogResult() {
        return this.dialogResult;
    }

    public static enum DialogResult {
        OK,
        CANCEL_IMPORT,
        CONTINUE_CHECKING;

    }
}

