/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleValueRenderers;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.widget.FopCellWidget;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.widget.FopCellWidgetColumn;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.Node;

public final class FopCommissionNodeRenderer
implements NodeRenderer {
    private static final String DISABLED_CELL_STYLE = "xtrip-cell-disabled";
    private static final FopCommissionNodeRenderer instance = new FopCommissionNodeRenderer();

    private FopCommissionNodeRenderer() {
    }

    public static FopCommissionNodeRenderer getInstance() {
        return instance;
    }

    public Node createNode(boolean readonly) {
        Node node = StandardRuleValueRenderers.NULL.createNode(readonly);
        node.setUserData((Object)new FopTable());
        return node;
    }

    public Object getValue(Node node) {
        List<FopRow> fopRows = this.getActionTable(node).getValues();
        Double[][] doubleValues = new Double[RulesHelper.paymentTypes.length][RulesHelper.targetTypes.length];
        String[][] codes = new String[RulesHelper.paymentTypes.length][RulesHelper.targetTypes.length];
        RuleResultValue.FOPCommissionType[][] segments = new RuleResultValue.FOPCommissionType[RulesHelper.paymentTypes.length][RulesHelper.targetTypes.length];
        boolean segmentsFound = false;
        for (int i = 0; i < fopRows.size(); ++i) {
            FopRow row = fopRows.get(i);
            if (row.commissions.isEmpty()) continue;
            for (int j = 0; j < row.commissions.size(); ++j) {
                FopCell cell = row.commissions.get(j);
                doubleValues[i][j] = cell.amount;
                codes[i][j] = cell.code;
                if (cell.commissionType == null) continue;
                segmentsFound = true;
                segments[i][j] = cell.commissionType;
            }
        }
        RuleResultValue result = new RuleResultValue();
        if (segmentsFound) {
            result.setFopValues(new Object[]{doubleValues, codes, segments});
        } else {
            result.setFopValues(new Object[]{doubleValues, codes});
        }
        return result;
    }

    public void setValue(Node node, Object value) {
        RuleResultValue rrValue = (RuleResultValue)value;
        if (rrValue != null) {
            Object[] values = rrValue.getFopValues();
            Double[][] doubleValues = (Double[][])values[0];
            String[][] codes = (String[][])values[1];
            RuleResultValue.FOPCommissionType[][] types = values.length == 3 ? (RuleResultValue.FOPCommissionType[][])values[2] : (RuleResultValue.FOPCommissionType[][])null;
            ArrayList<FopRow> fopRows = new ArrayList<FopRow>();
            for (int i = 0; i < doubleValues.length; ++i) {
                FopRow fopRow = new FopRow();
                fopRow.paymentTypes = RulesHelper.paymentTypes[i];
                for (int j = 0; j < RulesHelper.targetTypes.length; ++j) {
                    FopCell cell = new FopCell();
                    cell.amount = doubleValues[i][j];
                    cell.code = codes[i][j];
                    cell.commissionType = types == null ? null : types[i][j];
                    fopRow.commissions.add(cell);
                }
                fopRows.add(fopRow);
            }
            this.getActionTable(node).setValues(fopRows);
        } else {
            this.getActionTable(node).eraseValues();
        }
    }

    public void setReadonly(boolean readonly, Node node) {
        this.getActionTable(node).getViewState().setReadonly(readonly);
    }

    public FopTable getActionTable(Node node) {
        return (FopTable)((Object)node.getUserData());
    }

    class FopTable
    extends TableWidget<FopRow> {
        private static final String TYPE_ID = "type";
        private final List<FopRow> fopRows;

        public FopTable() {
            super(false);
            this.fopRows = new ArrayList<FopRow>();
            this.setItemsProvider(() -> new FopRow());
            this.setControlButtonsAvailability(ControlsPane.NONE);
            this.setColumns(this.createColumns());
            this.fillTable();
        }

        List<FopRow> getValues() {
            for (int i = 0; i < this.fopRows.size(); ++i) {
                FopRow row = this.fopRows.get(i);
                row.commissions = new ArrayList<FopCell>();
                for (int j = 0; j < RulesHelper.targetTypes.length; ++j) {
                    String fieldName = RulesHelper.targetTypes[j];
                    FopCellWidget widget = (FopCellWidget)this.getColumn(fieldName + "_ID").getWidget(i);
                    FopCellWidget.FopCommissionValue value = widget.getValue();
                    FopCell cell = new FopCell();
                    cell.amount = value == null ? null : value.amount;
                    cell.code = value == null ? null : value.code;
                    cell.commissionType = value != null && value.segmentFlag != null && value.segmentFlag != false ? RuleResultValue.FOPCommissionType.PER_SEGMENT : null;
                    row.commissions.add(cell);
                }
            }
            return this.fopRows;
        }

        void setValues(List<FopRow> valueRows) {
            for (int i = 0; i < this.fopRows.size(); ++i) {
                FopCell cell;
                int j;
                FopRow row = this.fopRows.get(i);
                FopRow valueRow = valueRows.get(i);
                if (row.commissions.isEmpty()) {
                    row.commissions = valueRow.commissions;
                } else {
                    for (j = 0; j < row.commissions.size(); ++j) {
                        cell = row.commissions.get(j);
                        cell.amount = valueRow.commissions.get((int)j).amount;
                        cell.code = valueRow.commissions.get((int)j).code;
                        cell.commissionType = valueRow.commissions.get((int)j).commissionType;
                    }
                }
                for (j = 0; j < row.commissions.size(); ++j) {
                    cell = row.commissions.get(j);
                    String fieldName = RulesHelper.targetTypes[j];
                    FopCellWidget widget = (FopCellWidget)this.getColumn(fieldName + "_ID").getWidget(i);
                    FopCellWidget.FopCommissionValue val = new FopCellWidget.FopCommissionValue();
                    val.amount = cell.amount;
                    val.code = cell.code;
                    val.segmentFlag = cell.commissionType != null && cell.commissionType.equals((Object)RuleResultValue.FOPCommissionType.PER_SEGMENT) ? Boolean.TRUE : null;
                    widget.setValue(val);
                }
            }
        }

        void eraseValues() {
            for (int i = 0; i < this.fopRows.size(); ++i) {
                FopRow row = this.fopRows.get(i);
                if (!row.commissions.isEmpty()) {
                    for (FopCell cell : row.commissions) {
                        cell.amount = null;
                        cell.code = null;
                        cell.commissionType = null;
                    }
                }
                for (int j = 0; j < RulesHelper.targetTypes.length; ++j) {
                    String fieldName = RulesHelper.targetTypes[j];
                    FopCellWidget widget = (FopCellWidget)this.getColumn(fieldName + "_ID").getWidget(i);
                    widget.setValue(null);
                }
            }
        }

        private List<TableWidgetColumn<FopRow, ?>> createColumns() {
            ArrayList tableColumns = new ArrayList();
            TextWidgetColumn column1 = new TextWidgetColumn(fr -> null, (fr, value) -> {
                fr.paymentTypes = new String[]{value, null};
            });
            column1.setId(TYPE_ID);
            column1.setCaption("");
            tableColumns.add((TableWidgetColumn<FopRow, ?>)column1);
            for (int i = 0; i < RulesHelper.targetTypes.length; ++i) {
                FopCellWidgetColumn<FopRow> column = this.createColumn(i);
                tableColumns.add(column);
            }
            return tableColumns;
        }

        private FopCellWidgetColumn<FopRow> createColumn(int i) {
            String fieldName = RulesHelper.targetTypes[i];
            FopCellWidgetColumn<FopRow> column = new FopCellWidgetColumn<FopRow>(fr -> this.getCommissionValue((FopRow)fr, i), (fr, value) -> this.setCommissionValue((FopRow)fr, i, (FopCellWidget.FopCommissionValue)value));
            column.setId(fieldName + "_ID");
            column.setCaption(this.informative(fieldName));
            return column;
        }

        private String informative(String fieldName) {
            if (Stream.of(MCOCategory.values()).map(e -> e.name()).collect(Collectors.toList()).contains(fieldName)) {
                return MCOCategory.valueOf((String)fieldName).toString();
            }
            return ProductCategory.valueOf((String)fieldName).toString();
        }

        private FopCellWidget.FopCommissionValue getCommissionValue(FopRow row, int idx) {
            if (idx >= row.commissions.size()) {
                return null;
            }
            FopCell cell = row.commissions.get(idx);
            FopCellWidget.FopCommissionValue cValue = new FopCellWidget.FopCommissionValue();
            cValue.amount = cell.amount;
            cValue.code = cell.code;
            cValue.segmentFlag = RuleResultValue.FOPCommissionType.PER_SEGMENT.equals((Object)cell.commissionType) ? Boolean.TRUE : null;
            return cValue;
        }

        private void setCommissionValue(FopRow row, int idx, FopCellWidget.FopCommissionValue value) {
            if (idx < row.commissions.size()) {
                FopCell cell = row.commissions.get(idx);
                cell.amount = value.amount;
                cell.code = value.code;
                cell.commissionType = value.segmentFlag != null && value.segmentFlag != false ? RuleResultValue.FOPCommissionType.PER_SEGMENT : null;
            }
        }

        private void fillTable() {
            for (int idx = 0; idx < RulesHelper.paymentTypes.length; ++idx) {
                FopRow fopRow = new FopRow();
                fopRow.paymentTypes = RulesHelper.paymentTypes[idx];
                this.fopRows.add(fopRow);
                this.addRow(idx);
                TextWidgetColumn column1 = (TextWidgetColumn)this.getColumn(TYPE_ID);
                TextFieldWidget node1 = (TextFieldWidget)column1.getWidget(idx);
                column1.setReadonly(node1, true);
                node1.setValue(this.paymentCaption(fopRow.paymentTypes));
                node1.getStyleClass().add((Object)FopCommissionNodeRenderer.DISABLED_CELL_STYLE);
            }
        }

        private String paymentCaption(String[] paymentTypes) {
            if (paymentTypes[0] == null) {
                return Messages.Any;
            }
            if (paymentTypes[1] == null) {
                return this.localized(paymentTypes[0]);
            }
            return String.format("%s + %s", this.localized(paymentTypes[0]), this.localized(paymentTypes[1]));
        }

        private String localized(String paymentType) {
            return PaymentType.valueOf((String)paymentType).toString();
        }
    }

    private class FopCell {
        public Double amount;
        public String code;
        public RuleResultValue.FOPCommissionType commissionType;

        private FopCell() {
        }
    }

    private class FopRow {
        public String[] paymentTypes;
        public List<FopCell> commissions = new ArrayList<FopCell>();

        private FopRow() {
        }
    }
}

