/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DoubleValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleResultValueRenderer;
import com.gridnine.xtrip.common.model.rules.standard.ServiceClassCommissionsRuleResultValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;

public final class ServiceCommissionRenderer
implements NodeRenderer {
    private static final ServiceCommissionRenderer instance = new ServiceCommissionRenderer();

    private ServiceCommissionRenderer() {
    }

    public static ServiceCommissionRenderer getInstance() {
        return instance;
    }

    public Node createNode(boolean readonly) {
        Node node = StandardRuleResultValueRenderer.PRICE_AND_TYPE.createNode(readonly);
        node.setUserData((Object)new ServiceTable(readonly));
        return node;
    }

    public Object getValue(final Node node) {
        ServiceClassCommissionsRuleResultValue nodeResult = (ServiceClassCommissionsRuleResultValue)StandardRuleResultValueRenderer.PRICE_AND_TYPE.getValue(node);
        ServiceClassCommissionsRuleResultValue result = new ServiceClassCommissionsRuleResultValue();
        result.setCurrencyCode(nodeResult.getCurrencyCode());
        result.setCommissionType(nodeResult.getCommissionType());
        TableWidgetController<ServiceTable, ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue> controller = new TableWidgetController<ServiceTable, ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue>(){

            public ServiceTable getView() {
                return ServiceCommissionRenderer.this.getServiceTable(node);
            }
        };
        controller.writeData((Collection)result.getValues());
        return result;
    }

    public void setValue(final Node node, Object value) {
        ServiceClassCommissionsRuleResultValue commissionValue = (ServiceClassCommissionsRuleResultValue)value;
        StandardRuleResultValueRenderer.PRICE_AND_TYPE.setValue(node, commissionValue);
        if (commissionValue != null) {
            TableWidgetController<ServiceTable, ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue> controller = new TableWidgetController<ServiceTable, ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue>(){

                public ServiceTable getView() {
                    return ServiceCommissionRenderer.this.getServiceTable(node);
                }
            };
            controller.readData((Collection)commissionValue.getValues());
        } else {
            this.getServiceTable(node).removeAllRows();
        }
    }

    public void setReadonly(boolean readonly, Node node) {
        this.getServiceTable(node).getViewState().setReadonly(readonly);
    }

    public ServiceTable getServiceTable(Node node) {
        return (ServiceTable)((Object)node.getUserData());
    }

    class ServiceTable
    extends TableWidget<ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue> {
        ServiceTable(boolean readonly) {
            super(readonly);
            this.setItemsProvider(() -> new ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue());
            this.getViewState().setNotEditable(false);
            this.setColumns(this.createColumns());
        }

        private List<TableWidgetColumn<ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue, ?>> createColumns() {
            ArrayList tableColumns = new ArrayList();
            TextWidgetColumn column1 = new TextWidgetColumn(c -> c.getServiceClassCodes(), (c, code) -> c.setServiceClassCodes(code));
            column1.setId("SERVICE_TABLE_CODE");
            column1.setCaption(Messages.Service_Table_Code);
            tableColumns.add((TableWidgetColumn<ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue, ?>)column1);
            DoubleValueWidgetColumn column2 = new DoubleValueWidgetColumn(v -> v.getValue() == null ? null : Double.valueOf(v.getValue().doubleValue()), (v, value) -> v.setValue(value == null ? null : new BigDecimal((double)value)));
            column2.setId("SERVICE_TABLE_VALUE");
            column2.setCaption(Messages.Values);
            column2.setDefaultValue(null);
            tableColumns.add((TableWidgetColumn<ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue, ?>)column2);
            return tableColumns;
        }
    }
}

