/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.pair.PairWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleValueRenderers;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.dict.WeekDay;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.TchRouteRestrictions;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.util.DateInterval;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class TchRouteValueRenderer
implements RuleValueRenderer {
    private static final String DISABLED_CELL_STYLE = "xtrip-cell-disabled";

    public String getId() {
        return ValueTypes.TCH_ROUTE.name();
    }

    public Node createNode(boolean readonly) {
        Node node = StandardRuleValueRenderers.NULL.createNode(readonly);
        node.setUserData((Object)new TchRouteTable(readonly));
        return node;
    }

    public TableWidget<RuleRestriction> getPropertiesTable(Node node) {
        return (TableWidget)node.getUserData();
    }

    public Object getValue(Node node) {
        TchRouteTable table = (TchRouteTable)this.getPropertiesTable(node);
        if (table == null) {
            return null;
        }
        return new TchRouteRestrictions(table.appliedToSegment, table.classOfBookingRestriction, table.classOfBookingValue, table.departureDatesRestriction, table.departureDatesValue == null ? null : table.departureDatesValue.getBeginDate(), table.departureDatesValue == null ? null : table.departureDatesValue.getEndDate(), table.departureDaysRestriction, this.weekDays2String(table.departureDaysValue), table.flightNumbersRestriction, table.flightNumbersValue, table.interlineRestriction, table.interlineValue, table.routeRestriction, table.routeValue, table.fareBasisesRestriction, table.fareBasisesValue);
    }

    public void setValue(Node node, Object value) {
        if (value == null) {
            return;
        }
        TchRouteRestrictions restrictions = (TchRouteRestrictions)value;
        TchRouteTable table = (TchRouteTable)this.getPropertiesTable(node);
        table.appliedToSegment = restrictions.isAppliedToSegment();
        table.classOfBookingRestriction = restrictions.getClassOfBookingRestriction();
        table.classOfBookingValue = restrictions.getClassOfBookingValue();
        table.departureDatesRestriction = restrictions.getDepartureDatesRestriction();
        table.departureDatesValue = new DateInterval(restrictions.getDepartureDatesFromValue(), restrictions.getDepartureDatesToValue());
        table.departureDaysRestriction = restrictions.getDepartureDaysRestriction();
        table.departureDaysValue = this.string2WeekDays(restrictions.getDepartureDaysValue());
        table.flightNumbersRestriction = restrictions.getFlightNumbersRestriction();
        table.flightNumbersValue = restrictions.getFlightNumbersValue();
        table.interlineRestriction = restrictions.getInterlineRestriction();
        table.interlineValue = restrictions.getInterlineValue();
        table.routeRestriction = restrictions.getRouteRestriction();
        table.routeValue = restrictions.getRouteValue();
        table.fareBasisesRestriction = restrictions.getTariffCodeRestriction();
        table.fareBasisesValue = restrictions.getTariffCodeValue();
        table.updateValues();
    }

    @Override
    public Object joinValues(RuleCondition condition, Object value) {
        TchRouteRestrictions restrictions = (TchRouteRestrictions)value;
        restrictions.setAppliedToSegment(Conditions.TCH_ROUTE_SEGMENT.equals((Object)condition));
        return restrictions;
    }

    @Override
    public boolean isValueEmpty(Node node) {
        TchRouteTable table = (TchRouteTable)this.getPropertiesTable(node);
        if (table == null) {
            return true;
        }
        return table.interlineRestriction == TchRouteRestrictions.InterlineRestriction.ALL && table.routeRestriction == TchRouteRestrictions.RouteRestriction.ALL && table.flightNumbersRestriction == TchRouteRestrictions.FlightNumbersRestriction.ALL && table.departureDatesRestriction == TchRouteRestrictions.DepartureDatesRestriction.ALL && table.departureDaysRestriction == TchRouteRestrictions.DepartureDaysRestriction.ALL && table.classOfBookingRestriction == TchRouteRestrictions.ClassOfBookingRestriction.ALL && table.fareBasisesRestriction == TchRouteRestrictions.TariffCodeRestriction.ALL;
    }

    @Override
    public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
        StringBuilder buf = new StringBuilder();
        Properties.TCH_ROUTE.buildInfo(buf, ruleRestriction.getCondition(), ruleRestriction.getValue());
        out.accept(buf.toString().replace("<br>", "\n  ").replace("\\", ""));
    }

    public void setReadonly(boolean readonly, Node node) {
        this.getPropertiesTable(node).getViewState().setReadonly(readonly);
    }

    private String weekDays2String(List<WeekDay> weekDays) {
        CharSequence[] days = (String[])weekDays.stream().map(e -> this.weekDay2String((WeekDay)e)).toArray(String[]::new);
        return String.join((CharSequence)",", days);
    }

    private List<WeekDay> string2WeekDays(String string) {
        if (string == null || string.isEmpty()) {
            return new ArrayList<WeekDay>();
        }
        String[] days = string.replace(';', ',').split(",");
        return Arrays.asList(days).stream().map(e -> this.string2WeekDay((String)e)).collect(Collectors.toList());
    }

    private String weekDay2String(WeekDay weekDay) {
        switch (weekDay) {
            case MONDAY: {
                return "1";
            }
            case TUESDAY: {
                return "2";
            }
            case WEDNESDAY: {
                return "3";
            }
            case THURSDAY: {
                return "4";
            }
            case FRIDAY: {
                return "5";
            }
            case SATURDAY: {
                return "6";
            }
            case SUNDAY: {
                return "7";
            }
        }
        throw new IllegalArgumentException("wrong weekday " + weekDay.name());
    }

    private WeekDay string2WeekDay(String day) {
        switch (day) {
            case "1": {
                return WeekDay.MONDAY;
            }
            case "2": {
                return WeekDay.TUESDAY;
            }
            case "3": {
                return WeekDay.WEDNESDAY;
            }
            case "4": {
                return WeekDay.THURSDAY;
            }
            case "5": {
                return WeekDay.FRIDAY;
            }
            case "6": {
                return WeekDay.SATURDAY;
            }
            case "7": {
                return WeekDay.SUNDAY;
            }
        }
        throw new IllegalArgumentException("wrong weekday \u2116" + day);
    }

    class TchRouteTable
    extends TableWidget<RuleRestriction> {
        private static final String PROPERTY_ID = "property";
        private static final String CONDITION_ID = "condition";
        private static final String VALUE_ID = "value";
        private final Double COLUMN_WIDTH;
        boolean appliedToSegment;
        TchRouteRestrictions.InterlineRestriction interlineRestriction;
        String interlineValue;
        TchRouteRestrictions.RouteRestriction routeRestriction;
        String routeValue;
        TchRouteRestrictions.FlightNumbersRestriction flightNumbersRestriction;
        String flightNumbersValue;
        TchRouteRestrictions.DepartureDatesRestriction departureDatesRestriction;
        DateInterval departureDatesValue;
        TchRouteRestrictions.DepartureDaysRestriction departureDaysRestriction;
        List<WeekDay> departureDaysValue;
        TchRouteRestrictions.ClassOfBookingRestriction classOfBookingRestriction;
        String classOfBookingValue;
        TchRouteRestrictions.TariffCodeRestriction fareBasisesRestriction;
        String fareBasisesValue;

        TchRouteTable(boolean readonly) {
            super(readonly);
            this.COLUMN_WIDTH = 33.0;
            this.appliedToSegment = false;
            this.interlineRestriction = TchRouteRestrictions.InterlineRestriction.ALL;
            this.routeRestriction = TchRouteRestrictions.RouteRestriction.ALL;
            this.flightNumbersRestriction = TchRouteRestrictions.FlightNumbersRestriction.ALL;
            this.departureDatesRestriction = TchRouteRestrictions.DepartureDatesRestriction.ALL;
            this.departureDaysRestriction = TchRouteRestrictions.DepartureDaysRestriction.ALL;
            this.departureDaysValue = new ArrayList<WeekDay>();
            this.classOfBookingRestriction = TchRouteRestrictions.ClassOfBookingRestriction.ALL;
            this.fareBasisesRestriction = TchRouteRestrictions.TariffCodeRestriction.ALL;
            this.setItemsProvider(() -> new RuleRestriction());
            this.setControlButtonsAvailability(ControlsPane.NONE);
            this.setColumns(this.createColumns());
            this.fillTable();
        }

        void updateValues() {
            int row = 0;
            this.updateRow(row++, this.interlineRestriction, this.interlineValue);
            this.updateRow(row++, this.routeRestriction, this.routeValue);
            this.updateRow(row++, this.flightNumbersRestriction, this.flightNumbersValue);
            this.updateRow(row++, this.departureDatesRestriction, this.departureDatesValue);
            this.updateRow(row++, this.departureDaysRestriction, this.departureDaysValue);
            this.updateRow(row++, this.classOfBookingRestriction, this.classOfBookingValue);
            this.updateRow(row++, this.fareBasisesRestriction, this.fareBasisesValue);
        }

        private List<TableWidgetColumn<RuleRestriction, ?>> createColumns() {
            ArrayList tableColumns = new ArrayList();
            TextWidgetColumn column1 = new TextWidgetColumn(rr -> null, (rr, value) -> rr.setProperty(null));
            column1.setId(PROPERTY_ID);
            column1.setCaption(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Property);
            column1.setPrefWidth(this.COLUMN_WIDTH);
            tableColumns.add((TableWidgetColumn<RuleRestriction, ?>)column1);
            ComboBoxWidgetColumn column2 = new ComboBoxWidgetColumn(rr -> rr.getCondition(), (rr, value) -> rr.setCondition(value));
            column2.setId(CONDITION_ID);
            column2.setCaption(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Condition);
            column2.setPrefWidth(this.COLUMN_WIDTH);
            tableColumns.add((TableWidgetColumn<RuleRestriction, ?>)column2);
            RendererWidgetColumn column3 = new RendererWidgetColumn(rr -> rr.getValue(), (rr, value) -> rr.setValue(value));
            column3.setId(VALUE_ID);
            column3.setCaption(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Value_text);
            tableColumns.add((TableWidgetColumn<RuleRestriction, ?>)column3);
            return tableColumns;
        }

        private void fillTable() {
            int row = 0;
            this.stringValueRow(row++, this.getCaption(L10n.get((String)Messages.Properties_interline)), () -> Arrays.asList(TchRouteRestrictions.InterlineRestriction.values()), TchRouteRestrictions.InterlineRestriction.ALL, () -> this.interlineRestriction, v -> {
                this.interlineRestriction = v;
            }, () -> this.interlineValue, v -> {
                this.interlineValue = v;
            });
            this.stringValueRow(row++, this.getCaption(L10n.get((String)Messages.Properties_route)), () -> Arrays.asList(TchRouteRestrictions.RouteRestriction.values()), TchRouteRestrictions.RouteRestriction.ALL, () -> this.routeRestriction, v -> {
                this.routeRestriction = v;
            }, () -> this.routeValue, v -> {
                this.routeValue = v;
            });
            this.stringValueRow(row++, this.getCaption(L10n.get((String)Messages.Properties_flightNumbers)), () -> Arrays.asList(TchRouteRestrictions.FlightNumbersRestriction.values()), TchRouteRestrictions.FlightNumbersRestriction.ALL, () -> this.flightNumbersRestriction, v -> {
                this.flightNumbersRestriction = v;
            }, () -> this.flightNumbersValue, v -> {
                this.flightNumbersValue = v;
            });
            this.dateIntervalValueRow(row++, this.getCaption(L10n.get((String)Messages.Properties_departureDates)), () -> Arrays.asList(TchRouteRestrictions.DepartureDatesRestriction.values()), TchRouteRestrictions.DepartureDatesRestriction.ALL, () -> this.departureDatesRestriction, v -> {
                this.departureDatesRestriction = v;
            }, () -> this.departureDatesValue, v -> {
                this.departureDatesValue = v;
            });
            this.weekDaysValueRow(row++, this.getCaption(L10n.get((String)Messages.Properties_departureDays)), () -> Arrays.asList(TchRouteRestrictions.DepartureDaysRestriction.values()), TchRouteRestrictions.DepartureDaysRestriction.ALL, () -> this.departureDaysRestriction, v -> {
                this.departureDaysRestriction = v;
            }, () -> this.departureDaysValue, v -> {
                this.departureDaysValue = v;
            });
            this.stringValueRow(row++, this.getCaption(L10n.get((String)Messages.Properties_classOfBooking)), () -> Arrays.asList(TchRouteRestrictions.ClassOfBookingRestriction.values()), TchRouteRestrictions.ClassOfBookingRestriction.ALL, () -> this.classOfBookingRestriction, v -> {
                this.classOfBookingRestriction = v;
            }, () -> this.classOfBookingValue, v -> {
                this.classOfBookingValue = v;
            });
            this.stringValueRow(row++, this.getCaption(L10n.get((String)Messages.Properties_tariffCode)), () -> Arrays.asList(TchRouteRestrictions.TariffCodeRestriction.values()), TchRouteRestrictions.TariffCodeRestriction.ALL, () -> this.fareBasisesRestriction, v -> {
                this.fareBasisesRestriction = v;
            }, () -> this.fareBasisesValue, v -> {
                this.fareBasisesValue = v;
            });
        }

        private String getCaption(String property) {
            return L10n.replace((String)property, (Object[])new Object[]{""}).replace("\\", "").replace(":", "");
        }

        private <T> void weekDaysValueRow(int idx, String rowCaption, Supplier<List<T>> restrictionSupplier, T zeroValue, Supplier<T> restrictionGetter, Consumer<T> restrictionSetter, Supplier<List<WeekDay>> valueGetter, Consumer<List<WeekDay>> valueSetter) {
            this.addRow(idx);
            TextWidgetColumn column1 = (TextWidgetColumn)this.getColumn(PROPERTY_ID);
            TextFieldWidget node1 = (TextFieldWidget)column1.getWidget(idx);
            node1.getViewState().setNotEditable(true);
            node1.setValue(rowCaption);
            node1.getStyleClass().add((Object)TchRouteValueRenderer.DISABLED_CELL_STYLE);
            ComboBoxWidgetColumn column2 = (ComboBoxWidgetColumn)this.getColumn(CONDITION_ID);
            ComboBoxWidget node2 = (ComboBoxWidget)column2.getWidget(idx);
            node2.setNoNulls(true);
            node2.setItemsSupplier(restrictionSupplier);
            RendererWidgetColumn column3 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            RendererWidget node3 = (RendererWidget)column3.getWidget(idx);
            node3.setValue(valueGetter.get());
            this.setWeekDaysRenderer(node3, valueSetter);
            node2.valueProperty().addListener((p, o, v) -> {
                restrictionSetter.accept(v);
                if (zeroValue.equals(v)) {
                    node3.setRenderer((NodeRenderer)StandardRuleValueRenderers.NULL);
                } else {
                    this.setWeekDaysRenderer(node3, valueSetter);
                }
            });
            node2.setValue(restrictionGetter.get());
        }

        private <T> void stringValueRow(int idx, String rowCaption, Supplier<List<T>> restrictionSupplier, T zeroValue, Supplier<T> restrictionGetter, Consumer<T> restrictionSetter, Supplier<String> valueGetter, Consumer<String> valueSetter) {
            this.addRow(idx);
            TextWidgetColumn column1 = (TextWidgetColumn)this.getColumn(PROPERTY_ID);
            TextFieldWidget node1 = (TextFieldWidget)column1.getWidget(idx);
            node1.getViewState().setNotEditable(true);
            node1.setValue(rowCaption);
            node1.getStyleClass().add((Object)TchRouteValueRenderer.DISABLED_CELL_STYLE);
            ComboBoxWidgetColumn column2 = (ComboBoxWidgetColumn)this.getColumn(CONDITION_ID);
            ComboBoxWidget node2 = (ComboBoxWidget)column2.getWidget(idx);
            node2.setNoNulls(true);
            node2.setItemsSupplier(restrictionSupplier);
            RendererWidgetColumn column3 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            RendererWidget node3 = (RendererWidget)column3.getWidget(idx);
            node3.setValue((Object)valueGetter.get());
            this.setStringRenderer(node3, valueSetter);
            node2.valueProperty().addListener((p, o, v) -> {
                restrictionSetter.accept(v);
                if (zeroValue.equals(v)) {
                    node3.setRenderer((NodeRenderer)StandardRuleValueRenderers.NULL);
                } else {
                    this.setStringRenderer(node3, valueSetter);
                }
            });
            node2.setValue(restrictionGetter.get());
        }

        private <T> void dateIntervalValueRow(int idx, String rowCaption, Supplier<List<T>> restrictionSupplier, T zeroValue, Supplier<T> restrictionGetter, Consumer<T> restrictionSetter, Supplier<DateInterval> valueGetter, Consumer<DateInterval> valueSetter) {
            this.addRow(idx);
            TextWidgetColumn column1 = (TextWidgetColumn)this.getColumn(PROPERTY_ID);
            TextFieldWidget node1 = (TextFieldWidget)column1.getWidget(idx);
            node1.getViewState().setNotEditable(true);
            node1.setValue(rowCaption);
            node1.getStyleClass().add((Object)TchRouteValueRenderer.DISABLED_CELL_STYLE);
            ComboBoxWidgetColumn column2 = (ComboBoxWidgetColumn)this.getColumn(CONDITION_ID);
            ComboBoxWidget node2 = (ComboBoxWidget)column2.getWidget(idx);
            node2.setNoNulls(true);
            node2.setItemsSupplier(restrictionSupplier);
            RendererWidgetColumn column3 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            RendererWidget node3 = (RendererWidget)column3.getWidget(idx);
            node3.setValue((Object)valueGetter.get());
            this.setDateIntervalRenderer(node3, valueSetter);
            node2.valueProperty().addListener((p, o, v) -> {
                restrictionSetter.accept(v);
                if (zeroValue.equals(v)) {
                    node3.setRenderer((NodeRenderer)StandardRuleValueRenderers.NULL);
                } else {
                    this.setDateIntervalRenderer(node3, valueSetter);
                }
            });
            node2.setValue(restrictionGetter.get());
        }

        private <R, V> void updateRow(int rowIdx, R restriction, V value) {
            ComboBoxWidgetColumn column2 = (ComboBoxWidgetColumn)this.getColumn(CONDITION_ID);
            ComboBoxWidget node2 = (ComboBoxWidget)column2.getWidget(rowIdx);
            node2.setValue(restriction);
            RendererWidgetColumn column3 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            RendererWidget node3 = (RendererWidget)column3.getWidget(rowIdx);
            node3.setValue(value);
        }

        private void setWeekDaysRenderer(RendererWidget node, Consumer<List<WeekDay>> setter) {
            node.setRenderer((NodeRenderer)StandardRuleValueRenderers.WEEK_DAY);
            ((ValuesWidget)node.getValueNode()).getValues().addListener(change -> setter.accept((List<WeekDay>)change.getList()));
        }

        private void setStringRenderer(RendererWidget node, Consumer<String> setter) {
            node.setRenderer((NodeRenderer)StandardRuleValueRenderers.STRING);
            ((TextFieldWidget)node.getValueNode()).valueProperty().addListener((p, o, v) -> setter.accept((String)v));
        }

        private void setDateIntervalRenderer(RendererWidget node, Consumer<DateInterval> setter) {
            node.setRenderer((NodeRenderer)StandardRuleValueRenderers.DATE_INTERVAL);
            PairWidget pairWidget = (PairWidget)node.getValueNode();
            pairWidget.firstValueProperty().addListener((p, o, v) -> {
                DateInterval interval = this.createInterval((PairWidget<LocalDate, DateValueWidget>)pairWidget, (LocalDate)v, null);
                setter.accept(interval);
            });
            pairWidget.secondValueProperty().addListener((p, o, v) -> {
                DateInterval interval = this.createInterval((PairWidget<LocalDate, DateValueWidget>)pairWidget, null, (LocalDate)v);
                setter.accept(interval);
            });
        }

        private DateInterval createInterval(PairWidget<LocalDate, DateValueWidget> widget, LocalDate localDate1, LocalDate localDate2) {
            Date date1 = DateUtils.asDate((LocalDate)(localDate1 == null ? (LocalDate)widget.getFirstValue() : localDate1));
            Date date2 = DateUtils.asDate((LocalDate)(localDate2 == null ? (LocalDate)widget.getSecondValue() : localDate2));
            return new DateInterval(date1, date2);
        }
    }
}

