/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.travelPolicy.BaseTravelPolicyMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMinimalPricePropertiesIndex;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMinimalPriceRuleValue;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyRuleRouteLimitParameters;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.RestrictionGroupType;
import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.search.SortOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public enum TravelPolicyRuleValueRenders implements RuleValueRenderer
{
    TRAVEL_POLICY_ORGANIZATION_PERSONS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Person.class, readonly);
            widget.setFieldName("\u0421\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a");
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getPersonsSortByCode);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            ArrayList listRef;
            if (node != null && value != null && !(listRef = (ArrayList)value).isEmpty()) {
                VMHelper.transfer(listRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }
    }
    ,
    TRAVEL_POLICY_ROUTE_LIMIT_PARAMETERS{
        private static final String WIDGET_VALUE_PROPERTY_KEY = "WIDGET_VALUE_PROPERTY_KEY";

        public Node createNode(boolean readonly) {
            PopupWidget popupWidget = new PopupWidget();
            popupWidget.getViewState().setReadonly(readonly);
            popupWidget.setActionText(L10n.get((String)Messages.TravelPolicyProperties_AVIA_ROUTE_LIMITS_ACTION_TEXT));
            popupWidget.setFieldName(L10n.get((String)Messages.TravelPolicyProperties_AVIA_ROUTE_LIMITS_FIELD_NAME));
            GridContainer container = new GridContainer(1);
            container.setAdaptive(true);
            TextFieldWidget node = new TextFieldWidget(readonly);
            node.setId("departureLocation");
            GridCell cell = new GridCell(L10n.get((String)Messages.TravelPolicyProperties_AVIA_ROUTE_LIMITS_DEPARTURE_LOCATION), (Node)node);
            container.getCells().add((Object)cell);
            node = new TextFieldWidget(readonly);
            node.setId("arriveLocation");
            cell = new GridCell(L10n.get((String)Messages.TravelPolicyProperties_AVIA_ROUTE_LIMITS_ARRIVE_LOCATION), (Node)node);
            container.getCells().add((Object)cell);
            node = new PriceValueWidget(readonly);
            node.setId("oneWayAmount");
            cell = new GridCell(L10n.get((String)Messages.TravelPolicyProperties_AVIA_ROUTE_LIMITS_ONE_WAY_AMOUNT), (Node)node);
            container.getCells().add((Object)cell);
            node = new PriceValueWidget(readonly);
            node.setId("roundTripAmount");
            cell = new GridCell(L10n.get((String)Messages.TravelPolicyProperties_AVIA_ROUTE_LIMITS_ROUND_TRIP_AMOUNT), (Node)node);
            container.getCells().add((Object)cell);
            popupWidget.setView((Node)container);
            popupWidget.setDialogCloseHandler(() -> {
                TravelPolicyRuleRouteLimitParameters value = (TravelPolicyRuleRouteLimitParameters)popupWidget.getProperties().get((Object)WIDGET_VALUE_PROPERTY_KEY);
                if (value == null) {
                    value = new TravelPolicyRuleRouteLimitParameters();
                    popupWidget.getProperties().put((Object)WIDGET_VALUE_PROPERTY_KEY, (Object)value);
                }
                for (GridCell listCell : ((GridContainer)popupWidget.getView()).getCells()) {
                    Node node = listCell.getPayload();
                    value.setValue(node.getId(), ((HasValue)node).valueProperty().get());
                }
            });
            return popupWidget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return node.getProperties().get((Object)WIDGET_VALUE_PROPERTY_KEY);
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            node.getProperties().put((Object)WIDGET_VALUE_PROPERTY_KEY, value);
            TravelPolicyRuleRouteLimitParameters params = (TravelPolicyRuleRouteLimitParameters)value;
            PopupWidget popupWidget = (PopupWidget)node;
            for (GridCell listCell : ((GridContainer)popupWidget.getView()).getCells()) {
                Node node2 = listCell.getPayload();
                ((HasValue)node2).valueProperty().set(params.getValue(node2.getId()));
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }
    }
    ,
    DIFF_WITH_MINIMAL_AIR{

        public Node createNode(boolean readonly) {
            return new Pane(readonly);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }

        public Object getValue(Node node) {
            return ((Pane)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (value == null) {
                return;
            }
            TravelPolicyMinimalPriceRuleValue typedValue = (TravelPolicyMinimalPriceRuleValue)value;
            ((Pane)node).setValue(typedValue);
        }

        class Pane
        extends GridContainer
        implements HasViewState {
            private final DoubleValueWidget percentWidget;
            private final EntityBoxWidget<BaseTravelPolicyMinimalPriceProperties> propertiesWidget;

            Pane(boolean readonly) {
                super(2);
                this.percentWidget = new DoubleValueWidget(readonly);
                GridCell percentCell = new GridCell((Node)this.percentWidget);
                this.getCells().add((Object)percentCell);
                this.propertiesWidget = new EntityBoxWidget(BaseTravelPolicyMinimalPriceProperties.class, readonly);
                this.propertiesWidget.setListParametersSupplier(() -> {
                    IndexListParameters params = new IndexListParameters();
                    params.setIndexType(TravelPolicyMinimalPricePropertiesIndex.class);
                    RestrictionValue rv = new RestrictionValue();
                    rv.setPropertyId(TravelPolicyMinimalPricePropertiesIndex.class.getName() + '.' + TravelPolicyMinimalPricePropertiesIndex.Property.travelSubject.name());
                    rv.setConditionId(StandardRestrictionResourcePropertyConditions.EQUALS.getId());
                    rv.setValue(Collections.singletonList(TravelSubject.AIR));
                    RestrictionGroup rg = new RestrictionGroup();
                    rg.setType(RestrictionGroupType.SIMPLE);
                    rg.setValue((Object)rv);
                    params.getRestrictions().add(rg);
                    params.getSortings().put(TravelPolicyMinimalPricePropertiesIndex.Property.name.name(), SortOrder.ASC);
                    ListParametersHelper.setColumns(params, TravelPolicyMinimalPricePropertiesIndex.Property.name.name());
                    return params;
                });
                this.propertiesWidget.setFieldName("\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0446\u0435\u043d\u044b");
                GridCell propertiesCell = new GridCell(this.propertiesWidget);
                this.getCells().add((Object)propertiesCell);
                this.propertiesWidget.getViewState().stateProperty().bind((ObservableValue)this.percentWidget.getViewState().stateProperty());
            }

            TravelPolicyMinimalPriceRuleValue getValue() {
                EntityReference propertiesValue = this.propertiesWidget.getValue();
                Double percentValue = (Double)this.percentWidget.getValue();
                if (propertiesValue == null || percentValue == null) {
                    return null;
                }
                TravelPolicyMinimalPriceRuleValue value = new TravelPolicyMinimalPriceRuleValue();
                value.setPercent(BigDecimal.valueOf(percentValue));
                value.setProperties(propertiesValue);
                return value;
            }

            void setValue(TravelPolicyMinimalPriceRuleValue value) {
                if (value.getProperties() != null) {
                    this.propertiesWidget.setValue(value.getProperties());
                }
                if (value.getPercent() != null) {
                    this.percentWidget.setValue((Number)value.getPercent().doubleValue());
                }
            }

            public ViewState getViewState() {
                return this.percentWidget.getViewState();
            }
        }
    };


    public String getId() {
        return this.name();
    }

    @Override
    public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
        RuleProperty property = ruleRestriction.getProperty();
        StringBuilder builder = new StringBuilder();
        property.buildInfo(builder, ruleRestriction.getCondition(), ruleRestriction.getValue());
        out.accept(builder.toString());
    }

    public void setReadonly(boolean readonly, Node node) {
        ((HasViewState)node).getViewState().setReadonly(readonly);
    }
}

