/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.settings.SettingsManagerPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;

public class SettingsActivityHandler
extends ActivityHandler<SettingsManagerPane, Void> {
    public static final String TOKEN = "settings-manager";
    public static final String TITLE = Messages.Parameters;
    public static final String DESCRIPTION = Messages.Parameters;
    private static String ID = "settings-activity-handler";

    public static SettingsActivityHandler get() {
        return (SettingsActivityHandler)SettingsActivityHandler.forId((String)ID);
    }

    public static void register(ClientRegistry registry) {
        if (!registry.allOf(TYPE).containsKey(ID)) {
            registry.register((RegistryItem)new SettingsActivityHandler());
        }
    }

    private SettingsActivityHandler() {
    }

    public String getId() {
        return ID;
    }

    protected boolean isHighlighted(ActivityState<SettingsManagerPane, Void> state) {
        return true;
    }

    protected SettingsManagerPane createView(ActivityState<SettingsManagerPane, Void> state) {
        SettingsManagerPane result = new SettingsManagerPane(state.getMutex());
        Notifications.get().submitTask(() -> result.reloadData(), result.getMutex());
        return result;
    }

    protected boolean hasChanges(ActivityState<SettingsManagerPane, Void> state) {
        SettingsManagerPane view = (SettingsManagerPane)this.getView(state);
        return view != null && view.isDataChanged();
    }

    protected void saveChanges(ActivityState<SettingsManagerPane, Void> state) throws Exception {
        SettingsManagerPane view = (SettingsManagerPane)this.getView(state);
        if (view == null) {
            return;
        }
        view.saveData();
    }

    protected Serializer<Void> getSerializer() {
        return Serializer.VOID;
    }
}

