/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.gdsnames;

import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcDictHelper;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class GdsSettingsHelper {
    public static Set<GdsName> getGdsNames2() {
        HashSet<GdsName> gdsNames = new HashSet<GdsName>();
        try {
            String value = RpcDictHelper.findPreferenceValue(PreferenceKey.GDS_CHOICE_SETTINGS);
            if (!TextUtil.isBlank((String)value)) {
                for (String code : TextUtil.split((String)value, (String)"\\|", (boolean)true, (boolean)true)) {
                    GdsName pt = (GdsName)CollectionUtil.findEnumConstant(GdsName.class, (String)code);
                    if (pt == GdsName.AVIANOVA || pt == null) continue;
                    gdsNames.add(pt);
                }
            }
            if (gdsNames.isEmpty()) {
                gdsNames.addAll(Arrays.asList(GdsName.values()));
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return gdsNames;
    }

    public static void configureComboBoxWidget(ComboBoxWidget<GdsName> widget) {
        widget.setAsync(true);
        widget.setItemsSupplier(() -> new ArrayList<GdsName>(GdsSettingsHelper.getGdsNames2()));
        widget.setLive(true);
    }

    public static void configureComboBoxWidgetColumn(ComboBoxWidgetColumn<?, GdsName> widgetColumn) {
        widgetColumn.setAsync(true);
        widgetColumn.setItemsSupplier(() -> new ArrayList<GdsName>(GdsSettingsHelper.getGdsNames2()));
        widgetColumn.setLive(true);
    }
}

