/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.general;

import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcDictHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcEntityHelper;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class GeneralSettingsVM {
    Locale uiLocale;
    Locale dataLocale;
    boolean useSortByLocale;
    final List<String> preferredCurrencies = new ArrayList<String>();
    String equivalentCurrency;
    Double defaultVat;
    EntityReference<Organization> retailClientProfile;
    EntityReference<Organization> anyClientProfile;
    EntityReference<Organization> anyAgencyProfile;
    DictionaryReference<Airline> anyAirlineProfile;
    boolean fillDefaultCostCodesFromProfiles;
    boolean fillDefaultCostCodesFromProducts;
    EntityReference<Organization> aeroexpressProfile;
    EntityReference<Organization> insuranceProfile;
    boolean groupBySubagent;
    boolean messagesInReports;
    String excelPassword;
    boolean restrictedTextSearch;
    boolean worklogEnabled;
    boolean fullAccessToAclEditorEnabled;
    boolean notificationsEnabled;
    boolean enabledRemoteFiscalServiceProvider;
    boolean checkOrganizationsCodeUniqueness;

    static GeneralSettingsVM load() throws Exception {
        GeneralSettingsVM result = new GeneralSettingsVM();
        ClientSettings settings = ClientSettings.get();
        result.uiLocale = settings.getUiLocale();
        result.dataLocale = settings.getDataLocale();
        result.useSortByLocale = settings.isUseSortByLocale();
        result.enabledRemoteFiscalServiceProvider = settings.isEnabledRemoteFiscalServiceProvider();
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
        DictQuery dictQuery = new DictQuery();
        dictQuery.getFields().add(Preference.Property.key.name());
        dictQuery.getFields().add(Preference.Property.value.name());
        for (DictItem dictItem : dictService.search(sic, Preference.class, dictQuery)) {
            PreferenceKey key = (PreferenceKey)dictItem.getFields().get(Preference.Property.key.name());
            String value = (String)dictItem.getFields().get(Preference.Property.value.name());
            if (key == null) continue;
            switch (key) {
                case CURRENCY_CHOICE_SETTINGS: {
                    if (value == null) break;
                    result.preferredCurrencies.addAll(TextUtil.split((String)value, (String)"\\|", (boolean)true, (boolean)true));
                    break;
                }
                case EQUIVE_CURRENCY: {
                    result.equivalentCurrency = value;
                    break;
                }
                case DEFAULT_VAT: {
                    result.defaultVat = Double.valueOf(value);
                    break;
                }
                case RETAIL_PROFILE_CODE: {
                    result.retailClientProfile = RpcEntityHelper.findOrganization(value);
                    break;
                }
                case ALL_CLIENTS_PROFILE_UID: {
                    result.anyClientProfile = RpcEntityHelper.getReference(Organization.class, value);
                    break;
                }
                case ALL_AGENCIES_PROFILE_UID: {
                    result.anyAgencyProfile = RpcEntityHelper.getReference(Organization.class, value);
                    break;
                }
                case ALL_AIRLINES_PROFILE_UID: {
                    result.anyAirlineProfile = RpcDictHelper.getReference(Airline.class, value);
                    break;
                }
                case AEROEXPRESS_PROFILE_UID: {
                    result.aeroexpressProfile = RpcEntityHelper.getReference(Organization.class, value);
                    break;
                }
                case PROGRESS_GARANT_UID: {
                    result.insuranceProfile = RpcEntityHelper.getReference(Organization.class, value);
                    break;
                }
                case XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT: {
                    result.groupBySubagent = "yes".equalsIgnoreCase(value);
                    break;
                }
                case ENABLE_STOCK_CONTROL_MESSAGES_DURING_SALES_REPORT_GENERATION: {
                    result.messagesInReports = Boolean.parseBoolean(value);
                    break;
                }
                case EXCEL_PASSWORD: {
                    result.excelPassword = value;
                    break;
                }
                case RESTRICTED_FREE_TEXT_SEARCH: {
                    result.restrictedTextSearch = Boolean.parseBoolean(value);
                    break;
                }
                case WORKLOG_ENABLED: {
                    result.worklogEnabled = Boolean.parseBoolean(value);
                    break;
                }
                case FULL_ACCESS_TO_FX_ACL_EDITOR: {
                    result.fullAccessToAclEditorEnabled = Boolean.parseBoolean(value);
                    break;
                }
                case NOTIFICATIONS_ENABLED: {
                    result.notificationsEnabled = Boolean.parseBoolean(value);
                    break;
                }
                case FILL_DEFAULT_COST_CODES: {
                    result.fillDefaultCostCodesFromProfiles = Boolean.parseBoolean(value);
                    break;
                }
                case FILL_DEFAULT_COST_CODES_FROM_PRODUCTS: {
                    result.fillDefaultCostCodesFromProducts = Boolean.parseBoolean(value);
                    break;
                }
                case CHECK_ORGANIZATIONS_CODE_UNIQUENESS: {
                    result.checkOrganizationsCodeUniqueness = Boolean.parseBoolean(value);
                }
            }
        }
        return result;
    }

    static void save(GeneralSettingsVM data, Set<SettingsProperty> changes) throws Exception {
        block22: for (SettingsProperty property : changes) {
            switch (property) {
                case clientSettings: {
                    ClientSettings settings = ClientSettings.get();
                    settings.setUiLocale(data.uiLocale);
                    settings.setDataLocale(data.dataLocale);
                    settings.setUseSortByLocale(data.useSortByLocale);
                    settings.setEnabledRemoteFiscalServiceProvider(data.enabledRemoteFiscalServiceProvider);
                    settings.save();
                    continue block22;
                }
                case preferredCurrencies: {
                    String value = data.preferredCurrencies.isEmpty() ? null : String.join((CharSequence)"|", data.preferredCurrencies);
                    PreferenceKey key = PreferenceKey.CURRENCY_CHOICE_SETTINGS;
                    RpcDictHelper.updatePreference(key, value);
                    continue block22;
                }
                case equivalentCurrency: {
                    PreferenceKey key = PreferenceKey.EQUIVE_CURRENCY;
                    RpcDictHelper.updatePreference(key, data.equivalentCurrency == null ? null : data.equivalentCurrency);
                    continue block22;
                }
                case defaultVat: {
                    PreferenceKey key = PreferenceKey.DEFAULT_VAT;
                    RpcDictHelper.updatePreference(key, data.defaultVat == null ? null : data.defaultVat.toString());
                    continue block22;
                }
                case retailClientProfile: {
                    PreferenceKey key = PreferenceKey.RETAIL_PROFILE_CODE;
                    RpcDictHelper.updatePreference(key, data.retailClientProfile == null ? null : RpcEntityHelper.getOrganizationCode(data.retailClientProfile));
                    continue block22;
                }
                case anyClientProfile: {
                    PreferenceKey key = PreferenceKey.ALL_CLIENTS_PROFILE_UID;
                    RpcDictHelper.updatePreference(key, data.anyClientProfile == null ? null : data.anyClientProfile.getUid());
                    continue block22;
                }
                case anyAgencyProfile: {
                    PreferenceKey key = PreferenceKey.ALL_AGENCIES_PROFILE_UID;
                    RpcDictHelper.updatePreference(key, data.anyAgencyProfile == null ? null : data.anyAgencyProfile.getUid());
                    continue block22;
                }
                case anyAirlineProfile: {
                    PreferenceKey key = PreferenceKey.ALL_AIRLINES_PROFILE_UID;
                    RpcDictHelper.updatePreference(key, data.anyAirlineProfile == null ? null : data.anyAirlineProfile.getCode());
                    continue block22;
                }
                case aeroexpressProfile: {
                    PreferenceKey key = PreferenceKey.AEROEXPRESS_PROFILE_UID;
                    RpcDictHelper.updatePreference(key, data.aeroexpressProfile == null ? null : data.aeroexpressProfile.getUid());
                    continue block22;
                }
                case insuranceProfile: {
                    PreferenceKey key = PreferenceKey.PROGRESS_GARANT_UID;
                    RpcDictHelper.updatePreference(key, data.insuranceProfile == null ? null : data.insuranceProfile.getUid());
                    continue block22;
                }
                case groupBySubagent: {
                    PreferenceKey key = PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT;
                    RpcDictHelper.updatePreference(key, data.groupBySubagent ? "yes" : null);
                    continue block22;
                }
                case messagesInReports: {
                    PreferenceKey key = PreferenceKey.ENABLE_STOCK_CONTROL_MESSAGES_DURING_SALES_REPORT_GENERATION;
                    RpcDictHelper.updatePreference(key, data.messagesInReports ? Boolean.TRUE.toString() : null);
                    continue block22;
                }
                case excelPassword: {
                    PreferenceKey key = PreferenceKey.EXCEL_PASSWORD;
                    RpcDictHelper.updatePreference(key, TextUtil.isBlank((String)data.excelPassword) ? null : data.excelPassword);
                    continue block22;
                }
                case restrictedTextSearch: {
                    PreferenceKey key = PreferenceKey.RESTRICTED_FREE_TEXT_SEARCH;
                    RpcDictHelper.updatePreference(key, data.restrictedTextSearch ? Boolean.TRUE.toString() : null);
                    continue block22;
                }
                case worklogEnabled: {
                    PreferenceKey key = PreferenceKey.WORKLOG_ENABLED;
                    RpcDictHelper.updatePreference(key, data.worklogEnabled ? Boolean.TRUE.toString() : null);
                    continue block22;
                }
                case fullAccessToAclEditorEnabled: {
                    PreferenceKey key = PreferenceKey.FULL_ACCESS_TO_FX_ACL_EDITOR;
                    RpcDictHelper.updatePreference(key, data.fullAccessToAclEditorEnabled ? Boolean.TRUE.toString() : null);
                    continue block22;
                }
                case notificationsEnabled: {
                    PreferenceKey key = PreferenceKey.NOTIFICATIONS_ENABLED;
                    RpcDictHelper.updatePreference(key, data.notificationsEnabled ? Boolean.TRUE.toString() : null);
                    continue block22;
                }
                case fillDefaultCostCodesFromProfiles: {
                    PreferenceKey key = PreferenceKey.FILL_DEFAULT_COST_CODES;
                    RpcDictHelper.updatePreference(key, data.fillDefaultCostCodesFromProfiles ? Boolean.TRUE.toString() : null);
                    continue block22;
                }
                case fillDefaultCostCodesFromProducts: {
                    PreferenceKey key = PreferenceKey.FILL_DEFAULT_COST_CODES_FROM_PRODUCTS;
                    RpcDictHelper.updatePreference(key, data.fillDefaultCostCodesFromProducts ? Boolean.TRUE.toString() : null);
                    continue block22;
                }
                case checkOrganizationsCodeUniqueness: {
                    PreferenceKey key = PreferenceKey.CHECK_ORGANIZATIONS_CODE_UNIQUENESS;
                    RpcDictHelper.updatePreference(key, data.checkOrganizationsCodeUniqueness ? Boolean.TRUE.toString() : null);
                    continue block22;
                }
            }
            throw Xeption.forDeveloper((String)"unsupported settings property {0}", (Object[])new Object[]{property});
        }
    }

    private GeneralSettingsVM() {
    }

    static enum SettingsProperty {
        clientSettings,
        preferredCurrencies,
        equivalentCurrency,
        defaultVat,
        retailClientProfile,
        anyClientProfile,
        anyAgencyProfile,
        anyAirlineProfile,
        fillDefaultCostCodesFromProfiles,
        fillDefaultCostCodesFromProducts,
        checkOrganizationsCodeUniqueness,
        aeroexpressProfile,
        insuranceProfile,
        groupBySubagent,
        messagesInReports,
        excelPassword,
        restrictedTextSearch,
        worklogEnabled,
        fullAccessToAclEditorEnabled,
        notificationsEnabled;

    }
}

