/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.paymenttypes;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.system.PaymentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.control.Button;

class PaymentTypesSettingsFullPane
extends GridContainer {
    private final Map<PaymentType, CheckBoxWidget> widgets = new EnumMap<PaymentType, CheckBoxWidget>(PaymentType.class);
    private Set<PaymentType> data;

    PaymentTypesSettingsFullPane() {
        super(4);
        this.setAdaptive(true);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        PaymentType[] arr = new PaymentType[PaymentType.values().length];
        System.arraycopy(PaymentType.values(), 0, arr, 0, arr.length);
        Arrays.sort(arr, (pt1, pt2) -> pt1.toString().compareTo(pt2.toString()));
        Button enableAll = new Button(Messages.Enable_all);
        Button disableAll = new Button(Messages.Disable_all);
        enableAll.setMinWidth(120.0);
        disableAll.setMinWidth(120.0);
        cells.add(new GridCell((Node)enableAll));
        cells.add(GridCell.NEW_ROW_MARKER);
        cells.add(new GridCell((Node)disableAll));
        cells.add(GridCell.NEW_ROW_MARKER);
        for (PaymentType paymentType : arr) {
            CheckBoxWidget widget = new CheckBoxWidget(false);
            widget.setText(paymentType.toString());
            this.widgets.put(paymentType, widget);
            cells.add(new GridCell((Node)widget));
        }
        enableAll.setOnAction(n -> this.widgets.values().forEach(value -> value.setSelected(true)));
        disableAll.setOnAction(n -> this.widgets.values().forEach(value -> value.setSelected(false)));
        this.getCells().addAll(cells);
    }

    int getTotal() {
        return this.widgets.size();
    }

    int getEnabled() {
        return (int)this.widgets.values().stream().filter(widget -> widget.isSelected()).count();
    }

    void readData(Set<PaymentType> model) {
        this.data = model;
        for (Map.Entry<PaymentType, CheckBoxWidget> entry : this.widgets.entrySet()) {
            entry.getValue().setSelected(model.contains(entry.getKey()));
        }
    }

    void writeData(Set<PaymentType> model) {
        model.clear();
        for (Map.Entry<PaymentType, CheckBoxWidget> entry : this.widgets.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            model.add(entry.getKey());
        }
        this.data = model;
    }

    boolean isDataChanged() {
        for (Map.Entry<PaymentType, CheckBoxWidget> entry : this.widgets.entrySet()) {
            if (!(entry.getValue().isSelected() ? this.data == null || !this.data.contains(entry.getKey()) : this.data != null && this.data.contains(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    void setNotEditable(boolean value) {
        for (Map.Entry<PaymentType, CheckBoxWidget> entry : this.widgets.entrySet()) {
            entry.getValue().getViewState().setNotEditable(value);
        }
    }
}

