/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.system;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.TextUtil;

class ProxyData<E extends BaseSystemSettings>
implements Identity {
    final EntityReference<E> reference;
    private String title;
    EntityContainer<E> ctr;
    boolean needSaving;
    Object supplementData;

    ProxyData(EntityReference<E> ref) {
        this.reference = ref;
    }

    String getTitle() {
        return this.title;
    }

    void buildTitle(SystemSettingsType type, String name) {
        if (type == null || type == SystemSettingsType.SCHEDULED_TASK_SETTINGS) {
            this.title = name;
            return;
        }
        this.title = type.toString();
        if (!TextUtil.isBlank((String)name)) {
            this.title = this.title + " \u2014 " + name;
        }
    }

    public String getUid() {
        return this.reference.getUid();
    }

    public void setUid(String uid) {
        this.reference.setUid(uid);
    }

    void load() throws Exception {
        if (this.ctr != null) {
            return;
        }
        Class supplementClass = null;
        RootEntityHandler rootEntityHandler = RootEntityHandler.forEntityClass((Class)this.reference.getType());
        if (rootEntityHandler != null && Void.class.equals((Object)(supplementClass = rootEntityHandler.getSupplementClass()))) {
            supplementClass = null;
        }
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        DataTransferPackage dtp = entityService.load(sic, this.reference, supplementClass);
        this.ctr = dtp.getContainer();
        this.supplementData = dtp.getSupplement();
        if (this.ctr == null) {
            throw Xeption.forAdmin((String)"failed loading system settings for {0}", (Object[])new Object[]{this.reference});
        }
        this.buildTitle(((BaseSystemSettings)this.ctr.getEntity()).getType(), ((BaseSystemSettings)this.ctr.getEntity()).getName());
    }

    void save() throws Exception {
        if (this.ctr == null || !this.needSaving) {
            return;
        }
        this.ctr.getVersionInfo().setDataSource("fx-settings-editor");
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        DataTransferPackage dtp = entityService.save(sic, new DataTransferPackage(this.ctr, this.supplementData), null, true);
        this.ctr = dtp.getContainer();
        this.supplementData = dtp.getSupplement();
        this.buildTitle(((BaseSystemSettings)this.ctr.getEntity()).getType(), ((BaseSystemSettings)this.ctr.getEntity()).getName());
        this.needSaving = false;
    }

    public int hashCode() {
        return this.reference.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProxyData)) {
            return false;
        }
        return this.reference.equals(((ProxyData)obj).reference);
    }
}

