/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.List;
import javafx.scene.Node;

public class AddCertificateOfCompletedFlightTask
extends ClientTask {
    private final String productUid;
    private final EntityReference<BookingFile> bookingFileReference;
    private final RootEntityPane<BookingFile, ?> rootEntityPane;
    private final List<String> usedSegments;

    public AddCertificateOfCompletedFlightTask(String uid, RootEntityPane<BookingFile, ?> entityPane, List<String> usedSegments) {
        this.productUid = uid;
        this.bookingFileReference = entityPane.getData().getContainer().toReference();
        this.rootEntityPane = entityPane;
        this.usedSegments = usedSegments;
    }

    protected void execute() throws Exception {
        try {
            BookingFileService.ProductRPCResult result = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).addCertificateOfCompletedFlight(ServiceInvocationContext.get(), this.productUid, this.bookingFileReference, this.usedSegments);
            if (this.rootEntityPane != null && this.rootEntityPane.getScene() != null && result.getResultProductUid() != null) {
                BookingFileSpace bookingFileSpace = (BookingFileSpace)this.rootEntityPane.getEditor();
                Notifications.get().submitTask(() -> {
                    this.rootEntityPane.reloadData();
                    FxUtil.submitToFxThread(() -> {
                        Node node = UiUtil.findViewWithModelUid((Iterable)((CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent()).getViews(), (String)result.getResultProductUid());
                        if (node != null) {
                            ((CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent()).selectView(node);
                            bookingFileSpace.expand(bookingFileSpace.getProductsTile());
                        }
                    });
                }, this.rootEntityPane.getMutex());
            } else {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.bookingFileReference, EntityModification.ModificationType.CHANGE)));
            }
        }
        catch (Exception e) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.bookingFileReference, EntityModification.ModificationType.CHANGE)));
            ErrorHandler.handle((Throwable)e);
        }
    }

    protected String getTitle() {
        return Messages.addingCertificateOfCompletedFlight;
    }
}

